/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ThinPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_POOLVerAllPool;
import sanproject.common.Robj_interface_POOLVerPool;
import sanproject.common.Robj_interface_VerLeaf;

public class PoolBranchChecker
extends AbstractVersionChecker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processModifiedTPs(String serialNum, LinkedList<Short> modifiedTPs) {
        try {
            ArrayList<ThinPool> addedTPs = new ArrayList<ThinPool>();
            ArrayList<ThinPool> removedTPs = new ArrayList<ThinPool>();
            Serializable[] tps = ThinPool.modifyThinPoolsInCache(modifiedTPs, addedTPs, removedTPs, serialNum);
            CacheUpdater.doCallback((String)serialNum, (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.THINPOOL, (Serializable[])tps);
            if (!addedTPs.isEmpty()) {
                tps = addedTPs.toArray(new ThinPool[addedTPs.size()]);
                CacheUpdater.doCallback((String)serialNum, (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.THINPOOL, (Serializable[])tps);
            }
            if (!removedTPs.isEmpty()) {
                tps = removedTPs.toArray(new ThinPool[removedTPs.size()]);
                CacheUpdater.doCallback((String)serialNum, (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.THINPOOL, (Serializable[])tps);
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying modify thinPools in " + serialNum, e);
        }
        finally {
            modifiedTPs.clear();
        }
    }

    protected PoolBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.POOL, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        Robj_interface_POOLVerAllPool current = (Robj_interface_POOLVerAllPool)currentChildren[0];
        Robj_interface_POOLVerAllPool prev = (Robj_interface_POOLVerAllPool)prevChildren[0];
        if (current.getNVer() != prev.getNVer() || prev.getNSummaryVer() != current.getNSummaryVer()) {
            mLogger.info("Change detected in AllPool branch");
            this.versionChangeChecker(current.getObjChildren(), prev.getObjChildren());
        }
    }

    private void ComparePoolVerPool(Robj_interface_POOLVerPool current, Robj_interface_POOLVerPool previous, short index, LinkedList<Short> addedTPs, LinkedList<Short> modifiedTPs, LinkedList<Short> deletedTPs) {
        if (current != null || previous != null) {
            if (current != null && previous == null) {
                mLogger.info("thinPool: " + index + ", has has been created");
                addedTPs.offer(index);
            } else if (current == null & previous != null) {
                mLogger.info("ThinPool: " + index + ", has been removed");
                deletedTPs.offer(index);
            } else if (current.getNVer() != previous.getNVer()) {
                mLogger.info("Possible change to ThinPool: " + index);
                modifiedTPs.offer(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAddedTPs(LinkedList<Short> addedTPs) {
        try {
            mLogger.info("Adding " + addedTPs.size() + " ThinPools to cache");
            Serializable[] tps = ThinPool.addThinPoolsToCache(addedTPs, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.THINPOOL, (Serializable[])tps);
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying add ThinPools to " + this.getSerialNumber(), e);
        }
        finally {
            addedTPs.clear();
        }
    }

    private void processAffectedTPs(LinkedList<Short> addedTPs, LinkedList<Short> deletedTPs, LinkedList<Short> modifiedTPs) {
        if (deletedTPs != null && deletedTPs.size() > 0) {
            this.processDeletedTPs(deletedTPs);
        }
        if (addedTPs != null && addedTPs.size() > 0) {
            this.processAddedTPs(addedTPs);
        }
        if (modifiedTPs != null && modifiedTPs.size() > 0) {
            PoolBranchChecker.processModifiedTPs(this.getSerialNumber(), modifiedTPs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeletedTPs(LinkedList<Short> deletedTPs) {
        try {
            mLogger.info("Removing " + deletedTPs.size() + " ThinPools from cache");
            Serializable[] tps = ThinPool.removeThinPoolsFromCache(deletedTPs, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.THINPOOL, (Serializable[])tps);
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying remove ThinPools from " + this.getSerialNumber(), e);
        }
        finally {
            deletedTPs.clear();
        }
    }

    private void versionChangeChecker(Robj_interface_VerLeaf[] current, Robj_interface_VerLeaf[] previous) {
        Robj_interface_POOLVerPool[] currentPoolVer = (Robj_interface_POOLVerPool[])current;
        Robj_interface_POOLVerPool[] previousPoolVer = (Robj_interface_POOLVerPool[])previous;
        LinkedList<Short> modifiedTPs = new LinkedList<Short>();
        LinkedList<Short> deletedTPs = new LinkedList<Short>();
        LinkedList<Short> addedTPs = new LinkedList<Short>();
        for (short index = 0; index < current.length; index = (short)(index + 1)) {
            this.ComparePoolVerPool(currentPoolVer[index], previousPoolVer[index], index, addedTPs, modifiedTPs, deletedTPs);
        }
        this.processAffectedTPs(addedTPs, deletedTPs, modifiedTPs);
    }
}

