/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache.comparator;

import com.hitachi.smi.cache.comparator.HitachiCacheComparator;
import com.hitachi.smi.common.ChassisArrayGroup;
import java.util.logging.Level;

public class CAGComparator<E extends ChassisArrayGroup>
implements HitachiCacheComparator<E> {
    private final int fb4;
    private final int pg;
    private final int vdev;
    private final int arrayGroup;

    public CAGComparator(int fb4) {
        this(fb4, -1, -1, -1);
    }

    public CAGComparator(int fb4, int pg) {
        this(fb4, pg, -1, -1);
    }

    public CAGComparator(int fb4, int pg, int vdev, int arrayGroup) {
        this.fb4 = fb4;
        this.pg = pg;
        this.vdev = vdev;
        this.arrayGroup = arrayGroup;
    }

    @Override
    public boolean isMatch(E compared) {
        mLogger.log(Level.FINER, "Match {0} to values {1}", new Object[]{compared, this});
        boolean ret = this.fb4 == ((ChassisArrayGroup)compared).getFb4();
        mLogger.log(Level.FINE, "Does FB4 value ({0}) match CAG {1}: {2}", new Object[]{this.fb4, ((ChassisArrayGroup)compared).getFb4(), ret});
        if (ret) {
            if (-1 != this.arrayGroup) {
                ret = this.arrayGroup == ((ChassisArrayGroup)compared).getArrayGroup();
                mLogger.log(Level.FINE, "Does ArrayGroup value ({0}) match CAG {1}: {2}", new Object[]{this.arrayGroup, ((ChassisArrayGroup)compared).getArrayGroup(), ret});
            }
            if (ret && -1 != this.pg) {
                ret = this.pg == ((ChassisArrayGroup)compared).getPg();
                mLogger.log(Level.FINE, "Does PG value ({0}) match CAG {1}: {2}", new Object[]{this.pg, ((ChassisArrayGroup)compared).getPg(), ret});
            }
            if (ret && -1 != this.vdev) {
                ret = this.vdev == ((ChassisArrayGroup)compared).getVdev();
                mLogger.log(Level.FINE, "Does VDEV value ({0}) match CAG {1}: {2}", new Object[]{this.vdev, ((ChassisArrayGroup)compared).getVdev(), ret});
            }
        }
        mLogger.log(Level.FINE, "CAGComparator returning {0} for CAG {1}", new Object[]{ret, ((ChassisArrayGroup)compared).getArrayGroup()});
        return ret;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CAGComparator [fb4=");
        builder.append(this.fb4);
        if (-1 != this.pg) {
            builder.append(", pg=");
            builder.append(this.pg);
        }
        if (-1 != this.vdev) {
            builder.append(", vdev=");
            builder.append(this.vdev);
        }
        if (-1 != this.arrayGroup) {
            builder.append(", arrayGroup=");
            builder.append(this.arrayGroup);
        }
        builder.append("]");
        return builder.toString();
    }
}

