/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.cache.comparator.CAGComparator;
import com.hitachi.smi.cache.comparator.HitachiCacheComparator;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJSetGettingParamDevice;
import sanproject.common.Robj_interface_RJiVDEVIndex;
import sanproject.common.Robj_interface_RJiVDEVInfoDetail;
import sanproject.common.Robj_interface_RJiVDEVLDEVInfoDetail;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class ChassisArrayGroup
extends AbstractBaseCommonObject
implements Serializable {
    public static final String CHASSIS_ARRAY_ID = "ChassisArrayID";
    private static final long serialVersionUID = 1L;
    private static final String CAG = "CAG:";
    private static final Class<ChassisArrayGroup[]> clz = ChassisArrayGroup[].class;
    private static Map<String, DeviceFB4PGInfo> fb4PGInfo = new HashMap<String, DeviceFB4PGInfo>();
    protected int arrayGroup;
    protected UnsignedInteger64 blockSize;
    protected int fb4;
    protected UnsignedInteger64 numConsumableBlocks;
    protected int pg;
    protected String raidLevel;
    protected int seqNum;
    protected boolean valid;
    protected boolean aouVol;
    protected boolean externalVol;
    protected boolean qsVvol;
    protected boolean vVol;
    protected boolean normalVol;
    protected boolean mFICON_DMVol;
    private UnsignedInteger16 consistsOf;
    private UnsignedInteger64 numFreeBlocks;
    private boolean isContainedDNsOpenVolume;
    List<BaseDeviceNumber> containedDNs;
    List<UnsignedInteger64> containedFreeSpace;
    protected int vdev;

    public static ChassisArrayGroup[] addCAGToCache(AbstractMap<Integer, List<Integer>> added, String serialNum) throws WBEMException {
        ArrayList<ChassisArrayGroup> ret = new ArrayList<ChassisArrayGroup>();
        try {
            ClosableAddableIteratorCB<ChassisArrayGroup> callback = new ClosableAddableIteratorCB<ChassisArrayGroup>();
            RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
            ChassisArrayGroup.getUnCachedChassisArrayGroup(mapping.getRMIObject(), callback, false, -1, -1, -1, -1);
            CloseableAddableIterator<ChassisArrayGroup> actualCAGs = callback.getWrappedCloseableAddableIter();
            ProviderLibs.sortHashMapList(added);
            DeviceFB4PGInfo fb4PgInfo = ChassisArrayGroup.getDeviceFB4PGInfo(mapping.getRMIObject());
            while (actualCAGs.hasNext()) {
                ChassisArrayGroup actualCAG = (ChassisArrayGroup)actualCAGs.next();
                List<Integer> newCags = added.get(actualCAG.getFb4());
                if (newCags == null || Collections.binarySearch(newCags, actualCAG.getArrayGroup()) < 0) continue;
                HashMap cagMap = new HashMap();
                ret.add(actualCAG);
                ChassisArrayGroup.addCAGToMap(cagMap, actualCAG);
                fb4PgInfo.setUsed(actualCAG.getFb4(), actualCAG.getPg());
                CacheLib.addDataToCache(cagMap, Arrays.asList(actualCAG), clz, serialNum);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add CAG to cache" + t, null, t);
        }
        return ret.toArray(new ChassisArrayGroup[ret.size()]);
    }

    private static void addCAGToMap(HashMap<String, List<ChassisArrayGroup>> cagMap, ChassisArrayGroup cag) {
        String key = CacheLib.getCAGFB4String(CAG, cag.getFb4());
        CacheLib.addToMap(cagMap, key, cag);
        key = null;
        key = CacheLib.getCAGString(CAG, cag.getFb4(), cag.getArrayGroup());
        CacheLib.addToMap(cagMap, key, cag);
        key = null;
        key = CacheLib.getFB4PgString(CAG, cag.getFb4(), cag.getPg());
        CacheLib.addToMap(cagMap, key, cag);
        key = null;
        key = CacheLib.getCAGFB4PgVdevString(CAG, cag.getFb4(), cag.getPg(), cag.getVdev());
        CacheLib.addToMap(cagMap, key, cag);
        key = null;
        key = CacheLib.getCAGAllString(CAG, cag.getFb4(), cag.getPg(), cag.getVdev(), cag.getArrayGroup());
        CacheLib.addToMap(cagMap, key, cag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException {
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        DeviceFB4PGInfo localFB4PGInfo = ChassisArrayGroup.getDeviceFB4PGInfo(rmiObj);
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<ChassisArrayGroup> clazz = ChassisArrayGroup.class;
            synchronized (ChassisArrayGroup.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<ChassisArrayGroup> callback = new ClosableAddableIteratorCB<ChassisArrayGroup>();
                    ChassisArrayGroup.getUnCachedChassisArrayGroup(rmiObj, callback, false, -1, -1, -1, -1);
                    ArrayList<ChassisArrayGroup> cags = new ArrayList<ChassisArrayGroup>();
                    HashMap cagMap = new HashMap();
                    CloseableAddableIterator<ChassisArrayGroup> iter = callback.getWrappedCloseableAddableIter();
                    while (iter.hasNext()) {
                        ChassisArrayGroup cag = (ChassisArrayGroup)iter.next();
                        cags.add(cag);
                        localFB4PGInfo.setUsed(cag.getFb4(), cag.getPg());
                    }
                    CacheLib.addDataToCache(cagMap, cags, clz, rmiMapping.getSerialNumber());
                } else {
                    cacheLogger.warning("ChassisArrayGroup is already in the cache");
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else {
            cacheLogger.warning("ChassisArrayGroup is already in the cache");
        }
    }

    public static UnsignedInteger64 doNumberOfBlocks(long numOfBytes, UnsignedInteger64 blockSize) {
        long numKBytes = ProviderLibs.toKBytes(numOfBytes);
        long value = numKBytes * 1024L / blockSize.longValue();
        BigInteger temp = BigInteger.valueOf(value);
        UnsignedInteger64 ret = new UnsignedInteger64(temp);
        return ret;
    }

    public static ChassisArrayGroup find(RMIObjectCache rmiobj, boolean isObjectPath, String chassisArrayID) throws WBEMException {
        return ChassisArrayGroup.find(rmiobj, chassisArrayID, -1, -1, isObjectPath);
    }

    public static ChassisArrayGroup find(RMIObjectCache rmiobj, Integer chassis, Integer pg, boolean isObjectPath) throws WBEMException {
        if (null == rmiobj) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        ChassisArrayGroup ret = null;
        try {
            short fb4 = chassis == null ? (short)-1 : (short)chassis.shortValue();
            short thePG = pg == null ? (short)-1 : (short)pg.shortValue();
            FindCAGCallback callback = new FindCAGCallback(rmiobj.getSMISMappingContainer().getSerialNumber(), fb4, thePG, -1, -1);
            ChassisArrayGroup.getChassisArrayGroup(rmiobj, callback, isObjectPath, fb4, thePG, -1, -1);
            ret = (ChassisArrayGroup)callback.getReturnValue();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    public static ChassisArrayGroup find(RMIObjectCache rmiobj, String chassisArrayID, Integer chassis, Integer arrayGroup, boolean isObjectPath) throws WBEMException {
        if (null == rmiobj) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        ChassisArrayGroup ret = null;
        try {
            if (chassisArrayID != null) {
                Integer[] idx = ProviderLibs.getInstanceIDInts(chassisArrayID);
                chassis = idx[0];
                arrayGroup = idx[1];
            }
            short ag = arrayGroup == null ? (short)-1 : (short)arrayGroup.shortValue();
            short fb4 = chassis == null ? (short)-1 : (short)chassis.shortValue();
            FindCAGCallback callback = new FindCAGCallback(rmiobj.getSMISMappingContainer().getSerialNumber(), fb4, -1, -1, ag);
            ChassisArrayGroup.getChassisArrayGroup(rmiobj, callback, isObjectPath, fb4, -1, -1, ag);
            ret = (ChassisArrayGroup)callback.getReturnValue();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    public static int[] getAvailableFB4PG(RMIObjectCache rmiObj) throws WBEMException {
        int[] ret = null;
        DeviceFB4PGInfo fb4PgInfo = ChassisArrayGroup.getDeviceFB4PGInfo(rmiObj);
        for (int fb4 = 1; fb4 < fb4PgInfo.getMaxFB4Num() && null == ret; ++fb4) {
            for (int pg = 1; pg < fb4PgInfo.getMaxPGNum() && null == ret; ++pg) {
                if (!fb4PgInfo.isAvailable(fb4, pg)) continue;
                ret = new int[]{fb4, pg};
                fb4PgInfo.setUsed(fb4, pg);
            }
        }
        return ret;
    }

    private static void getChassisArrayGroup(IteratorCallback<ChassisArrayGroup> callback, boolean isObjectPath, int pFB4, int pPG, int pVdev, int pAG) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                ChassisArrayGroup.getChassisArrayGroup(mapObj.getRMIObject(), callback, isObjectPath, pFB4, pPG, pVdev, pAG);
                continue;
            }
            providerLogger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static void getChassisArrayGroup(RMIObjectCache rmiobj, IteratorCallback<ChassisArrayGroup> callback, boolean isObjectPath) throws WBEMException {
        ChassisArrayGroup.getChassisArrayGroup(rmiobj, callback, isObjectPath, -1, -1, -1, -1);
    }

    public static void getChassisArrayGroup(RMIObjectCache rmiobj, IteratorCallback<ChassisArrayGroup> callback, boolean isObjectPath, int pFB4) throws WBEMException {
        ChassisArrayGroup.getChassisArrayGroup(rmiobj, callback, isObjectPath, pFB4, -1, -1, -1);
    }

    public static void getChassisArrayGroup(RMIObjectCache rmiobj, IteratorCallback<ChassisArrayGroup> callback, boolean isObjectPath, int pFB4, int pPG) throws WBEMException {
        ChassisArrayGroup.getChassisArrayGroup(rmiobj, callback, isObjectPath, pFB4, pPG, -1, -1);
    }

    public static void getChassisArrayGroup(RMIObjectCache rmiObj, IteratorCallback<ChassisArrayGroup> callback, boolean isObjectPath, int pFB4, int pPG, int pVdev, int pAG) throws WBEMException {
        if (null == rmiObj) {
            ChassisArrayGroup.getChassisArrayGroup(callback, isObjectPath, pFB4, pPG, pVdev, pAG);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] cags = null;
            CAGComparator lookup = -1 == pFB4 ? null : new CAGComparator(pFB4, pPG, pVdev, pAG);
            cags = (ChassisArrayGroup[])cache.getCachedObject(clz);
            if (cags != null) {
                callback.returnItems(cags, lookup);
            } else {
                providerLogger.warning("No ChassisArrayGroups (VDEVs) in cache");
                callback.done();
            }
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "ChassisArrayGroup not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            ChassisArrayGroup.getUnCachedChassisArrayGroup(rmiObj, callback, isObjectPath, pFB4, pPG, pVdev, pAG);
        }
    }

    public static void getChassisArrayGroup(RMIObjectCache rmiobj, IteratorCallback<ChassisArrayGroup> callback, boolean isObjectPath, String chassisArrayID) throws WBEMException {
        try {
            Integer[] idx = ProviderLibs.getInstanceIDInts(chassisArrayID);
            if (idx[0] >= 0 && idx[1] >= 0) {
                ChassisArrayGroup.getChassisArrayGroup(rmiobj, callback, isObjectPath, idx[0], -1, -1, idx[1]);
            } else {
                WBEMException we = new WBEMException(1, "Invalid chassis ID: " + chassisArrayID);
                callback.exceptionOccurred(we);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            WBEMException we = new WBEMException(1, e.toString(), null, e);
            callback.exceptionOccurred(we);
        }
    }

    private static synchronized DeviceFB4PGInfo getDeviceFB4PGInfo(RMIObjectCache rmiObj) throws WBEMException {
        String serial = rmiObj.getSMISMappingContainer().getSerialNumber();
        DeviceFB4PGInfo ret = fb4PGInfo.get(serial);
        if (null == ret) {
            ret = new DeviceFB4PGInfo(serial);
            fb4PGInfo.put(serial, ret);
        }
        return ret;
    }

    private static fsIndexAndNumBlocks getFSIndexANDFreeSpace(Robj_interface_RJiVDEVInfoDetail detail, String serialNum) throws RemoteException, GetRmiException, WBEMException {
        UnsignedInteger64 theBlockSize = ProviderConstants.UINT64_512;
        long numConsumableBlocks = 0L;
        ArrayList<UnsignedInteger64> freeSpaces = new ArrayList<UnsignedInteger64>();
        boolean openVolume = true;
        Robj_interface_RJiVDEVLDEVInfoDetail[] lDevInfos = detail.getObjVDEVLDEVInfo();
        ArrayList<BaseDeviceNumber> dns = new ArrayList<BaseDeviceNumber>(lDevInfos.length);
        if (lDevInfos.length > 0) {
            for (Robj_interface_RJiVDEVLDEVInfoDetail lDevInfo : lDevInfos) {
                byte lDevStatus = lDevInfo.getByLDEVStatus();
                if (3 == lDevStatus) {
                    long lbaSize = lDevInfo.getLTotalLBASize();
                    UnsignedInteger64 size = new UnsignedInteger64(BigInteger.valueOf(lbaSize));
                    freeSpaces.add(size);
                    numConsumableBlocks += lbaSize;
                    String emulation = BaseDeviceNumber.getEmulationTypeStr(lDevInfo.getIEmulationType());
                    if (emulation.startsWith("OPEN")) continue;
                    theBlockSize = ProviderConstants.UINT64_ONE;
                    openVolume = false;
                    continue;
                }
                BaseDeviceNumber bdn = new BaseDeviceNumber(serialNum, lDevInfo.getSLDKC(), lDevInfo.getSLDEV(), lDevInfo.getSCU(), lDevInfo.getIEmulationType());
                DeviceNumber dn = DeviceNumber.find(bdn.getDNAsString(), true, RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject());
                if (dn == null) continue;
                numConsumableBlocks += dn.getNumOfBlocksAsLong();
                if (dns.size() == 0) {
                    openVolume = bdn.getEmulationType().startsWith("OPEN");
                    theBlockSize = dn.getBlockSize();
                }
                dns.add(bdn);
            }
        } else {
            long vdevSize = detail.getLVDEVLBASize();
            long vdevSizeInKBytes = ProviderLibs.toKBytes(vdevSize);
            numConsumableBlocks = vdevSizeInKBytes / theBlockSize.longValue();
            freeSpaces.add(new UnsignedInteger64(BigInteger.valueOf(vdevSize)));
        }
        return new fsIndexAndNumBlocks(numConsumableBlocks, theBlockSize, freeSpaces, openVolume, dns);
    }

    private static void getUnCachedChassisArrayGroup(RMIObjectCache rmiobj, IteratorCallback<ChassisArrayGroup> callback, boolean isObjectPath, int pFB4, int pPG, int pVdev, int pAG) throws WBEMException {
        block5: {
            try {
                Robj_interface_RJSetGettingParamDevice param = (Robj_interface_RJSetGettingParamDevice)rmiobj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.SetGettingParam);
                param.setBAllDevice(true);
                Robj_interface_RJiVDEVIndex[] vdevs = rmiobj.getVDEVIndex(param);
                Robj_interface_RJiVDEVInfoDetail[] details = rmiobj.getVDEVInfoDetail(vdevs);
                cacheLogger.log(Level.INFO, "Found {0} VDEVInfo (ChassisArrayGroup)", details.length);
                if (details.length > 0) {
                    TaskProcessor task = new TaskProcessor("CAG: - " + rmiobj.getSMISMappingContainer().getSerialNumber(), details.length);
                    for (Robj_interface_RJiVDEVInfoDetail idx : details) {
                        if (task.shouldStop()) {
                            callback.done();
                            break block5;
                        }
                        WorkerThread worker = new WorkerThread(callback, rmiobj, idx, isObjectPath, task, pFB4, pPG, pVdev, pAG);
                        task.addTask(worker);
                    }
                    break block5;
                }
                callback.done();
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                callback.exceptionOccurred(we);
                callback.done();
            }
        }
    }

    public static int makeArrayGroup(int fb4, int pg, int vdev) {
        return ChassisArrayGroup.makeArrayGroup(fb4, pg, vdev, false);
    }

    public static int makeArrayGroup(int fb4, int pg, int vdev, boolean isPool) {
        if (65 <= fb4 && fb4 <= 96 || 16485 <= fb4 && fb4 <= 16516) {
            return -1;
        }
        return pg;
    }

    public static ChassisArrayGroup[] modifyCAGInCache(AbstractMap<Integer, List<Integer>> added, String serialNum) throws WBEMException {
        ArrayList<ChassisArrayGroup> ret = new ArrayList<ChassisArrayGroup>();
        try {
            ChassisArrayGroup actualCAG;
            CommonClassAsList<ChassisArrayGroup> callback = new CommonClassAsList<ChassisArrayGroup>();
            ChassisArrayGroup.getUnCachedChassisArrayGroup(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), callback, false, -1, -1, -1, -1);
            LinkedList<ChassisArrayGroup> actualCAGs = callback.getReturnValue();
            callback = null;
            ProviderLibs.sortHashMapList(added);
            while ((actualCAG = (ChassisArrayGroup)actualCAGs.poll()) != null) {
                List<Integer> modCags = added.get(actualCAG.getFb4());
                if (null == modCags || Collections.binarySearch(modCags, actualCAG.getArrayGroup()) < 0) continue;
                ChassisArrayGroup cachedCAG = ChassisArrayGroup.find(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), null, actualCAG.getFb4(), actualCAG.getArrayGroup(), false);
                if (null != cachedCAG) {
                    if (cachedCAG.equals(actualCAG)) continue;
                    ChassisArrayGroup cacheCopy = new ChassisArrayGroup(serialNum, actualCAG.getFb4(), actualCAG.getPg());
                    cacheCopy.copyCAG(cachedCAG);
                    cachedCAG.copyCAG(actualCAG);
                    ret.add(cacheCopy);
                    continue;
                }
                cacheLogger.severe("The CAG( " + actualCAG.getFb4() + ") could not be modified as it was not in the cache.");
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add CAG to cache" + t, null, t);
        }
        return ret.toArray(new ChassisArrayGroup[ret.size()]);
    }

    public static boolean processInfoDetail(IteratorCallback<ChassisArrayGroup> callback, RMIObjectCache rmiobj, Robj_interface_RJiVDEVInfoDetail theVal, boolean isObjectPath, String deviceIDKeyVal, boolean hasProperties, int pFB4, int pPG, int pVdev, int pAG) {
        boolean ret = true;
        try {
            int fb4 = theVal.getIFB4();
            int pg = theVal.getIPG();
            int vdev = theVal.getIVDEV();
            byte compare = ProviderLibs.isSameValues(pFB4, pPG, -1, fb4, pg, -1);
            String serialNum = rmiobj.getSMISMappingContainer().getSerialNumber();
            if (compare == 0) {
                fsIndexAndNumBlocks blockData = 16485 <= fb4 && fb4 <= 16516 ? null : ChassisArrayGroup.getFSIndexANDFreeSpace(theVal, serialNum);
                ChassisArrayGroup cag = new ChassisArrayGroup(serialNum, fb4, pg, vdev, blockData);
                if (-1 == pAG || pAG == cag.getArrayGroup()) {
                    if (cag.isValid() && ResourceRestriction.isPoolUsable(serialNum, fb4, pg)) {
                        cag.aouVol = theVal.isAOUVvol();
                        cag.externalVol = theVal.isExternalVolume();
                        cag.qsVvol = theVal.isQSVvol();
                        cag.vVol = theVal.isVvol();
                        cag.normalVol = theVal.isNormalVolume();
                        cag.mFICON_DMVol = ProviderLibs.isFICONDM(cag.getFb4());
                        cag.consistsOf = ProviderLibs.consistsOf(rmiobj, cag.getFb4(), cag.getPg());
                        cag.seqNum = ProviderLibs.getRAIDLevel(rmiobj, cag.getFb4(), cag.getPg());
                        cag.raidLevel = ProviderLibs.getRaidLevelAsString(rmiobj, cag.seqNum);
                        cag.setBlockSize(rmiobj);
                        ret = callback.returnItem(cag);
                    } else {
                        cacheLogger.log(Level.FINE, "Skipping CAG, {0}-{1}, isValid({2}), restricted", new Object[]{cag.getFb4(), cag.getPg(), cag.isValid()});
                    }
                } else {
                    cacheLogger.log(Level.FINE, "Skipping CAG {0}", cag.getArrayGroup());
                }
            }
        }
        catch (Throwable e) {
            WBEMException we = new WBEMException(1, e.toString(), null, e);
            callback.exceptionOccurred(we);
            ret = false;
        }
        return ret;
    }

    public static ChassisArrayGroup[] removeCAGFromCache(AbstractMap<Integer, List<Integer>> removed, String serialNum) throws WBEMException {
        ArrayList<ChassisArrayGroup> ret = new ArrayList<ChassisArrayGroup>();
        try {
            DeviceFB4PGInfo fb4PgInfo = ChassisArrayGroup.getDeviceFB4PGInfo(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject());
            Set<Integer> keys = removed.keySet();
            for (Integer key : keys) {
                List<Integer> removedList = removed.get(key);
                cacheLogger.info("Removing " + removedList.size() + " ChassisArrayGroups from cache.");
                for (Integer removedArrayGrpNum : removedList) {
                    ChassisArrayGroup cached = ChassisArrayGroup.find(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), null, key, removedArrayGrpNum, false);
                    if (cached != null) {
                        ret.add(cached);
                        HashMap<String, List<ChassisArrayGroup>> cagMap = new HashMap<String, List<ChassisArrayGroup>>();
                        ChassisArrayGroup.addCAGToMap(cagMap, cached);
                        CacheLib.removeDataFromCache(cagMap, (Serializable[])new ChassisArrayGroup[]{cached}, clz, (String)serialNum);
                        fb4PgInfo.removeUsed(cached.getFb4(), cached.getPg());
                        continue;
                    }
                    cacheLogger.log(Level.INFO, "Unable to remove CAG({0}, {1}) from cache as it was not in the cache", new Object[]{key, removedArrayGrpNum});
                }
                cacheLogger.info("Done processing ChassisArrayGroups");
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add CAG to cache" + t, null, t);
        }
        return ret.toArray(new ChassisArrayGroup[ret.size()]);
    }

    protected ChassisArrayGroup(String serialNum, int fb4, int pg) {
        this(serialNum, fb4, pg, -1, null);
    }

    private ChassisArrayGroup(String serialNum, int fb4, int pg, int vdev, fsIndexAndNumBlocks fsIndex) {
        super(serialNum);
        this.fb4 = fb4;
        this.pg = pg;
        this.vdev = vdev;
        this.arrayGroup = ChassisArrayGroup.makeArrayGroup(fb4, pg, vdev);
        if (this.arrayGroup >= 0) {
            UnsignedInteger64 cb;
            this.isContainedDNsOpenVolume = fsIndex == null ? false : fsIndex.mIsOpenVolume;
            this.containedDNs = fsIndex == null ? new ArrayList(0) : fsIndex.mContainDNs;
            this.mFICON_DMVol = false;
            this.normalVol = false;
            this.vVol = false;
            this.qsVvol = false;
            this.externalVol = false;
            this.aouVol = false;
            this.numConsumableBlocks = cb = fsIndex == null ? ProviderConstants.UINT64_ZED : new UnsignedInteger64(BigInteger.valueOf(fsIndex.mNumConsumableBlocks));
            this.containedFreeSpace = fsIndex == null ? new ArrayList(0) : fsIndex.mContainedFS;
            this.blockSize = fsIndex == null ? ProviderConstants.UINT64_512 : fsIndex.mBlockSize;
            this.raidLevel = null;
            this.seqNum = -1;
            this.valid = true;
            this.consistsOf = null;
        }
    }

    protected void copyCAG(ChassisArrayGroup other) {
        this.aouVol = other.aouVol;
        this.arrayGroup = other.arrayGroup;
        this.blockSize = other.blockSize;
        this.consistsOf = other.consistsOf;
        this.externalVol = other.externalVol;
        this.fb4 = other.fb4;
        this.isContainedDNsOpenVolume = other.isContainedDNsOpenVolume();
        this.normalVol = other.normalVol;
        this.numConsumableBlocks = other.numConsumableBlocks;
        this.numFreeBlocks = other.numFreeBlocks;
        this.pg = other.pg;
        this.qsVvol = other.qsVvol;
        this.mFICON_DMVol = other.mFICON_DMVol;
        this.raidLevel = other.raidLevel;
        this.seqNum = other.seqNum;
        this.vVol = other.vVol;
        this.valid = other.valid;
        this.vdev = other.vdev;
        if (this.containedDNs == null) {
            this.containedDNs = new ArrayList<BaseDeviceNumber>(other.containedDNs.size());
        }
        this.containedDNs.clear();
        this.containedDNs.addAll(other.containedDNs);
        if (this.containedFreeSpace == null) {
            this.containedFreeSpace = new ArrayList<UnsignedInteger64>(other.containedFreeSpace.size());
        }
        this.containedFreeSpace.clear();
        for (UnsignedInteger64 value : other.containedFreeSpace) {
            this.containedFreeSpace.add(new UnsignedInteger64(BigInteger.valueOf(value.longValue())));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChassisArrayGroup other = (ChassisArrayGroup)obj;
        if (this.aouVol != other.aouVol) {
            return false;
        }
        if (this.arrayGroup != other.arrayGroup) {
            return false;
        }
        if (this.blockSize == null ? other.blockSize != null : !this.blockSize.equals((Object)other.blockSize)) {
            return false;
        }
        if (this.consistsOf == null ? other.consistsOf != null : !this.consistsOf.equals((Object)other.consistsOf)) {
            return false;
        }
        if (this.containedDNs == null ? other.containedDNs != null : !this.containedDNs.equals(other.containedDNs)) {
            return false;
        }
        if (this.containedFreeSpace == null ? other.containedFreeSpace != null : !this.containedFreeSpace.equals(other.containedFreeSpace)) {
            return false;
        }
        if (this.externalVol != other.externalVol) {
            return false;
        }
        if (this.fb4 != other.fb4) {
            return false;
        }
        if (this.isContainedDNsOpenVolume != other.isContainedDNsOpenVolume) {
            return false;
        }
        if (this.normalVol != other.normalVol) {
            return false;
        }
        if (this.numConsumableBlocks == null ? other.numConsumableBlocks != null : !this.numConsumableBlocks.equals((Object)other.numConsumableBlocks)) {
            return false;
        }
        if (this.numFreeBlocks == null ? other.numFreeBlocks != null : !this.numFreeBlocks.equals((Object)other.numFreeBlocks)) {
            return false;
        }
        if (this.pg != other.pg) {
            return false;
        }
        if (this.qsVvol != other.qsVvol) {
            return false;
        }
        if (this.mFICON_DMVol != other.mFICON_DMVol) {
            return false;
        }
        if (this.raidLevel == null ? other.raidLevel != null : !this.raidLevel.equals(other.raidLevel)) {
            return false;
        }
        if (this.seqNum != other.seqNum) {
            return false;
        }
        if (this.vVol != other.vVol) {
            return false;
        }
        if (this.valid != other.valid) {
            return false;
        }
        return this.vdev == other.vdev;
    }

    public int getArrayGroup() {
        return this.arrayGroup;
    }

    public UnsignedInteger64 getBlockSize() {
        return this.blockSize;
    }

    public int getChassis() {
        return this.fb4;
    }

    public String getChassisArrayID() {
        return this.fb4 + "." + this.arrayGroup;
    }

    public UnsignedInteger16 getConsistsOf(RMIObjectCache rmiobj) throws RemoteException, SANRmiException {
        UnsignedInteger16 ret = this.consistsOf;
        if (ret == null) {
            ret = rmiobj != null ? (this.consistsOf = ProviderLibs.consistsOf(rmiobj, this.getFb4(), this.getPg())) : ProviderConstants.UINT16_ZED;
        }
        return ret;
    }

    public UnsignedInteger64 getConsumableblocks() {
        return this.getNumberOfBlocks();
    }

    public List<BaseDeviceNumber> getContainedDNs() {
        return this.containedDNs;
    }

    public List<UnsignedInteger64> getContainedFreeSpaces() {
        return this.containedFreeSpace;
    }

    public int getFb4() {
        return this.fb4;
    }

    public int getFsIndex() {
        return this.containedFreeSpace.size();
    }

    public UnsignedInteger64 getLargestFreeSpace() {
        UnsignedInteger64 ret = ProviderConstants.UINT64_ZED;
        for (UnsignedInteger64 freeSpaceSize : this.containedFreeSpace) {
            if (ret.compareTo(freeSpaceSize) > 0) continue;
            ret = freeSpaceSize;
        }
        return ret;
    }

    public UnsignedInteger64 getNumberOfBlocks() {
        return this.numConsumableBlocks;
    }

    public UnsignedInteger64 getNumFreeBlocks(int fsIndex) {
        UnsignedInteger64 fs;
        UnsignedInteger64 ret = ProviderConstants.UINT64_ZED;
        if (fsIndex >= 0 && fsIndex < this.containedFreeSpace.size() && (fs = this.containedFreeSpace.get(fsIndex)) != null) {
            ret = fs;
        }
        return ret;
    }

    public int getPg() {
        return this.pg;
    }

    public String getRaidLevel() {
        return this.raidLevel;
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public UnsignedInteger64 getTotalNumFreeBlocks() {
        long totValue = 0L;
        for (UnsignedInteger64 value : this.containedFreeSpace) {
            totValue += value.longValue();
        }
        return new UnsignedInteger64(BigInteger.valueOf(totValue));
    }

    public int getVdev() {
        return this.vdev;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aouVol ? 1231 : 1237);
        result = 31 * result + this.arrayGroup;
        result = 31 * result + (this.blockSize == null ? 0 : this.blockSize.hashCode());
        result = 31 * result + (this.consistsOf == null ? 0 : this.consistsOf.hashCode());
        result = 31 * result + (this.containedDNs == null ? 0 : this.containedDNs.hashCode());
        result = 31 * result + (this.containedFreeSpace == null ? 0 : this.containedFreeSpace.hashCode());
        result = 31 * result + (this.externalVol ? 1231 : 1237);
        result = 31 * result + this.fb4;
        result = 31 * result + (this.isContainedDNsOpenVolume ? 1231 : 1237);
        result = 31 * result + (this.normalVol ? 1231 : 1237);
        result = 31 * result + (this.numConsumableBlocks == null ? 0 : this.numConsumableBlocks.hashCode());
        result = 31 * result + (this.numFreeBlocks == null ? 0 : this.numFreeBlocks.hashCode());
        result = 31 * result + this.pg;
        result = 31 * result + (this.qsVvol ? 1231 : 1237);
        result = 31 * result + (this.mFICON_DMVol ? 1231 : 1237);
        result = 31 * result + (this.raidLevel == null ? 0 : this.raidLevel.hashCode());
        result = 31 * result + this.seqNum;
        result = 31 * result + (this.vVol ? 1231 : 1237);
        result = 31 * result + (this.valid ? 1231 : 1237);
        result = 31 * result + this.vdev;
        return result;
    }

    public boolean isAouVol() {
        return this.aouVol;
    }

    public boolean isContainedDNsOpenVolume() {
        return this.isContainedDNsOpenVolume;
    }

    public boolean isExternalVol() {
        return this.externalVol;
    }

    public boolean isFICONDMVol() {
        return this.mFICON_DMVol;
    }

    public boolean isNormalVol() {
        return this.normalVol;
    }

    public boolean isQsVvol() {
        return this.qsVvol;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isvVol() {
        return this.vVol;
    }

    protected void setBlockSize(RMIObjectCache rmiobj) throws RemoteException, SANRmiException, WBEMException {
        this.blockSize = ProviderConstants.UINT64_512;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChassisArrayGroup [arrayGroup=");
        builder.append(this.arrayGroup);
        builder.append(", serialNumber=");
        builder.append(this.getSerialNumber());
        builder.append(", blockSize=");
        builder.append(this.blockSize);
        builder.append(", fb4=");
        builder.append(this.fb4);
        builder.append(", numConsumableBlocks=");
        builder.append(this.numConsumableBlocks);
        builder.append(", pg=");
        builder.append(this.pg);
        builder.append(", raidLevel=");
        builder.append(this.raidLevel);
        builder.append(", seqNum=");
        builder.append(this.seqNum);
        builder.append(", valid=");
        builder.append(this.valid);
        builder.append(", aouVol=");
        builder.append(this.aouVol);
        builder.append(", externalVol=");
        builder.append(this.externalVol);
        builder.append(", qsVvol=");
        builder.append(this.qsVvol);
        builder.append(", FICON_DMVol=");
        builder.append(this.mFICON_DMVol);
        builder.append(", vVol=");
        builder.append(this.vVol);
        builder.append(", normalVol=");
        builder.append(this.normalVol);
        builder.append(", consistsOf=");
        builder.append(this.consistsOf);
        builder.append(", numFreeBlocks=");
        builder.append(this.numFreeBlocks);
        builder.append(", isContainedDNsOpenVolume=");
        builder.append(this.isContainedDNsOpenVolume);
        builder.append(", containedDNs=");
        builder.append(this.containedDNs);
        builder.append(", containedFreeSpace=");
        builder.append(this.containedFreeSpace);
        builder.append(", vdev=");
        builder.append(this.vdev);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<ChassisArrayGroup> mCallback;
        private final String mDeviceIDKeyVal;
        private boolean mHasProperties;
        private final boolean mIsObjectPath;
        private int mPAG = -1;
        private int mPFB4 = -1;
        private int mPPG = -1;
        private int mPVdev = -1;
        private RMIObjectCache mRMIobj = null;
        private final TaskProcessor mTheTask;
        private Robj_interface_RJiVDEVInfoDetail mTheVal = null;

        public WorkerThread(IteratorCallback<ChassisArrayGroup> callback, RMIObjectCache rmiobj, Robj_interface_RJiVDEVInfoDetail val, boolean isObjectPath, TaskProcessor pTheTask, int pFB4, int pPG, int pVdev, int pAG) {
            this.mRMIobj = rmiobj;
            this.mCallback = callback;
            this.mTheVal = val;
            this.mIsObjectPath = isObjectPath;
            this.mTheTask = pTheTask;
            this.mPFB4 = pFB4;
            this.mPPG = pPG;
            this.mPVdev = pVdev;
            this.mPAG = pAG;
            this.mDeviceIDKeyVal = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = ChassisArrayGroup.processInfoDetail(this.mCallback, this.mRMIobj, this.mTheVal, this.mIsObjectPath, this.mDeviceIDKeyVal, this.mHasProperties, this.mPFB4, this.mPPG, this.mPVdev, this.mPAG))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Throwable e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)e : new WBEMException(1, "Exception while processing items", null, e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }
    }

    protected static class fsIndexAndNumBlocks {
        private final boolean mIsOpenVolume;
        private final ArrayList<BaseDeviceNumber> mContainDNs;
        private final ArrayList<UnsignedInteger64> mContainedFS;
        private final long mNumConsumableBlocks;
        private final UnsignedInteger64 mBlockSize;

        fsIndexAndNumBlocks(long consumableBlocks, UnsignedInteger64 blockSize, ArrayList<UnsignedInteger64> freeSpaces, boolean openVolume, ArrayList<BaseDeviceNumber> containedDNs) {
            this.mContainDNs = containedDNs;
            this.mNumConsumableBlocks = consumableBlocks;
            this.mContainedFS = freeSpaces;
            this.mIsOpenVolume = openVolume;
            this.mBlockSize = blockSize;
        }
    }

    private static class FindCAGCallback
    extends FindMethodCallbackHandler<ChassisArrayGroup> {
        final CAGSortor cagComparitor = new CAGSortor();
        final ChassisArrayGroup cag2Find;

        public FindCAGCallback(String serialNumber, short fb42Find, short pg2Find, short vdev2Find, short arrayGroup2Find) {
            this.cag2Find = new ChassisArrayGroup(serialNumber, fb42Find, arrayGroup2Find == -1 ? pg2Find : arrayGroup2Find, -1 == vdev2Find ? (short)1 : vdev2Find, null);
        }

        public void returnItems(ChassisArrayGroup[] items, HitachiCacheComparator<ChassisArrayGroup> comparator) {
            Arrays.sort(items, this.cagComparitor);
            int found = Arrays.binarySearch(items, this.cag2Find, this.cagComparitor);
            if (found >= 0) {
                ChassisArrayGroup cag = items[found];
                if (null == comparator || comparator.isMatch(cag)) {
                    this.returnItem(cag);
                } else {
                    AbstractBaseCommonObject.providerLogger.log(Level.WARNING, "Found {0} but it did not match comparator {1}", new Object[]{cag, comparator});
                }
            } else {
                this.setCompleted(true);
            }
        }

        private static class CAGSortor
        implements Comparator<ChassisArrayGroup> {
            @Override
            public int compare(ChassisArrayGroup o1, ChassisArrayGroup o2) {
                int ret;
                int n = o1.getFb4() == o2.getFb4() ? 0 : (ret = o1.getFb4() < o2.getFb4() ? -1 : 1);
                if (ret == 0) {
                    int n2 = o1.getVdev() == o2.getVdev() ? 0 : (ret = o1.getVdev() < o2.getVdev() ? -1 : 1);
                }
                if (ret == 0) {
                    ret = o1.getPg() == o2.getPg() ? 0 : (o1.getPg() < o2.getPg() ? -1 : 1);
                }
                return ret;
            }
        }
    }

    private static class DeviceFB4PGInfo {
        private final int maxFB4Num;
        private final int maxPGNum = 32;
        private final Set<String> usedFB4PG;

        private static final String makeStringForSet(int fb4, int pg) {
            return String.format("%d-%d", fb4, pg);
        }

        protected DeviceFB4PGInfo(String serialNumber) throws WBEMException {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNumber).getRMIObject();
            this.maxFB4Num = rmiObj.getSMIModelInfo().getMaxFB4();
            this.usedFB4PG = new HashSet<String>();
        }

        protected final int getMaxFB4Num() {
            return this.maxFB4Num;
        }

        protected final int getMaxPGNum() {
            return 32;
        }

        protected synchronized boolean isAvailable(int fb4, int pg) {
            return !this.usedFB4PG.contains(DeviceFB4PGInfo.makeStringForSet(fb4, pg));
        }

        protected synchronized boolean removeUsed(int fb4, int pg) {
            return this.usedFB4PG.remove(DeviceFB4PGInfo.makeStringForSet(fb4, pg));
        }

        protected synchronized void setUsed(int fb4, int pg) {
            this.usedFB4PG.add(DeviceFB4PGInfo.makeStringForSet(fb4, pg));
        }
    }
}

