/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiFcoePortInfo;

public class FCoE
extends AbstractBaseCommonObject {
    private static final long serialVersionUID = 1L;
    private static Class<FCoE[]> clz = FCoE[].class;
    private int mIFcfIndex;
    private int mIVlanId;
    private int mIVpIndex;
    private String mMACAddress;
    private String mStripedMACAddress;
    private String mENodeMacAddress;
    private String mPortDisplayName;
    private short mPort;
    private short ctrlIDAsShort;

    public static FCoE[] addFCoEToCache(short pPortID, String serialNum) throws WBEMException {
        FCoE[] ret = new FCoE[]{};
        try {
            CommonClassAsList<FCoE> callback = new CommonClassAsList<FCoE>();
            FCoE.getUnCachedFCoEs(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), callback, null, pPortID);
            LinkedList<FCoE> pathList = callback.getReturnValue();
            HashMap<String, List<FCoE>> pathMap = new HashMap<String, List<FCoE>>();
            callback = null;
            for (FCoE path : pathList) {
                FCoE.addToMap(pathMap, path);
            }
            CacheLib.addDataToCache(pathMap, pathList, clz, serialNum);
            ret = pathList.toArray(new FCoE[pathList.size()]);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add LUPath to cache" + t, null, t);
        }
        return ret;
    }

    private static void addToMap(HashMap<String, List<FCoE>> pathMap, FCoE port) {
        String key = CacheLib.getFCoEPortString(port.getPort());
        CacheLib.addToMap(pathMap, key, port);
        key = CacheLib.getFCoECtrlIDString(port.getCtrlIDAsShort());
        CacheLib.addToMap(pathMap, key, port);
        key = CacheLib.getFCoECtrlIDandPort(port.getCtrlIDAsShort(), port.getPort());
        CacheLib.addToMap(pathMap, key, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        Class<FCoE[]> clz;
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz = FCoE[].class)) {
            Class<FCoE> clazz = FCoE.class;
            synchronized (FCoE.class) {
                if (!cache.isCached(clz)) {
                    CommonClassAsList<FCoE> callback = new CommonClassAsList<FCoE>();
                    FCoE.getUnCachedFCoEs(mapping.getRMIObject(), callback, null, null);
                    LinkedList<FCoE> ports = callback.getReturnValue();
                    callback = null;
                    HashMap<String, List<FCoE>> portMap = new HashMap<String, List<FCoE>>();
                    for (FCoE port : ports) {
                        FCoE.addToMap(portMap, port);
                    }
                    CacheLib.addDataToCache(portMap, ports, clz, mapping.getSerialNumber());
                } else {
                    cacheLogger.warning("FCoE is already in the cache");
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else {
            cacheLogger.warning("FCoE is already in the cache");
        }
    }

    public static FCoE find(Short ctrlID, Short portID, RMIObjectCache rmiObject) throws WBEMException {
        if (null == rmiObject) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        FCoE ret = null;
        try {
            FindMethodCallbackHandler<FCoE> callback = new FindMethodCallbackHandler<FCoE>();
            FCoE.getFCoEs(rmiObject, callback, ctrlID, portID);
            ret = callback.getReturnValue();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    private static void getFCoEs(IteratorCallback<FCoE> callback, Short pCtrlID, Short pPort) throws WBEMException {
        Collection<RMIObjectMapping> maps = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping map : maps) {
            if (null != map) {
                FCoE.getFCoEs(map.getRMIObject(), callback, pCtrlID, pPort);
                continue;
            }
            providerLogger.severe("One of the mappings is null.");
        }
    }

    public static void getFCoEs(RMIObjectCache rmiObj, IteratorCallback<FCoE> callback, Short pCtrlID, Short pPort) throws WBEMException {
        if (null == rmiObj) {
            FCoE.getFCoEs(callback, pCtrlID, pPort);
            return;
        }
        try {
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            if (cache.isCached(clz)) {
                AbstractBaseCommonObject[] fcoes;
                short matchPort;
                short matchCtrlID = pCtrlID == null ? (short)-1 : (short)pCtrlID;
                short s = matchPort = pPort == null ? (short)-1 : (short)pPort;
                if (matchCtrlID != -1 && matchPort != -1) {
                    String key = CacheLib.getFCoECtrlIDandPort(matchCtrlID, matchPort);
                    fcoes = (FCoE[])cache.getCachedObject(key, clz);
                } else if (matchCtrlID != -1) {
                    String key = CacheLib.getFCoECtrlIDString(matchCtrlID);
                    fcoes = (FCoE[])cache.getCachedObject(key, clz);
                } else if (matchPort != -1) {
                    String key = CacheLib.getFCoEPortString(matchPort);
                    fcoes = (FCoE[])cache.getCachedObject(key, clz);
                } else {
                    fcoes = (FCoE[])cache.getCachedObject(clz);
                }
                if (fcoes != null) {
                    callback.returnItems(fcoes);
                } else {
                    providerLogger.warning("No FCoEs in cache.");
                    callback.done();
                }
            } else {
                LogRecord record = new LogRecord(Level.WARNING, "FCoE not cached on {0}, performance issue");
                record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
                record.setThrown(new Exception(record.getMessage()));
                cacheLogger.log(record);
                FCoE.getUnCachedFCoEs(rmiObj, callback, pCtrlID, pPort);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, "Exception getting FCoEs: " + th, null, th);
        }
    }

    private static void getUnCachedFCoEs(RMIObjectCache rmiObj, IteratorCallback<FCoE> callback, Short ctrlID, Short expSPort) throws WBEMException {
        try {
            Robj_interface_RJiFcoePortInfo[] infoDetails = rmiObj.getFcoePortInfo();
            if (infoDetails.length > 0) {
                TaskProcessor task = new TaskProcessor("FCoE", infoDetails.length);
                for (Robj_interface_RJiFcoePortInfo infoDetail : infoDetails) {
                    WorkerThread worker = new WorkerThread(rmiObj.getSMISMappingContainer().getSerialNumber(), callback, infoDetail, task, ctrlID, expSPort);
                    task.addTask(worker);
                }
            } else {
                callback.done();
            }
        }
        catch (Exception e) {
            throw new WBEMException(1, "Caught: " + e, null, (Throwable)e);
        }
    }

    public static FCoE[] modifyFCoEInCache(short pPortID, String serialNum) {
        FCoE[] ret = new FCoE[1];
        try {
            FCoE newPort;
            CommonClassAsList<FCoE> results = new CommonClassAsList<FCoE>();
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
            FCoE.getUnCachedFCoEs(device.getRMIObject(), results, null, pPortID);
            LinkedList<FCoE> newPorts = results.getReturnValue();
            results = null;
            if (newPorts.size() != 1) {
                cacheLogger.severe("back end returned more then 1 port with an id of" + pPortID);
            }
            while ((newPort = newPorts.poll()) != null) {
                FCoE cached = FCoE.find(null, pPortID, device.getRMIObject());
                if (cached.equals(newPort)) continue;
                cached.copyFCoE(new FCoE(newPort));
                ret[0] = cached;
                break;
            }
        }
        catch (WBEMException we) {
            cacheLogger.log(Level.SEVERE, "Exception trying to get new FCoE", we);
        }
        return ret;
    }

    private static boolean processInfoDetail(String serialNum, IteratorCallback<FCoE> callback, Robj_interface_RJiFcoePortInfo info, Short ctrlID, Short expSPort) {
        boolean ret = true;
        short matchPort = expSPort == null ? (short)-1 : (short)expSPort;
        short port = info.getSPort();
        short matchCtrID = FCPort.getCtrlID(info.getStrPortDisplayName(), serialNum);
        if (!(matchPort != -1 && matchPort != port || ctrlID != null && matchCtrID != ctrlID)) {
            FCoE fcoe = new FCoE(serialNum, port);
            fcoe.mMACAddress = info.getStrFpma();
            fcoe.mStripedMACAddress = info.getStrFpma().replaceAll(":", "");
            fcoe.mIFcfIndex = info.getIFcfIndex();
            fcoe.mIVlanId = info.getIVlanId();
            fcoe.mIVpIndex = info.getIVpIndex();
            fcoe.mENodeMacAddress = info.getStrENodeMacAddress();
            fcoe.mPortDisplayName = info.getStrPortDisplayName();
            fcoe.ctrlIDAsShort = FCPort.getCtrlID(fcoe.mPortDisplayName, serialNum);
            ret = callback.returnItem(fcoe);
        }
        return ret;
    }

    public static FCoE[] removeFCoEFromCache(short pPortID, String serialNum) throws WBEMException {
        FCoE[] paths;
        try {
            String key = CacheLib.getPortString(pPortID);
            HitachiCacheInterface cache = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject().smisGetHitachiCacheIF();
            paths = (FCoE[])cache.getCachedObject(key, clz);
            if (paths != null) {
                HashMap<String, List<FCoE>> pathMap = new HashMap<String, List<FCoE>>();
                FCoE.setupMap(pathMap, Arrays.asList(paths), serialNum);
            }
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to remove LUPath from cache" + t, null, t);
        }
        return paths;
    }

    private static void setupMap(HashMap<String, List<FCoE>> pathMap, List<FCoE> theList, String serialNum) throws WBEMException {
        for (FCoE path : theList) {
            FCoE.addToMap(pathMap, path);
        }
        CacheLib.removeDataFromCache(pathMap, (Serializable[])theList.toArray(new FCoE[theList.size()]), clz, (String)serialNum);
    }

    public FCoE(FCoE other) {
        super(other.getSerialNumber());
        this.copyFCoE(other);
    }

    private FCoE(String serialNum, short pPort) {
        super(serialNum);
        this.mPort = pPort;
    }

    private FCoE copyFCoE(FCoE orig) {
        FCoE copy = new FCoE(orig.getSerialNumber(), orig.getPort());
        copy.mMACAddress = orig.getMACAddress();
        copy.mStripedMACAddress = orig.getStripedMACAddress();
        copy.mIFcfIndex = orig.getIFcfIndex();
        copy.mIVlanId = orig.getIVlanId();
        copy.mIVpIndex = orig.getIVpIndex();
        copy.mENodeMacAddress = orig.getENodeMacAddress();
        copy.mPortDisplayName = orig.getPortDisplayName();
        copy.ctrlIDAsShort = orig.getCtrlIDAsShort();
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FCoE other = (FCoE)obj;
        if (this.mENodeMacAddress == null ? other.mENodeMacAddress != null : !this.mENodeMacAddress.equals(other.mENodeMacAddress)) {
            return false;
        }
        if (this.mIFcfIndex != other.mIFcfIndex) {
            return false;
        }
        if (this.mIVlanId != other.mIVlanId) {
            return false;
        }
        if (this.mIVpIndex != other.mIVpIndex) {
            return false;
        }
        if (this.mMACAddress == null ? other.mMACAddress != null : !this.mMACAddress.equals(other.mMACAddress)) {
            return false;
        }
        if (this.mPort != other.mPort) {
            return false;
        }
        if (this.mPortDisplayName == null ? other.mPortDisplayName != null : !this.mPortDisplayName.equals(other.mPortDisplayName)) {
            return false;
        }
        return this.ctrlIDAsShort == other.getCtrlIDAsShort();
    }

    public short getCtrlIDAsShort() {
        return this.ctrlIDAsShort;
    }

    public String getENodeMacAddress() {
        return this.mENodeMacAddress;
    }

    public int getIFcfIndex() {
        return this.mIFcfIndex;
    }

    public int getIVlanId() {
        return this.mIVlanId;
    }

    public int getIVpIndex() {
        return this.mIVpIndex;
    }

    public String getMACAddress() {
        return this.mMACAddress;
    }

    public short getPort() {
        return this.mPort;
    }

    public String getPortDisplayName() {
        return this.mPortDisplayName;
    }

    public String getStripedMACAddress() {
        return this.mStripedMACAddress;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mENodeMacAddress == null ? 0 : this.mENodeMacAddress.hashCode());
        result = 31 * result + this.mIFcfIndex;
        result = 31 * result + this.mIVlanId;
        result = 31 * result + this.mIVpIndex;
        result = 31 * result + (this.mMACAddress == null ? 0 : this.mMACAddress.hashCode());
        result = 31 * result + this.mPort;
        result = 31 * result + (this.mPortDisplayName == null ? 0 : this.mPortDisplayName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FCoE [mSerial=");
        builder.append(this.getSerialNumber());
        builder.append(", mPort=");
        builder.append(this.mPort);
        builder.append(", mIVlanId=");
        builder.append(this.mIVlanId);
        builder.append(", mIVpIndex=");
        builder.append(this.mIVpIndex);
        builder.append(", mMACAddress=");
        builder.append(this.mMACAddress);
        builder.append(", mENodeMacAddress=");
        builder.append(this.mENodeMacAddress);
        builder.append(", mPortDisplayName=");
        builder.append(this.mPortDisplayName);
        builder.append(", mIFcfIndex=");
        builder.append(this.mIFcfIndex);
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<FCoE> mCallBack;
        private final Robj_interface_RJiFcoePortInfo mInfo;
        private final Short expSPort;
        private final Short ctrlID;
        private final TaskProcessor mTheTask;
        private final String mSerialNum;

        public WorkerThread(String serialNum, IteratorCallback<FCoE> callback, Robj_interface_RJiFcoePortInfo pInfo, TaskProcessor theTask, Short ctrlID, Short expSPort) {
            this.mSerialNum = serialNum;
            this.mCallBack = callback;
            this.mInfo = pInfo;
            this.mTheTask = theTask;
            this.expSPort = expSPort;
            this.ctrlID = ctrlID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = FCoE.processInfoDetail(this.mSerialNum, this.mCallBack, this.mInfo, this.ctrlID, this.expSPort))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Throwable e) {
                WBEMException we = new WBEMException(1, "Exception while processing FCoEs for " + this.mSerialNum, null, e);
                this.mCallBack.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallBack.done();
                }
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("WorkerThread [mCallBack=");
            builder.append(this.mCallBack);
            builder.append(", mInfo=");
            builder.append(this.mInfo);
            builder.append(", expSPort=");
            builder.append(this.expSPort);
            builder.append(", ctrlID=");
            builder.append(this.ctrlID);
            builder.append(", mTheTask=");
            builder.append(this.mTheTask);
            builder.append("]");
            return builder.toString();
        }
    }
}

