/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.StorageCapabilitiesIMPL;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.wbem.WBEMException;

public final class GeneratedStorageSettingsIMPL
extends StorageCapabilitiesIMPL
implements Cloneable {
    private static final String GENERATED_IMPORTED_SETTINGS_SER = "GeneratedImportedSettings.ser";
    private static final String GENERATED_PRIMORDIAL_SETTINGS_SER = "GeneratedPrimordialSettings.ser";
    private static final String GENERATED_THIN_SETTINGS_SER = "GeneratedThinSettings.ser";
    private static final String GENERATED_SETTINGS_SER = "GeneratedSettings.ser";
    private static final String GENERATED_SETTINGS_SER2 = "GeneratedSettings2.ser";
    private static final HashMap<String, CIMDataType> map = new HashMap(21);
    private static final Map<String, Hashtable<String, GeneratedStorageSettingsIMPL>> mImportedPrimordialSettings = new Hashtable<String, Hashtable<String, GeneratedStorageSettingsIMPL>>();
    private static Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private static final Map<String, Hashtable<String, GeneratedStorageSettingsIMPL>> mPrimordialSettings = new Hashtable<String, Hashtable<String, GeneratedStorageSettingsIMPL>>();
    private static AtomicLong mSeqNumberGenerator = new AtomicLong(0L);
    private static final Map<String, Hashtable<String, GeneratedStorageSettingsIMPL>> mThinSettings = new Hashtable<String, Hashtable<String, GeneratedStorageSettingsIMPL>>();
    private static final Map<String, Hashtable<String, GeneratedStorageSettingsIMPL>> mSettings = new Hashtable<String, Hashtable<String, GeneratedStorageSettingsIMPL>>();
    private static final long serialVersionUID = 1L;
    private static Boolean settingsRestored = Boolean.FALSE;
    protected UnsignedInteger16 mChangeableType = ProviderConstants.UINT16_ONE;
    protected UnsignedInteger16 mExtentStripLengthMax;
    protected UnsignedInteger16 mExtentStripLengthMin;
    protected UnsignedInteger64 mUserDataStrip = null;
    protected UnsignedInteger64 mUserDataStripMax = null;
    protected UnsignedInteger64 mUserDataStripMin = null;
    protected UnsignedInteger16 mDataOrganization = null;
    protected String mCUImage = null;
    protected String mSubsystemID = null;
    protected String mEmulatedDevice = null;
    protected UnsignedInteger16 mThinProvisionedPoolType = null;
    protected UnsignedInteger64 mThinProvisionedInitialReserve = null;
    private long mSeqNumber = -1L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final GeneratedStorageSettingsIMPL createSetting(CIMObjectPath pCapObj, int goal) throws WBEMException {
        GeneratedStorageSettingsIMPL ret = null;
        if (!pCapObj.getObjectName().contains("StorageCapabilities")) throw new WBEMException(4, "The passed in objectpath (" + pCapObj + ") is not a StorageCapabilities");
        CIMProperty instIDProp = pCapObj.getKey("InstanceID");
        if (instIDProp == null) {
            throw new WBEMException(4, "InstanceID for objectpath (" + pCapObj + ") doesn't exist");
        }
        String instID = (String)instIDProp.getValue();
        if (instID == null) {
            throw new WBEMException(4, "InstanceID for objectpath (" + pCapObj + ") is NULL");
        }
        StorageCapabilitiesIMPL cap = null;
        String serialNum = ProviderLibs.getSerialFromString(instID);
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
        if (instID.endsWith("Primordial")) {
            String sysName = null;
            try {
                sysName = device.getStorageSystemName();
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Exception e) {
                throw new WBEMException(1, "Unable to get system name", null, (Throwable)e);
            }
            cap = instID.contains("Imported") ? StorageCapabilitiesIMPL.getImportedPrimordialCaps(sysName) : StorageCapabilitiesIMPL.getPrimordialCaps(sysName);
            CIMProperty instIDKey = pCapObj.getKey("InstanceID");
            if (instIDKey != null) {
                String settingName = (String)instIDKey.getValue();
                if (!cap.getInstanceID().equals(settingName)) {
                    throw new WBEMException(1, "The passed in objectpaths InstanceID (" + settingName + ") does not" + " match the InstanceID (" + cap.getInstanceID() + ") of the stored capabilities");
                }
            }
        } else if (pCapObj.getObjectName().contains("ThinProvisioningPool")) {
            String strThinPoolID = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            cap = StorageCapabilitiesIMPL.findThinPoolCapability(Short.parseShort(strThinPoolID), device.getRMIObject());
        } else {
            Integer[] array = ProviderLibs.getInstanceIDInts(instID);
            cap = StorageCapabilitiesIMPL.findCapabilities(array[0], array[1], device.getRMIObject());
        }
        if (cap == null) throw new WBEMException(4, "The passed in objectpath (" + pCapObj + ") does not match an existing capabilities");
        if (!cap.isOpenVolume()) throw new WBEMException(4, "The passed in objectpath (" + pCapObj + ") is for a non-open volume");
        return GeneratedStorageSettingsIMPL.createSetting(cap, goal);
    }

    private static final GeneratedStorageSettingsIMPL createSetting(StorageCapabilitiesIMPL cap, int goal) throws WBEMException {
        GeneratedStorageSettingsIMPL ret = null;
        if (cap != null) {
            ret = new GeneratedStorageSettingsIMPL(cap);
            ret.addGeneratedSettings();
        }
        return ret;
    }

    public static Iterable<GeneratedStorageSettingsIMPL> getGeneratedImportedPrimordialStorageSettings(String serialNumber) {
        GeneratedStorageSettingsIMPL.restoreSettings();
        Map settings = mImportedPrimordialSettings.get(serialNumber);
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        return settings.values();
    }

    public static Collection<GeneratedStorageSettingsIMPL> getGeneratedPrimordialStorageSettings(String serialNumber) {
        GeneratedStorageSettingsIMPL.restoreSettings();
        Map settings = mPrimordialSettings.get(serialNumber);
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        return settings.values();
    }

    public static Collection<GeneratedStorageSettingsIMPL> getGeneratedStorageSettings(String serialNumber) {
        GeneratedStorageSettingsIMPL.restoreSettings();
        Map settings = mSettings.get(serialNumber);
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        return settings.values();
    }

    public static Iterable<GeneratedStorageSettingsIMPL> getGeneratedThinStorageSettings(String serialNumber) {
        GeneratedStorageSettingsIMPL.restoreSettings();
        Map settings = mThinSettings.get(serialNumber);
        if (null == settings) {
            settings = Collections.emptyMap();
        }
        return settings.values();
    }

    public static final GeneratedStorageSettingsIMPL lookUpSetting(String instID) {
        GeneratedStorageSettingsIMPL.restoreSettings();
        GeneratedStorageSettingsIMPL ret = null;
        if (instID != null) {
            String serial = ProviderLibs.getSerialFromString(instID, ".", 2);
            if (null != serial) {
                Map theMap = instID.contains("ImportedPrimordial") ? (Map)mImportedPrimordialSettings.get(serial) : (instID.contains("Primordial") ? (Map)mPrimordialSettings.get(serial) : (instID.contains("ThinProvisioningPool") ? (Map)mThinSettings.get(serial) : (Map)mSettings.get(serial)));
                if (null != theMap) {
                    ret = (GeneratedStorageSettingsIMPL)theMap.get(instID);
                }
            } else {
                mLogger.log(Level.WARNING, "Not managing requested device: {0}", instID);
            }
        }
        return ret;
    }

    private static void persistSetting(Map<String, Hashtable<String, GeneratedStorageSettingsIMPL>> deviceMap, String fileName) {
        if (!deviceMap.isEmpty()) {
            String dirName = ProviderConstants.getDatDirectory();
            String importedSettings = dirName + fileName;
            try (FileOutputStream fos = new FileOutputStream(importedSettings);
                 ObjectOutputStream out = new ObjectOutputStream(fos);){
                Set<String> serials = deviceMap.keySet();
                for (String serial : serials) {
                    Hashtable<String, GeneratedStorageSettingsIMPL> t = deviceMap.get(serial);
                    if (null == t || null == RMIObjectMapping.getRMIObjectMapping(serial)) continue;
                    for (GeneratedStorageSettingsIMPL setting : t.values()) {
                        if (setting.mChangeableType.intValue() != 2) continue;
                        out.writeObject(setting);
                    }
                }
            }
            catch (IOException ex) {
                mLogger.log(Level.SEVERE, "Error trying to persist " + fileName, ex);
            }
        }
    }

    private static void persistSettings() {
        Task getImportedSettings = new Task(){

            @Override
            public void doTask() {
                GeneratedStorageSettingsIMPL.persistSetting(mImportedPrimordialSettings, GeneratedStorageSettingsIMPL.GENERATED_IMPORTED_SETTINGS_SER);
            }
        };
        Task getPrimordialSettings = new Task(){

            @Override
            public void doTask() {
                GeneratedStorageSettingsIMPL.persistSetting(mPrimordialSettings, GeneratedStorageSettingsIMPL.GENERATED_PRIMORDIAL_SETTINGS_SER);
            }
        };
        Task getThinSettings = new Task(){

            @Override
            public void doTask() {
                GeneratedStorageSettingsIMPL.persistSetting(mThinSettings, GeneratedStorageSettingsIMPL.GENERATED_THIN_SETTINGS_SER);
            }
        };
        Task getSettings = new Task(){

            @Override
            public void doTask() {
                GeneratedStorageSettingsIMPL.persistSetting(mSettings, GeneratedStorageSettingsIMPL.GENERATED_SETTINGS_SER2);
            }
        };
        ProcessTask.addTask(getImportedSettings);
        ProcessTask.addTask(getPrimordialSettings);
        ProcessTask.addTask(getThinSettings);
        ProcessTask.addTask(getSettings);
    }

    public static GeneratedStorageSettingsIMPL removeGenSettings(String instID) {
        GeneratedStorageSettingsIMPL ret = null;
        if (instID != null) {
            Map theMap;
            String serial = ProviderLibs.getSerialFromString(instID, ".", 2);
            if (null != serial && null != (theMap = instID.contains("ImportedPrimordial") ? (Map)mImportedPrimordialSettings.get(serial) : (instID.contains("Primordial") ? (Map)mPrimordialSettings.get(serial) : (instID.contains("ThinProvisioningPool") ? (Map)mThinSettings.get(serial) : (Map)mSettings.get(serial))))) {
                ret = (GeneratedStorageSettingsIMPL)theMap.remove(instID);
            }
            GeneratedStorageSettingsIMPL.persistSettings();
        }
        return ret;
    }

    private static void restoreSetting(Map<String, Hashtable<String, GeneratedStorageSettingsIMPL>> deviceMap, String fileName) {
        String dirName = ProviderConstants.getDatDirectory();
        String settingsFile = dirName + fileName;
        File test = new File(settingsFile);
        if (test.exists()) {
            try (FileInputStream fin = new FileInputStream(test);
                 ObjectInputStream in = new ObjectInputStream(fin);){
                int count = 0;
                long seqNumber = 0L;
                try {
                    while (true) {
                        GeneratedStorageSettingsIMPL value = (GeneratedStorageSettingsIMPL)in.readObject();
                        String instID = value.getInstanceID();
                        String serial = value.getSerialNumber();
                        if (null == serial || null == RMIObjectMapping.getRMIObjectMapping(serial)) continue;
                        Hashtable<String, GeneratedStorageSettingsIMPL> settings = deviceMap.get(serial);
                        if (null == settings) {
                            settings = new Hashtable();
                            deviceMap.put(serial, settings);
                        }
                        settings.put(instID, value);
                        if (seqNumber < value.mSeqNumber) {
                            seqNumber = value.mSeqNumber;
                        }
                        ++count;
                    }
                }
                catch (EOFException eof) {
                    mLogger.finest("Read in " + count + " settings from " + settingsFile);
                }
                catch (ClassNotFoundException cnfe) {
                    mLogger.log(Level.SEVERE, "Exception attempting to read serialized settings", cnfe);
                }
                if (mSeqNumberGenerator.get() <= seqNumber) {
                    mSeqNumberGenerator.getAndSet(++seqNumber);
                }
            }
            catch (IOException ex) {
                mLogger.log(Level.SEVERE, "Error trying to restore " + fileName, ex);
            }
        } else {
            mLogger.finest(settingsFile + " doesn't exist, no stored settings restored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void restoreSettings() {
        if (settingsRestored != Boolean.FALSE) return;
        Class<GeneratedStorageSettingsIMPL> clazz = GeneratedStorageSettingsIMPL.class;
        synchronized (GeneratedStorageSettingsIMPL.class) {
            if (settingsRestored == Boolean.FALSE) {
                GeneratedStorageSettingsIMPL.restoreSetting(mImportedPrimordialSettings, GENERATED_IMPORTED_SETTINGS_SER);
                GeneratedStorageSettingsIMPL.restoreSetting(mPrimordialSettings, GENERATED_PRIMORDIAL_SETTINGS_SER);
                GeneratedStorageSettingsIMPL.restoreSetting(mThinSettings, GENERATED_THIN_SETTINGS_SER);
                GeneratedStorageSettingsIMPL.restoreSetting(mSettings, GENERATED_SETTINGS_SER);
            }
            settingsRestored = Boolean.TRUE;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private GeneratedStorageSettingsIMPL() {
        if (map.isEmpty()) {
            map.put("Caption", CIMDataType.STRING_T);
            map.put("Description", CIMDataType.STRING_T);
            map.put("ElementName", CIMDataType.STRING_T);
            map.put("InstanceID", CIMDataType.STRING_T);
            map.put("CUImage", CIMDataType.STRING_T);
            map.put("SubsystemID", CIMDataType.STRING_T);
            map.put("EmulatedDevice", CIMDataType.STRING_T);
            map.put("ThinProvisionedPoolType", CIMDataType.UINT16_T);
            map.put("ThinProvisionedInitialReserve", CIMDataType.UINT64_T);
            map.put("ChangeableType", CIMDataType.UINT16_T);
            map.put("DataOrganization", CIMDataType.UINT16_T);
            map.put("DataRedundancyGoal", CIMDataType.UINT16_T);
            map.put("DataRedundancyMax", CIMDataType.UINT16_T);
            map.put("DataRedundancyMin", CIMDataType.UINT16_T);
            map.put("ExtentStripeLength", CIMDataType.UINT16_T);
            map.put("ExtentStripeLengthMax", CIMDataType.UINT16_T);
            map.put("ExtentStripeLengthMin", CIMDataType.UINT16_T);
            map.put("PackageRedundancyGoal", CIMDataType.UINT16_T);
            map.put("PackageRedundancyMax", CIMDataType.UINT16_T);
            map.put("PackageRedundancyMin", CIMDataType.UINT16_T);
            map.put("ParityLayout", CIMDataType.UINT16_T);
            map.put("DeltaReservationGoal", CIMDataType.UINT8_T);
            map.put("DeltaReservationMax", CIMDataType.UINT8_T);
            map.put("DeltaReservationMin", CIMDataType.UINT8_T);
            map.put("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T);
            map.put("UserDataStripeDepth", CIMDataType.UINT64_T);
            map.put("UserDataStripeDepthMax", CIMDataType.UINT64_T);
            map.put("UserDataStripeDepthMin", CIMDataType.UINT64_T);
        }
    }

    protected GeneratedStorageSettingsIMPL(StorageCapabilitiesIMPL cap) throws WBEMException {
        this();
        if (null != cap) {
            this.mArrayGroup = cap.getArrayGroup();
            this.mChassis = cap.getChassis();
            this.mDataRedun = cap.getDataRedun();
            this.mDataRedunMax = cap.getDataRedunMax();
            this.mDataRedunMin = cap.getDataRedunMin();
            this.mExtentStripLength = null != cap.getExtentStripLength() ? cap.getExtentStripLength() : ProviderConstants.UINT16_FOUR;
            this.mExtentStripLengthMin = ProviderConstants.UINT16_FOUR;
            this.mExtentStripLengthMax = new UnsignedInteger16(16);
            this.mNoSinglePointOfFailure = cap.isNoSinglePointOfFailure();
            this.mParityLayout = cap.getParityLayout();
            this.mPkgRedun = cap.getPkgRedun();
            this.mPkgRedunMax = cap.getPkgRedunMax();
            this.mPkgRedunMin = cap.getPkgRedunMin();
            this.mImported = cap.mImported;
            this.mPrimordial = cap.mPrimordial;
            this.mRaidLevel = cap.mRaidLevel;
            this.mSystemName = cap.mSystemName;
            this.mThin = cap.mThin;
            this.mOpenVolume = cap.mOpenVolume;
            this.mAOUPool = cap.mAOUPool;
            this.mRaidLevel = null;
            if (this.mThin) {
                this.mThinProvisionedPoolType = ProviderConstants.UINT16_EIGHT;
            }
            if (!this.mPrimordial) {
                this.mThinProvisionedInitialReserve = ProviderConstants.UINT64_ZED;
                this.mDataOrganization = ProviderConstants.UINT16_TWO;
            }
        } else {
            throw new WBEMException(1, "invalid capbilities, can not generate settings!");
        }
    }

    private final void addGeneratedSettings() throws WBEMException {
        this.mSeqNumber = mSeqNumberGenerator.getAndIncrement();
        this.modifyOrCreateSetting();
    }

    public final boolean checkGeneratedSettings() throws WBEMException {
        StorageCapabilitiesIMPL caps;
        try {
            RMIObjectMapping rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber());
            caps = !this.mPrimordial ? (this.mThin ? StorageCapabilitiesIMPL.findThinPoolCapability((short)this.mArrayGroup, rmiObj.getRMIObject()) : StorageCapabilitiesIMPL.findCapabilities(this.mChassis, this.mArrayGroup, rmiObj.getRMIObject())) : (this.mImported ? StorageCapabilitiesIMPL.getImportedPrimordialCaps(rmiObj.getStorageSystemName()) : StorageCapabilitiesIMPL.getPrimordialCaps(rmiObj.getStorageSystemName()));
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Unable to find matching capabilities to check settings", null, t);
        }
        if (caps.equals(this)) {
            if (this.mThin && (null == this.mThinProvisionedPoolType || this.mThinProvisionedPoolType.intValue() != 8 && this.mThinProvisionedPoolType.intValue() != 9)) {
                mLogger.log(Level.SEVERE, "ThinProvisionedPoolType must be 0, it is {0}", this.mThinProvisionedPoolType);
                return false;
            }
            if (!(this.mPrimordial || this.mImported || null != this.mThinProvisionedInitialReserve && this.mThinProvisionedInitialReserve.intValue() == 0)) {
                mLogger.log(Level.SEVERE, "ThinProvisionedInitialReserve must be 0, it is {0}", this.mThinProvisionedInitialReserve);
                return false;
            }
            if (null != this.mCUImage) {
                mLogger.log(Level.SEVERE, "CUImage must be null, it is {0}", this.mCUImage);
                return false;
            }
            if (this.mChangeableType == null || this.mChangeableType.intValue() != 1 && this.mChangeableType.intValue() != 2) {
                mLogger.log(Level.SEVERE, "Changabletype must be 1 or 2, it is {0}", this.mChangeableType);
                return false;
            }
            if (!(this.mPrimordial || null != this.mDataOrganization && this.mDataOrganization.intValue() == 2)) {
                mLogger.log(Level.SEVERE, "DataOrganization must be 2, it is {0}", this.mDataOrganization);
                return false;
            }
            if (null != this.mEmulatedDevice) {
                mLogger.log(Level.SEVERE, "EmulatedDevice must be null, it is {0}", this.mEmulatedDevice);
                return false;
            }
            if (!this.mPrimordial) {
                if (null == this.mExtentStripLength && (null != this.mExtentStripLengthMin || null != this.mExtentStripLengthMax)) {
                    mLogger.log(Level.SEVERE, "ExtentStripeLengthMin/Max ({0}, {1}) must match capabilities {2}", new Object[]{this.mExtentStripLengthMin, this.mExtentStripLengthMax, this.mExtentStripLength});
                    return false;
                }
                if (null == this.mExtentStripLengthMin || null == this.mExtentStripLengthMax) {
                    mLogger.log(Level.SEVERE, "ExtentStripeLengthMin/Max ({0}, {1}) must match capabilities {2}", new Object[]{this.mExtentStripLengthMin, this.mExtentStripLengthMax, this.mExtentStripLength});
                    return false;
                }
                if (this.mExtentStripLengthMin.compareTo(this.mExtentStripLength) > 0 || this.mExtentStripLengthMax.compareTo(this.mExtentStripLength) < 0) {
                    mLogger.log(Level.SEVERE, "ExtentStripeLengthMin({0}) must be <= settings ExtentStripLength({2}), and ExtentStripeLengthMax({1}) must be >= settings ExtentStripLength({2}), ", new Object[]{this.mExtentStripLengthMin, this.mExtentStripLengthMax, this.mExtentStripLength});
                    return false;
                }
            }
            if (null != this.mSubsystemID) {
                mLogger.log(Level.SEVERE, "SubsystemID must be null, it is {0}", this.mSubsystemID);
                return false;
            }
            if (null != this.mUserDataStrip || null != this.mUserDataStripMin || null != this.mUserDataStripMax) {
                mLogger.log(Level.SEVERE, "UserDataStrip ({0}), UserDataStripmin ({1}) and UserDataStripMax ({2}) must be null", new Object[]{null != this.mUserDataStrip, this.mUserDataStripMin, this.mUserDataStripMax});
                return false;
            }
        } else {
            throw new WBEMException(this + " did not match corresponding capabilities: " + caps);
        }
        return true;
    }

    @Override
    public GeneratedStorageSettingsIMPL clone() {
        GeneratedStorageSettingsIMPL ret;
        try {
            ret = new GeneratedStorageSettingsIMPL(this);
        }
        catch (WBEMException e) {
            throw new RuntimeException(e);
        }
        ret.mChangeableType = this.mChangeableType;
        ret.mSeqNumber = this.mSeqNumber;
        ret.mDeltaRes = this.mDeltaRes;
        ret.mDeltaResMax = this.mDeltaResMax;
        ret.mDeltaResMin = this.mDeltaResMin;
        ret.mUserDataStrip = this.mUserDataStrip;
        ret.mUserDataStripMin = this.mUserDataStripMin;
        ret.mUserDataStripMax = this.mUserDataStripMax;
        return ret;
    }

    public final UnsignedInteger16 getChangeableType() {
        return this.mChangeableType;
    }

    public final UnsignedInteger16 getExtentStripLengthMax() {
        return this.mExtentStripLengthMax;
    }

    public final UnsignedInteger16 getExtentStripLengthMin() {
        return this.mExtentStripLengthMin;
    }

    public String getGenCUImage() {
        return this.mCUImage;
    }

    public UnsignedInteger16 getGenDataOrganization() {
        return this.mDataOrganization;
    }

    public UnsignedInteger8 getGenDeltaReservation() {
        return new UnsignedInteger8(this.mDeltaRes.shortValue());
    }

    public UnsignedInteger8 getGenDeltaReservationMax() {
        return new UnsignedInteger8(this.mDeltaResMax.shortValue());
    }

    public UnsignedInteger8 getGenDeltaReservationMin() {
        return new UnsignedInteger8(this.mDeltaResMin.shortValue());
    }

    public String getGenEmulatedDevice() {
        return this.mEmulatedDevice;
    }

    public String getGenSubsystemID() {
        return this.mSubsystemID;
    }

    public UnsignedInteger64 getGenThinProvisionedInitialReserved() {
        return this.mThinProvisionedInitialReserve;
    }

    public UnsignedInteger16 getGenThinProvisionedPoolType() {
        return this.mThinProvisionedPoolType;
    }

    @Override
    public String getInstanceID() {
        int index = "HITACHI_".length();
        String className = this.mThin ? "HITACHI_GeneratedThinProvisioningPoolSetting".substring(index) : "HITACHI_GeneratedStorageSetting".substring(index);
        StringBuffer ret = new StringBuffer(className);
        ret.append(".");
        ret.append(this.mSystemName);
        ret.append(".");
        ret.append(this.mSeqNumber);
        if (!this.mPrimordial) {
            if (!this.mThin) {
                ret.append(".");
                ret.append(this.mChassis);
            }
            ret.append(".");
            ret.append(this.mArrayGroup);
        } else {
            ret.append(".");
            if (this.mImported) {
                ret.append("Imported");
            }
            ret.append("Primordial");
        }
        return ret.toString();
    }

    public final long getSeqNumber() {
        return this.mSeqNumber;
    }

    public final UnsignedInteger64 getUserDataStrip() {
        return this.mUserDataStrip;
    }

    public UnsignedInteger64 getUserDataStripMax() {
        return this.mUserDataStripMax;
    }

    public UnsignedInteger64 getUserDataStripMin() {
        return this.mUserDataStripMin;
    }

    public void modifyOrCreateSetting() {
        String instID = this.getInstanceID();
        String serial = this.getSerialNumber();
        if (null != serial && null != RMIObjectMapping.getRMIObjectMapping(serial)) {
            Hashtable<String, GeneratedStorageSettingsIMPL> theMap;
            Map<String, Hashtable<String, GeneratedStorageSettingsIMPL>> devices;
            if (instID.contains("ImportedPrimordial")) {
                devices = mImportedPrimordialSettings;
                theMap = mImportedPrimordialSettings.get(serial);
            } else if (this.mPrimordial) {
                devices = mPrimordialSettings;
                theMap = mPrimordialSettings.get(serial);
            } else if (this.mThin) {
                devices = mThinSettings;
                theMap = mThinSettings.get(serial);
            } else {
                devices = mSettings;
                theMap = mSettings.get(serial);
            }
            if (null == theMap) {
                theMap = new Hashtable();
                devices.put(serial, theMap);
            }
            theMap.put(instID, this);
            GeneratedStorageSettingsIMPL.persistSettings();
        }
    }

    public void setValue(CIMProperty<?> cpProperty) {
        if (cpProperty != null) {
            String propName = cpProperty.getName();
            CIMDataType dtPropType = map.get(propName);
            if (dtPropType != null) {
                if (cpProperty.getDataType() != dtPropType) {
                    mLogger.warning("The '" + propName + "' contains a " + cpProperty.getDataType().toString() + " type but should contain a " + dtPropType.toString());
                }
                Object value = cpProperty.getValue();
                if (propName.equalsIgnoreCase("NoSinglePointOfFailure")) {
                    this.mNoSinglePointOfFailure = (Boolean)value;
                } else if (propName.equalsIgnoreCase("UserDataStripeDepth")) {
                    this.mUserDataStrip = (UnsignedInteger64)value;
                } else if (propName.equalsIgnoreCase("UserDataStripeDepthMin")) {
                    this.mUserDataStripMin = (UnsignedInteger64)value;
                } else if (propName.equalsIgnoreCase("UserDataStripeDepthMax")) {
                    this.mUserDataStripMax = (UnsignedInteger64)value;
                } else if (propName.equalsIgnoreCase("DataRedundancyMax")) {
                    this.mDataRedunMax = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("DataRedundancyMin")) {
                    this.mDataRedunMin = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("DataRedundancyGoal")) {
                    this.mDataRedun = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("PackageRedundancyMax")) {
                    this.mPkgRedunMax = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("PackageRedundancyGoal")) {
                    this.mPkgRedun = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("PackageRedundancyMin")) {
                    this.mPkgRedunMin = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("ChangeableType")) {
                    this.mChangeableType = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("ExtentStripeLength")) {
                    this.mExtentStripLength = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("ExtentStripeLengthMin")) {
                    this.mExtentStripLengthMin = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("ExtentStripeLengthMax")) {
                    this.mExtentStripLengthMax = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("ParityLayout")) {
                    this.mParityLayout = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("DeltaReservationMin")) {
                    this.mDeltaResMin = new UnsignedInteger16(((UnsignedInteger8)value).intValue());
                } else if (propName.equalsIgnoreCase("DeltaReservationMax")) {
                    this.mDeltaResMax = new UnsignedInteger16(((UnsignedInteger8)value).intValue());
                } else if (propName.equalsIgnoreCase("DeltaReservationGoal")) {
                    this.mDeltaRes = new UnsignedInteger16(((UnsignedInteger8)value).intValue());
                } else if (propName.equalsIgnoreCase("DataOrganization")) {
                    this.mDataOrganization = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("CUImage")) {
                    this.mCUImage = (String)value;
                } else if (propName.equalsIgnoreCase("SubsystemID")) {
                    this.mSubsystemID = (String)value;
                } else if (propName.equalsIgnoreCase("EmulatedDevice")) {
                    this.mEmulatedDevice = (String)value;
                } else if (propName.equalsIgnoreCase("ThinProvisionedPoolType")) {
                    this.mThinProvisionedPoolType = (UnsignedInteger16)value;
                } else if (propName.equalsIgnoreCase("ThinProvisionedInitialReserve")) {
                    this.mThinProvisionedInitialReserve = (UnsignedInteger64)value;
                } else if (propName.equalsIgnoreCase("InstanceID")) {
                    mLogger.finer("Can not change InstanceID, ignoring.");
                } else if (propName.equalsIgnoreCase("Caption")) {
                    mLogger.finer("Don't know how to change Caption");
                } else if (propName.equalsIgnoreCase("Description")) {
                    mLogger.finer("Don't know how to change Description");
                } else if (propName.equalsIgnoreCase("ElementName")) {
                    mLogger.finer("Don't know how to change ElementName");
                }
            } else {
                mLogger.finer("Generated Settings doesn't know the property: " + propName);
            }
        } else {
            mLogger.finer("GeneratedStorageSettings: Property is null");
        }
    }
}

