/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.cache.comparator.ISCSITargetPortComparator;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class ISCSITargetPort
extends AbstractBaseCommonObject
implements Comparable<ISCSITargetPort> {
    private static final Class<ISCSITargetPort[]> clz = ISCSITargetPort[].class;
    private static final String LOGINI_SCSI_NAMES_HISTORY = "LoginiScsiNamesHistory";
    private static final long serialVersionUID = -5602851645744567579L;
    private static String iSCSINameFormat = "iqn.1994-04.jp.co.hitachi:rsd.%s.t.%s.%s.%d";
    private int portID;
    private String locationName;
    private final List<ISCSITarget> targets;
    private final Set<Short> domainIDsUsedByExposePaths = new HashSet<Short>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException {
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<ISCSITargetPort> clazz = ISCSITargetPort.class;
            synchronized (ISCSITargetPort.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<ISCSITargetPort> callback = new ClosableAddableIteratorCB<ISCSITargetPort>();
                    ISCSITargetPort.getUnCachedISCSIPorts(rmiObj, callback, -1);
                    ArrayList<ISCSITargetPort> iSCSIPorts = new ArrayList<ISCSITargetPort>();
                    CloseableAddableIterator<ISCSITargetPort> iter = callback.getWrappedCloseableAddableIter();
                    while (iter.hasNext()) {
                        ISCSITargetPort iSCSIPort = (ISCSITargetPort)iter.next();
                        iSCSIPorts.add(iSCSIPort);
                    }
                    CacheLib.addItemsToCache(iSCSIPorts, clz, rmiMapping.getSerialNumber());
                } else {
                    cacheLogger.log(Level.SEVERE, "{0} is already in the cache", clz);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            cacheLogger.log(Level.SEVERE, "{0} is already in the cache", clz);
        }
    }

    public static ISCSITargetPort find(RMIObjectCache rmiObj, int portID) throws WBEMException {
        FindMethodCallbackHandler<ISCSITargetPort> callback = new FindMethodCallbackHandler<ISCSITargetPort>();
        ISCSITargetPort.getISCSIPorts(rmiObj, callback, portID);
        return callback.getReturnValue();
    }

    static final String getiSCSIName(String model, String serial, String portName, int hostGrp) {
        return String.format(iSCSINameFormat, model, serial, portName, hostGrp);
    }

    private static void getISCSIPorts(IteratorCallback<ISCSITargetPort> callback, int portID) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                ISCSITargetPort.getISCSIPorts(mapObj.getRMIObject(), callback, portID);
                continue;
            }
            cacheLogger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static void getISCSIPorts(RMIObjectCache rmiObj, IteratorCallback<ISCSITargetPort> callback, int portID) throws WBEMException {
        if (null == rmiObj) {
            ISCSITargetPort.getISCSIPorts(callback, portID);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            ISCSITargetPort[] ports = (ISCSITargetPort[])cache.getCachedObject(clz);
            if (null != ports) {
                ISCSITargetPortComparator<ISCSITargetPort> comparator = new ISCSITargetPortComparator<ISCSITargetPort>(portID);
                for (ISCSITargetPort port : ports) {
                    if (!comparator.isMatch(port)) continue;
                    callback.returnItem(port);
                }
            }
            callback.done();
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "iSCSITargetPort not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            ISCSITargetPort.getUnCachedISCSIPorts(rmiObj, callback, portID);
        }
    }

    private static void getUnCachedISCSIPorts(RMIObjectCache rmiObj, IteratorCallback<ISCSITargetPort> callback, int portID) throws WBEMException {
        String serialNumber = rmiObj.getSMISMappingContainer().getSerialNumber();
        try {
            cacheLogger.log(Level.INFO, "Entered getUncachediSCSIPorts for {0}", serialNumber);
            SanResponse responseData = rmiObj.keyValueAPI_InvokeKeyValueAPI("LUNMreadAllPortiScsiInfo", true);
            SanList ports = responseData.getList("iScsiPorts");
            cacheLogger.log(Level.INFO, "Found {0} ports", ports.size());
            ISCSITargetPortComparator<ISCSITargetPort> comparator = new ISCSITargetPortComparator<ISCSITargetPort>(portID);
            Iterator iter = ports.iterator();
            while (iter.hasNext()) {
                ISCSITargetPort iSCSIPort = new ISCSITargetPort(serialNumber, (SanObject)iter.next());
                if (ResourceRestriction.isPortUsable(serialNumber, (short)iSCSIPort.getPortId())) {
                    if (!comparator.isMatch(iSCSIPort)) continue;
                    callback.returnItem(iSCSIPort);
                    continue;
                }
                cacheLogger.log(Level.FINE, "Skipping unmanaged target port {0}", iSCSIPort.getPortId());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            Throwable temp = t;
            while (null != temp.getCause()) {
                temp = temp.getCause();
            }
            throw new WBEMException(1, t.toString() + " getting iSCSI ports", null, temp);
        }
        finally {
            if (null != callback) {
                callback.done();
            }
            cacheLogger.log(Level.INFO, "leaving getUncachediSCSIPorts for {0}", serialNumber);
        }
    }

    public static void update(String serialNumber, List<ISCSITargetPort> added, List<ISCSITargetPort> modified, List<ISCSITargetPort> removed) throws WBEMException {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
        if (null == device) {
            cacheLogger.log(Level.SEVERE, "Update called for device {0} but no device with that serial number is being managed", serialNumber);
            return;
        }
        RMIObjectCache rmiObj = device.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            List cached;
            ISCSITargetPort[] cachedArray = (ISCSITargetPort[])cache.getCachedObject(clz);
            if (null != cachedArray) {
                cached = new ArrayList<ISCSITargetPort>(Arrays.asList(cachedArray));
                cachedArray = null;
            } else {
                cached = Collections.emptyList();
            }
            cacheLogger.log(Level.FINE, "Cache has {0} ISCSITargetPorts", cached.size());
            ClosableAddableIteratorCB<ISCSITargetPort> callback = new ClosableAddableIteratorCB<ISCSITargetPort>();
            ISCSITargetPort.getUnCachedISCSIPorts(rmiObj, callback, -1);
            Collections.sort(cached);
            CloseableAddableIterator<ISCSITargetPort> iter = callback.getWrappedCloseableAddableIter();
            while (iter.hasNext()) {
                ISCSITargetPort nonCachedPort = (ISCSITargetPort)iter.next();
                int index = Collections.binarySearch(cached, nonCachedPort);
                if (index >= 0) {
                    ISCSITargetPort cachedPort = (ISCSITargetPort)cached.remove(index);
                    if (nonCachedPort.equals(cachedPort)) continue;
                    StringBuilder msg = new StringBuilder("ISCSITargetPort ");
                    msg.append(cachedPort.getPortId());
                    msg.append(" changed");
                    if (cacheLogger.isLoggable(Level.FINER)) {
                        msg.append(System.lineSeparator());
                        msg.append("Cached:");
                        msg.append(System.lineSeparator());
                        msg.append(cachedPort);
                        msg.append("Modified:");
                        msg.append(System.lineSeparator());
                        msg.append(nonCachedPort);
                    } else {
                        cacheLogger.log(Level.FINE, msg.toString());
                    }
                    modified.add(new ISCSITargetPort(cachedPort));
                    cachedPort.copy(nonCachedPort);
                    continue;
                }
                cacheLogger.log(Level.FINE, "ISCSITargetPort {0} added", nonCachedPort.getPortId());
                added.add(nonCachedPort);
            }
            removed.addAll(cached);
            if (!removed.isEmpty()) {
                cacheLogger.log(Level.FINER, "Removing ISCSITargetPorts{0}{1}", new Object[]{System.lineSeparator(), removed});
                CacheLib.removeDataFromCache(Collections.emptyMap(), (Serializable[])removed.toArray(new ISCSITargetPort[removed.size()]), clz, (String)serialNumber);
            }
            if (!added.isEmpty()) {
                cacheLogger.log(Level.FINER, "Addind ISCSITargetPorts{0}{1}", new Object[]{System.lineSeparator(), added});
                CacheLib.addItemsToCache(added, clz, serialNumber);
            }
        } else {
            cacheLogger.log(Level.SEVERE, "ISCSIPort is not cached for {0}, will cache now", serialNumber);
        }
    }

    private ISCSITargetPort(ISCSITargetPort cachedPort) {
        this(cachedPort.getSerialNumber());
        this.portID = cachedPort.getPortId();
        this.locationName = cachedPort.getLocationName();
        this.copyTargets(cachedPort.targets);
    }

    private ISCSITargetPort(String serialNumber) {
        super(serialNumber);
        this.targets = new ArrayList<ISCSITarget>();
    }

    private ISCSITargetPort(String serialNumber, SanObject port) throws SanDataException {
        this(serialNumber);
        this.portID = port.getInt("Id");
        this.locationName = port.getString("LocationName");
        this.populateISCSITargets(port);
    }

    @Override
    public int compareTo(ISCSITargetPort o) {
        int otherID = o.getPortId();
        return this.portID == otherID ? 0 : (this.portID < otherID ? -1 : 1);
    }

    private void copy(ISCSITargetPort nonCachedPort) {
        this.portID = nonCachedPort.portID;
        this.locationName = nonCachedPort.locationName;
        this.copyTargets(nonCachedPort.targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTargets(List<ISCSITarget> target2Copy) {
        this.targets.clear();
        for (ISCSITarget target : target2Copy) {
            if (this.domainIDsUsedByExposePaths.contains(target.getId())) {
                ISCSITargetPort iSCSITargetPort = this;
                synchronized (iSCSITargetPort) {
                    if (this.domainIDsUsedByExposePaths.contains(target.getId())) {
                        this.domainIDsUsedByExposePaths.remove(target.getId());
                    }
                }
            }
            this.targets.add(new ISCSITarget(target));
        }
    }

    public String createNewTargetName(String portStrName, short domainID, ISCSITarget[] outArg) throws WBEMException {
        short targetID;
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber());
        String model = device.getRMIObject().getSMIModelInfo().getiSCSIUnique();
        short s = targetID = -1 != domainID ? domainID : this.getAvailableTargetID();
        if (null != outArg && outArg.length > 0) {
            outArg[0] = new ISCSITarget(targetID);
        }
        return ISCSITargetPort.getiSCSIName(model, this.getSerialNumber(), portStrName, targetID);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ISCSITargetPort other = (ISCSITargetPort)obj;
        if (this.portID != other.portID) {
            return false;
        }
        if (this.locationName == null ? other.locationName != null : !this.locationName.equals(other.locationName)) {
            return false;
        }
        return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getAvailableTargetID() throws WBEMException {
        short retVal = -1;
        for (short x = 0; x < 255 && -1 == retVal; x = (short)(x + 1)) {
            if (null != this.getTarget(x) || this.domainIDsUsedByExposePaths.contains(x)) continue;
            ISCSITargetPort iSCSITargetPort = this;
            synchronized (iSCSITargetPort) {
                if (!this.domainIDsUsedByExposePaths.contains(x)) {
                    retVal = x;
                    this.domainIDsUsedByExposePaths.add(retVal);
                }
                continue;
            }
        }
        return retVal;
    }

    public String getLocationName() {
        return this.locationName;
    }

    private Map<Short, List<LoginiSCSINameHistory>> getLoginHistoryNames(SanList loginNameHistory) throws SanDataException {
        HashMap<Short, List<LoginiSCSINameHistory>> ret = new HashMap<Short, List<LoginiSCSINameHistory>>();
        int size = null == loginNameHistory ? 0 : loginNameHistory.size();
        cacheLogger.log(Level.INFO, "Found {0} Login iSCSI names history on target {1}", new Object[]{size, this.getPortId()});
        for (int x = 0; x < size && null != loginNameHistory; ++x) {
            LoginiSCSINameHistory lName = new LoginiSCSINameHistory(this.getSerialNumber(), loginNameHistory.getObj(x));
            for (short targetID : lName.getTargetIDs()) {
                ArrayList<LoginiSCSINameHistory> lNames = (ArrayList<LoginiSCSINameHistory>)ret.get(targetID);
                if (null == lNames) {
                    lNames = new ArrayList<LoginiSCSINameHistory>();
                    ret.put(targetID, lNames);
                }
                lNames.add(lName);
            }
        }
        return ret;
    }

    public int getPortId() {
        return this.portID;
    }

    private Map<Short, List<RemoteiSCSIName>> getRemoteNames(SanList remoteNamesList) throws SanDataException {
        HashMap<Short, List<RemoteiSCSIName>> ret = new HashMap<Short, List<RemoteiSCSIName>>();
        int size = null == remoteNamesList ? 0 : remoteNamesList.size();
        cacheLogger.log(Level.INFO, "Found {0} Login iSCSI remote names on target {1}", new Object[]{size, this.getPortId()});
        for (int x = 0; x < size && null != remoteNamesList; ++x) {
            RemoteiSCSIName rName = new RemoteiSCSIName(this.getSerialNumber(), remoteNamesList.getObj(x));
            for (short targetID : rName.getTargetIDs()) {
                ArrayList<RemoteiSCSIName> remoteNames = (ArrayList<RemoteiSCSIName>)ret.get(targetID);
                if (null == remoteNames) {
                    remoteNames = new ArrayList<RemoteiSCSIName>();
                    ret.put(targetID, remoteNames);
                }
                remoteNames.add(rName);
            }
        }
        return ret;
    }

    public ISCSITarget getTarget(short id) {
        ISCSITarget ret = null;
        for (ISCSITarget target : this.targets) {
            if (id != target.getId()) continue;
            ret = target;
            break;
        }
        return ret;
    }

    public List<ISCSITarget> getTargets() {
        return new ArrayList<ISCSITarget>(this.targets);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.portID;
        result = 31 * result + (this.locationName == null ? 0 : this.locationName.hashCode());
        result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
        return result;
    }

    private void populateISCSITargets(SanObject port) throws SanDataException {
        SanList iSCSITargets = port.getList("iScsiTargets");
        int size = null == iSCSITargets ? 0 : iSCSITargets.size();
        cacheLogger.log(Level.INFO, "Found {0} ports on target {1}", new Object[]{size, this.getPortId()});
        Map<Short, List<RemoteiSCSIName>> rNames = this.getRemoteNames(port.getList("RemoteiScsiNames"));
        Map<Short, List<LoginiSCSINameHistory>> lNames = this.getLoginHistoryNames(port.getList(LOGINI_SCSI_NAMES_HISTORY));
        for (int x = 0; x < size && null != iSCSITargets; ++x) {
            ISCSITarget target = new ISCSITarget(this.getSerialNumber(), iSCSITargets.getObj(x), rNames, lNames);
            try {
                if (ResourceRestriction.isPortUsable(target.getSerialNumber(), (short)target.getPortID())) {
                    this.targets.add(target);
                    continue;
                }
                cacheLogger.log(Level.FINE, "Skipping target port {0}, unmanaged", target.getId());
                continue;
            }
            catch (WBEMException we) {
                throw new SanDataException("Exception getting ResourceRestriction data", (Throwable)we);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ISCSITargetPort [id=");
        builder.append(this.portID);
        builder.append(", locationName=");
        builder.append(this.locationName);
        builder.append(", targets:");
        builder.append(System.lineSeparator());
        for (ISCSITarget target : this.targets) {
            builder.append(target);
            builder.append(System.lineSeparator());
        }
        builder.append("]");
        return builder.toString();
    }

    public class RemoteiSCSIName
    extends ISCSIName {
        private static final long serialVersionUID = -6234295130196222791L;
        private final String nickName;

        private RemoteiSCSIName(RemoteiSCSIName target) {
            super(target);
            this.nickName = target.nickName;
        }

        private RemoteiSCSIName(String serialNumber, SanObject remoteName) throws SanDataException {
            super(serialNumber, remoteName, true);
            this.nickName = remoteName.getString("NickName");
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RemoteiSCSIName other = (RemoteiSCSIName)obj;
            return !(this.nickName == null ? other.nickName != null : !this.nickName.equals(other.nickName));
        }

        public String getNickName() {
            return this.nickName;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.nickName == null ? 0 : this.nickName.hashCode());
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\t\t\tRemoteiSCSIName [nickName=");
            builder.append(this.nickName);
            builder.append(", ");
            builder.append(super.toString());
            builder.append("]");
            return builder.toString();
        }
    }

    public class LoginiSCSINameHistory
    extends ISCSIName {
        private static final long serialVersionUID = -3360490095440464799L;

        private LoginiSCSINameHistory(LoginiSCSINameHistory target) {
            super(target);
        }

        private LoginiSCSINameHistory(String serialNumber, SanObject nameHistory) throws SanDataException {
            super(serialNumber, nameHistory, true);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\t\t\tLoginiSCSINameHistory [");
            builder.append(super.toString());
            builder.append("]");
            return builder.toString();
        }
    }

    public static class ISCSITargetComparator
    implements Comparator<ISCSITarget> {
        @Override
        public int compare(ISCSITarget o1, ISCSITarget o2) {
            short o2ID;
            short o1ID = o1.getId();
            return o1ID < (o2ID = o2.getId()) ? -1 : (o1ID > o2ID ? 1 : 0);
        }
    }

    public class ISCSITarget
    extends ISCSIName {
        private static final long serialVersionUID = -3260086888660457751L;
        private final short id;
        private final String alias;
        private final int hostModeID;
        private final BitSet hostModeOption;
        private final List<RemoteiSCSIName> remoteNames;
        private final List<LoginiSCSINameHistory> loginNames;

        private ISCSITarget(ISCSITarget target) {
            super(target);
            this.id = target.id;
            this.alias = target.alias;
            this.hostModeID = target.hostModeID;
            this.hostModeOption = (BitSet)target.hostModeOption.clone();
            this.remoteNames = new ArrayList<RemoteiSCSIName>();
            this.loginNames = new ArrayList<LoginiSCSINameHistory>();
            for (RemoteiSCSIName rName : target.getRemoteNames()) {
                this.remoteNames.add(new RemoteiSCSIName(rName));
            }
            for (LoginiSCSINameHistory lName : target.getLoginNames()) {
                this.loginNames.add(new LoginiSCSINameHistory(lName));
            }
        }

        public ISCSITarget(short targetID) {
            this.id = targetID;
            this.remoteNames = Collections.emptyList();
            this.loginNames = Collections.emptyList();
            this.hostModeOption = new BitSet();
            this.hostModeID = -1;
            this.alias = "UNKNOWN";
        }

        private ISCSITarget(String serialNumber, SanObject target, Map<Short, List<RemoteiSCSIName>> rNames, Map<Short, List<LoginiSCSINameHistory>> lNames) throws SanDataException {
            super(serialNumber, target, false);
            this.id = (short)target.getInt("Id");
            this.alias = target.getString("Alias");
            this.hostModeID = target.getInt("HostModeId");
            this.hostModeOption = target.getBitSet("HostModeOption");
            List<RemoteiSCSIName> temp = rNames.get(this.id);
            this.remoteNames = null == temp ? Collections.emptyList() : temp;
            List<LoginiSCSINameHistory> temp2 = lNames.get(this.id);
            this.loginNames = null == temp2 ? Collections.emptyList() : temp2;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ISCSITarget other = (ISCSITarget)obj;
            if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
                return false;
            }
            if (this.hostModeID != other.hostModeID) {
                return false;
            }
            if (this.hostModeOption == null ? other.hostModeOption != null : !this.hostModeOption.equals(other.hostModeOption)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.loginNames == null ? other.loginNames != null : !this.loginNames.equals(other.loginNames)) {
                return false;
            }
            return !(this.remoteNames == null ? other.remoteNames != null : !this.remoteNames.equals(other.remoteNames));
        }

        public String getAlias() {
            return this.alias;
        }

        public UnsignedInteger16 getHostMode() {
            Integer val = this.hostModeID;
            return new UnsignedInteger16(PortandHostGroupInfo.setClientType(val.byteValue()));
        }

        public int getHostModeID() {
            return this.hostModeID;
        }

        public BitSet getHostModeOption() {
            return this.hostModeOption;
        }

        public short getId() {
            return this.id;
        }

        public List<LoginiSCSINameHistory> getLoginNames() {
            return this.loginNames;
        }

        public List<RemoteiSCSIName> getRemoteNames() {
            return this.remoteNames;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
            result = 31 * result + this.hostModeID;
            result = 31 * result + (this.hostModeOption == null ? 0 : this.hostModeOption.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + (this.loginNames == null ? 0 : this.loginNames.hashCode());
            result = 31 * result + (this.remoteNames == null ? 0 : this.remoteNames.hashCode());
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\tISCSITarget [id=");
            builder.append(this.id);
            builder.append(", alias=");
            builder.append(this.alias);
            builder.append(", hostModeID=");
            builder.append(this.hostModeID);
            builder.append(", hostModeOption=");
            builder.append(this.hostModeOption);
            builder.append(System.lineSeparator());
            builder.append("\t\tremoteNames:");
            builder.append(System.lineSeparator());
            for (ISCSIName iSCSIName : this.remoteNames) {
                builder.append(iSCSIName);
                builder.append(System.lineSeparator());
            }
            builder.append("\t\tloginNames:");
            builder.append(System.lineSeparator());
            for (LoginiSCSINameHistory loginiSCSINameHistory : this.loginNames) {
                builder.append(loginiSCSINameHistory);
                builder.append(System.lineSeparator());
            }
            builder.append("]");
            builder.append(System.lineSeparator());
            return builder.toString();
        }
    }

    public abstract class ISCSIName
    extends AbstractBaseCommonObject {
        private static final long serialVersionUID = -4734688340821998491L;
        private final String name;
        private List<Short> targetIDs;

        private ISCSIName() {
            super(ISCSITargetPort.this.getSerialNumber());
            this.name = "UNKNOWN";
            this.targetIDs = Collections.emptyList();
        }

        private ISCSIName(ISCSIName target) {
            super(target.getSerialNumber());
            this.name = target.name;
            this.targetIDs = new ArrayList<Short>(target.targetIDs);
        }

        private ISCSIName(String deviceSerialNumber, SanObject target, boolean getTargetIDs) throws SanDataException {
            super(deviceSerialNumber);
            this.name = target.getString("Name");
            if (getTargetIDs) {
                this.populateTargetIDs(target.getList("iScsiTargets"));
            } else {
                this.targetIDs = Collections.emptyList();
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ISCSIName other = (ISCSIName)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getName() {
            return this.name;
        }

        public int getPortID() {
            return ISCSITargetPort.this.getPortId();
        }

        public List<Short> getTargetIDs() {
            return this.targetIDs;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        private void populateTargetIDs(SanList targets) throws SanDataException {
            this.targetIDs = new ArrayList<Short>(targets.size());
            for (SanObject target : targets) {
                this.targetIDs.add((short)target.getInt("Id"));
            }
            Collections.sort(this.targetIDs);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("name=");
            builder.append(this.name);
            builder.append(", targetIDs=");
            builder.append(this.targetIDs);
            return builder.toString();
        }
    }
}

