/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.SnapshotInfo2;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.wbem.WBEMException;

public class SnapshotRestriction {
    private static final String MULTIPLE_SEPERATOR = "to";
    private final long minNum;
    private final long maxNum;

    private static long getDevNumFromString(String txt) throws WBEMException {
        long ret = -1L;
        StringTokenizer toker = new StringTokenizer(txt, ":");
        short dkc = -1;
        short cu = -1;
        short ldev = -1;
        if (3 == toker.countTokens()) {
            try {
                dkc = Short.decode("0x" + toker.nextToken());
                cu = Short.decode("0x" + toker.nextToken());
                ldev = Short.decode("0x" + toker.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new WBEMException(1, "Failed to parse LDEV: " + txt, null, (Throwable)nfe);
            }
            if (dkc < 0 || cu < 0 || ldev < 0) {
                throw new WBEMException("Failed to get DKC, CU or LDEV " + txt);
            }
        } else {
            throw new WBEMException("incorrect format for passed in string: " + txt);
        }
        ret = BaseDeviceNumber.makeUniqueDN(dkc, cu, ldev);
        return ret;
    }

    private static long getPoolIDFromString(String txt) throws WBEMException {
        long ret = -1L;
        int id = -1;
        try {
            id = Short.decode(txt).shortValue();
        }
        catch (NumberFormatException nfe) {
            throw new WBEMException(1, "Failed to parse Pool ID: " + txt, null, (Throwable)nfe);
        }
        if (id < 0) {
            throw new WBEMException("Failed to get Pool ID " + txt);
        }
        ret = id;
        return ret;
    }

    public static List<SnapshotRestriction> parseLDEVStr(String txt2Parse) throws WBEMException {
        ArrayList<SnapshotRestriction> ret = new ArrayList<SnapshotRestriction>();
        if (null != txt2Parse) {
            String[] split;
            for (String txt : split = txt2Parse.split(",")) {
                SnapshotRestriction sr;
                int index = txt.indexOf(MULTIPLE_SEPERATOR);
                if (-1 != index) {
                    String minStr = txt.substring(0, index);
                    String maxStr = txt.substring(index + MULTIPLE_SEPERATOR.length());
                    long min = SnapshotRestriction.getDevNumFromString(minStr);
                    long max = SnapshotRestriction.getDevNumFromString(maxStr);
                    sr = new SnapshotRestriction(min, max);
                } else {
                    long val = SnapshotRestriction.getDevNumFromString(txt);
                    sr = new SnapshotRestriction(val, val);
                }
                ret.add(sr);
            }
        }
        return ret;
    }

    public static List<SnapshotRestriction> parsePoolIDStr(String txt2Parse) throws WBEMException {
        ArrayList<SnapshotRestriction> ret = new ArrayList<SnapshotRestriction>();
        if (null != txt2Parse) {
            String[] split;
            for (String txt : split = txt2Parse.split(",")) {
                SnapshotRestriction sr;
                int index = txt.indexOf(MULTIPLE_SEPERATOR);
                if (-1 != index) {
                    String minStr = txt.substring(0, index);
                    String maxStr = txt.substring(index + MULTIPLE_SEPERATOR.length());
                    long min = SnapshotRestriction.getPoolIDFromString(minStr);
                    long max = SnapshotRestriction.getPoolIDFromString(maxStr);
                    sr = new SnapshotRestriction(min, max);
                } else {
                    long val = SnapshotRestriction.getPoolIDFromString(txt);
                    sr = new SnapshotRestriction(val, val);
                }
                ret.add(sr);
            }
        }
        return ret;
    }

    public static boolean valid2UseSnapshot(List<SnapshotRestriction> list, long devNum) {
        int size = null == list ? 0 : list.size();
        boolean ret = 0 == size;
        for (int x = 0; x < size && !ret; ++x) {
            SnapshotRestriction sr = list.get(x);
            ret = sr.valid2UseSnapshot(devNum);
        }
        return ret;
    }

    public static boolean valid2UseSnapshotPool(List<SnapshotRestriction> list, short poolID) {
        int size = null == list ? 0 : list.size();
        boolean ret = 0 == size;
        for (int x = 0; x < size && !ret; ++x) {
            SnapshotRestriction sr = list.get(x);
            ret = sr.valid2UseSnapshotPool(poolID);
        }
        return ret;
    }

    public SnapshotRestriction(long minLdevNum, long maxLdevNum) throws WBEMException {
        if (minLdevNum > maxLdevNum) {
            throw new WBEMException(minLdevNum + " is greater then " + maxLdevNum);
        }
        this.minNum = minLdevNum;
        this.maxNum = maxLdevNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotRestriction other = (SnapshotRestriction)obj;
        if (this.maxNum != other.maxNum) {
            return false;
        }
        return this.minNum == other.minNum;
    }

    public long getMaxNum() {
        return this.maxNum;
    }

    public long getMinNum() {
        return this.minNum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.maxNum ^ this.maxNum >>> 32);
        result = 31 * result + (int)(this.minNum ^ this.minNum >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SnapshotRestriction [minNum=");
        builder.append(this.minNum);
        builder.append(", maxNum=");
        builder.append(this.maxNum);
        builder.append("]");
        return builder.toString();
    }

    public boolean valid2UseSnapshot(DeviceNumber dn) {
        return null == dn ? false : this.valid2UseSnapshot(dn.getDn());
    }

    public boolean valid2UseSnapshot(long devNum) {
        boolean ret = false;
        if (devNum >= this.minNum && devNum <= this.maxNum) {
            ret = true;
        }
        return ret;
    }

    public boolean valid2UseSnapshot(SnapshotInfo2 si) {
        return null == si ? false : this.valid2UseSnapshotPool((short)si.getTiPoolID());
    }

    public boolean valid2UseSnapshotPool(short poolID) {
        boolean ret = false;
        if ((long)poolID >= this.minNum && (long)poolID <= this.maxNum) {
            ret = true;
        }
        return ret;
    }
}

