/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.RMIObjectMapping;
import com.ws.wbem.CloseableAddableIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageHardwareIDs {
    private static volatile StorageHardwareIDs theOne = null;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    public static final UnsignedInteger16 CPV_IDTYPE = ProviderConstants.UINT16_TWO;
    public static final UnsignedInteger16 CPV_iSCSIIDTYPE = ProviderConstants.UINT16_FIVE;
    private static final String UNASSIGNED_HARDWARE_IDS_MAP_SER = "unassignedStorageHardwareIDMap.ser";
    private static final String[] iqnVals = new String[]{"iqn.", "naa.", "eui."};
    private Map<String, Set<String>> unasignedStorageHardwareIDMap = new Hashtable<String, Set<String>>();
    private final Hashtable<String, String> mWWNNickname = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StorageHardwareIDs getStorageHardwareIDs() {
        StorageHardwareIDs ret = theOne;
        if (null != ret) return ret;
        Class<StorageHardwareIDs> clazz = StorageHardwareIDs.class;
        synchronized (StorageHardwareIDs.class) {
            ret = theOne;
            if (null != ret) return ret;
            theOne = ret = new StorageHardwareIDs();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    public static boolean isIDHostWWN(String id) {
        boolean ret = false;
        try {
            if (null != id && id.length() == 16 && id.toUpperCase().equals(id)) {
                new BigInteger(id, 16);
                ret = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean isIDiSCSIName(String idValue) {
        boolean ret = false;
        int idx = idValue.indexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        if (3 == idx) {
            String start = idValue.substring(0, 4);
            for (String val : iqnVals) {
                if (!start.equals(val)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private StorageHardwareIDs() {
        this.loadUnassignedIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnassignedStorageHardwareID(String serialNum, String id) throws WBEMException {
        boolean ret = false;
        if (null != id && id.length() > 0) {
            Set<String> idList = this.unasignedStorageHardwareIDMap.get(serialNum);
            if (null == idList) {
                Map<String, Set<String>> map = this.unasignedStorageHardwareIDMap;
                synchronized (map) {
                    idList = new HashSet<String>();
                    this.unasignedStorageHardwareIDMap.put(serialNum, idList);
                }
            }
            if (ret = idList.add(id)) {
                this.writeUnassignedIDs();
            }
        }
        return ret;
    }

    public Set<String> getAllStorageHardwareIDs(RMIObjectMapping device, String expCtrID, String expPortID, String expDomainID, String expHostWWN, String expClientType, ArrayList<String> expIncluded, ArrayList<String> expExcluded) throws WBEMException {
        Set<String> storageHardwareIDs = this.getAssignedStorageHardwareIDs(device, expCtrID, expPortID, expDomainID, expHostWWN, expClientType, expIncluded, expExcluded);
        if (null == expCtrID && null == expPortID && null == expClientType) {
            Set<String> idList = this.unasignedStorageHardwareIDMap.get(device.getSerialNumber());
            Iterator<String> unassignedIter = null != idList ? idList.iterator() : Collections.emptySet().iterator();
            while (unassignedIter.hasNext()) {
                String id = unassignedIter.next();
                if (null != expHostWWN && !expHostWWN.equals(id) || null != expIncluded && !expIncluded.contains(id) || null != expExcluded && expExcluded.contains(id)) continue;
                storageHardwareIDs.add(id);
            }
        }
        return storageHardwareIDs;
    }

    private Set<String> getAssignedStorageHardwareIDs(RMIObjectMapping device) throws WBEMException {
        return this.getAssignedStorageHardwareIDs(device, null, null, null, null, null, null, null);
    }

    private Set<String> getAssignedStorageHardwareIDs(RMIObjectMapping device, String ctrlID, String portID, String domainID, String expHostWWN, String clientType, ArrayList<String> expIncluded, ArrayList<String> expExcluded) throws WBEMException {
        HashSet<String> ret = new HashSet<String>();
        this.getFCHostGroupIDs(ret, device, ctrlID, portID, domainID, expHostWWN, clientType, expIncluded, expExcluded);
        this.getiSCSINames(ret, device, ctrlID, portID, domainID, expHostWWN, clientType, expIncluded, expExcluded);
        return ret;
    }

    private void getFCHostGroupIDs(Set<String> idDestination, RMIObjectMapping device, String ctrlID, String portID, String domainID, String expHostWWN, String clientType, ArrayList<String> expIncluded, ArrayList<String> expExcluded) throws WBEMException {
        ClosableAddableIteratorCB<PortandHostGroupInfo> callback = new ClosableAddableIteratorCB<PortandHostGroupInfo>();
        PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, null, ctrlID, portID, domainID, expHostWWN, true, null, false);
        CloseableAddableIterator<PortandHostGroupInfo> phgiIter = callback.getWrappedCloseableAddableIter();
        while (phgiIter.hasNext()) {
            PortandHostGroupInfo phgi = (PortandHostGroupInfo)phgiIter.next();
            for (String hostWWN : phgi.getHostWWNs()) {
                if (!(null != expHostWWN && !expHostWWN.equals(hostWWN) || null != expIncluded && !expIncluded.contains(hostWWN) || null != expExcluded && expExcluded.contains(hostWWN))) {
                    idDestination.add(hostWWN);
                }
                this.mWWNNickname.put(hostWWN, phgi.getWWNNickName(hostWWN));
            }
        }
    }

    private void getiSCSINames(Set<String> ret, RMIObjectMapping device, String ctrlID, String portID, String domainID, String expHostWWN, String clientType, ArrayList<String> expIncluded, ArrayList<String> expExcluded) throws WBEMException {
        short expCtrID;
        ClosableAddableIteratorCB<ISCSITargetPort> iSCSIcb = new ClosableAddableIteratorCB<ISCSITargetPort>();
        ISCSITargetPort.getISCSIPorts(device.getRMIObject(), iSCSIcb, null == portID ? -1 : Integer.parseInt(portID));
        CloseableAddableIterator<ISCSITargetPort> iSCSIIter = iSCSIcb.getWrappedCloseableAddableIter();
        int expDomainID = null == domainID ? -1 : Integer.parseInt(domainID);
        short s = expCtrID = null == ctrlID ? (short)-1 : (short)Short.parseShort(ctrlID);
        while (iSCSIIter.hasNext()) {
            ISCSITargetPort port = (ISCSITargetPort)iSCSIIter.next();
            List<ISCSITargetPort.ISCSITarget> targets = port.getTargets();
            for (ISCSITargetPort.ISCSITarget target : targets) {
                List<ISCSITargetPort.RemoteiSCSIName> rNames = target.getRemoteNames();
                for (ISCSITargetPort.RemoteiSCSIName rName : rNames) {
                    byte client = new Integer(target.getHostModeID()).byteValue();
                    if (!(-1 != expDomainID && target.getId() != expDomainID || -1 != expCtrID && expCtrID != FCPort.getCtrlID((short)port.getPortId(), target.getSerialNumber()) || null != clientType && !clientType.equals(PortandHostGroupInfo.setClientType(client)))) {
                        ret.add(rName.getName());
                    }
                    this.mWWNNickname.put(rName.getName(), rName.getNickName());
                }
            }
        }
    }

    public Set<String> getUnasignedStorageHardwareIDs(String serialNumber) {
        Set<String> unassigned = this.unasignedStorageHardwareIDMap.get(serialNumber);
        return unassigned != null ? unassigned : Collections.emptySet();
    }

    public String getWWNNickName(String id) {
        String ret = null;
        if (null != id) {
            ret = this.mWWNNickname.get(id);
        }
        return ret;
    }

    public boolean isIDAssigned(RMIObjectMapping device, String id) {
        boolean ret = false;
        if (null != id && id.length() > 0) {
            try {
                ret = this.getAssignedStorageHardwareIDs(device).contains(id);
            }
            catch (WBEMException we) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isIDCreated(RMIObjectMapping device, String id) throws WBEMException {
        boolean ret = false;
        Set<String> t = this.unasignedStorageHardwareIDMap.get(device.getSerialNumber());
        Set<String> idList = null != t ? t : Collections.emptySet();
        if (idList.contains(id) || this.isIDAssigned(device, id)) {
            ret = true;
        }
        return ret;
    }

    private void loadUnassignedIDs() {
        block29: {
            try {
                String dirName = ProviderConstants.getDatDirectory();
                String settingsFile = dirName + UNASSIGNED_HARDWARE_IDS_MAP_SER;
                File test = new File(settingsFile);
                if (!test.exists()) break block29;
                try (FileInputStream fin = new FileInputStream(test);
                     ObjectInputStream in = new ObjectInputStream(fin);){
                    try {
                        Map temp;
                        this.unasignedStorageHardwareIDMap = temp = (Map)in.readObject();
                    }
                    catch (ClassCastException cce) {
                        mLogger.log(Level.SEVERE, "The file, unassignedStorageHardwareIDMap.ser doesn't appear to contain the proper data", cce);
                    }
                    catch (ClassNotFoundException cnfe) {
                        mLogger.log(Level.SEVERE, "Exception attempting to read serialized hardwareIDs", cnfe);
                    }
                }
            }
            catch (IOException ex) {
                mLogger.log(Level.SEVERE, "Error trying to read unassignedStorageHardwareIDMap.ser", ex);
            }
        }
    }

    public boolean removeUnassignedStorageHardwareID(String serialNum, String id) {
        Set<String> idList;
        boolean ret = false;
        if (null != id && id.length() > 0 && null != (idList = this.unasignedStorageHardwareIDMap.get(serialNum)) && (ret = idList.remove(id))) {
            this.writeUnassignedIDs();
        }
        return ret;
    }

    private void writeUnassignedIDs() {
        String dirName = ProviderConstants.getDatDirectory();
        String settingsFile = dirName + UNASSIGNED_HARDWARE_IDS_MAP_SER;
        File test = new File(settingsFile);
        if (test.exists()) {
            try (FileOutputStream fOut = new FileOutputStream(test);
                 ObjectOutputStream out = new ObjectOutputStream(fOut);){
                try {
                    out.writeObject(this.unasignedStorageHardwareIDMap);
                }
                catch (IOException ioe) {
                    mLogger.log(Level.SEVERE, "Error trying to write unassignedStorageHardwareIDMap.ser", ioe);
                }
            }
            catch (IOException ioe) {
                mLogger.log(Level.SEVERE, "Error trying to open unassignedStorageHardwareIDMap.ser", ioe);
            }
        }
    }
}

