/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.RMIObjectMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_GetTierInfo2;

public class TierInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    short mDTPoolID;
    int mTierOrder;
    int mDriveAttribute;
    int mRaidLevel;
    long mTierRangeDelta;
    long mTierRangeValue;
    long mTotalTier;
    long mUseTier;
    ArrayList<Long> mLdevList;
    private final short mTierAllocateCapa;
    private final short mTierRelocateCapa;
    private final String mSerialNumber;

    public static final short[] getStorageTierInstanceIDValues(String instID, String[] retSystemName) throws WBEMException {
        short[] ret = null;
        if (null != instID) {
            try {
                String tierOrderString;
                String poolIDStr;
                int poolIDIdx;
                int tierOrderIdx = instID.lastIndexOf(".");
                int n = poolIDIdx = -1 == tierOrderIdx ? -1 : instID.lastIndexOf(".", tierOrderIdx - 1);
                if (tierOrderIdx != -1 || poolIDIdx != -1) {
                    poolIDStr = instID.substring(tierOrderIdx + 1);
                    tierOrderString = instID.substring(poolIDIdx + 1, tierOrderIdx);
                    if (null != retSystemName && retSystemName.length > 0) {
                        retSystemName[0] = instID.substring(0, poolIDIdx);
                    }
                } else {
                    throw new WBEMException(1, "Instance ID is not valid: " + instID);
                }
                ret = new short[]{-1, -1};
                ret[0] = Short.parseShort(tierOrderString);
                ret[1] = Short.parseShort(poolIDStr);
            }
            catch (NumberFormatException nfe) {
                throw new WBEMException(1, "Failed to convert string (" + instID + ")to short values", null, (Throwable)nfe);
            }
        }
        return ret;
    }

    public TierInfo(String serialNum, short dtPoolID, short tierOrder, Robj_interface_GetTierInfo2 getTierInfo, ArrayList<Long> ldevList) {
        this.mSerialNumber = serialNum;
        this.mDTPoolID = dtPoolID;
        this.mTierOrder = tierOrder;
        this.mDriveAttribute = getTierInfo.getIDriveAttribute();
        this.mRaidLevel = getTierInfo.getIRAIDLevel();
        this.mTierRangeDelta = getTierInfo.getLTierRangeDelta();
        this.mTierRangeValue = getTierInfo.getLTierRangeValue();
        this.mTotalTier = getTierInfo.getLTotalTier();
        this.mUseTier = getTierInfo.getLUseTier();
        this.mTierAllocateCapa = getTierInfo.getSTierAlocateCapa();
        this.mTierRelocateCapa = getTierInfo.getSTierRelocateCapa();
        this.mLdevList = null != ldevList ? ldevList : new ArrayList();
        Collections.sort(this.mLdevList);
    }

    public TierInfo(TierInfo orig) {
        this.mSerialNumber = orig.mSerialNumber;
        this.mTierAllocateCapa = orig.mTierAllocateCapa;
        this.mTierRelocateCapa = orig.mTierRelocateCapa;
        this.mDTPoolID = orig.mDTPoolID;
        this.mTierOrder = orig.mTierOrder;
        this.mDriveAttribute = orig.mDriveAttribute;
        this.mRaidLevel = orig.mRaidLevel;
        this.mTierRangeDelta = orig.mTierRangeDelta;
        this.mTierRangeValue = orig.mTierRangeValue;
        this.mTotalTier = orig.mTotalTier;
        this.mUseTier = orig.mUseTier;
        this.mLdevList = (ArrayList)orig.mLdevList.clone();
    }

    public boolean createdFromLDev(Long ldev) {
        boolean ret = false;
        if (null != ldev && null != this.mLdevList && Collections.binarySearch(this.mLdevList, ldev) >= 0) {
            ret = true;
        }
        return ret;
    }

    public boolean createdFromLDev(String ldev) {
        boolean ret = false;
        if (null != ldev && null != this.mLdevList) {
            try {
                ret = this.createdFromLDev(Long.parseLong(ldev));
            }
            catch (NumberFormatException nfe) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.log(Level.SEVERE, "Unable to convert " + ldev + " to a long!", nfe);
            }
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TierInfo other = (TierInfo)obj;
        if (this.mSerialNumber == null ? other.mSerialNumber != null : !this.mSerialNumber.equals(other.mSerialNumber)) {
            return false;
        }
        if (this.mDTPoolID != other.mDTPoolID) {
            return false;
        }
        if (this.mDriveAttribute != other.mDriveAttribute) {
            return false;
        }
        if (this.mLdevList == null ? other.mLdevList != null : !this.mLdevList.equals(other.mLdevList)) {
            return false;
        }
        if (this.mRaidLevel != other.mRaidLevel) {
            return false;
        }
        if (this.mTierOrder != other.mTierOrder) {
            return false;
        }
        if (this.mTierRangeDelta != other.mTierRangeDelta) {
            return false;
        }
        if (this.mTierRangeValue != other.mTierRangeValue) {
            return false;
        }
        if (this.mTotalTier != other.mTotalTier) {
            return false;
        }
        return this.mUseTier == other.mUseTier;
    }

    public int getDriveAttribute() {
        return this.mDriveAttribute;
    }

    public Long[] getLDevs() {
        return this.mLdevList.toArray(new Long[this.mLdevList.size()]);
    }

    public short getPoolID() {
        return this.mDTPoolID;
    }

    public int getRaidLevel() {
        return this.mRaidLevel;
    }

    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    public String getStorageTierInstanceID() throws Exception {
        return RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber()).getStorageSystemName() + "." + String.valueOf(this.mDTPoolID) + "." + String.valueOf(this.mTierOrder);
    }

    public short getTierAllocateCapa() {
        return this.mTierAllocateCapa;
    }

    public int getTierOrder() {
        return this.mTierOrder;
    }

    public long getTierRangeDelta() {
        return this.mTierRangeDelta;
    }

    public long getTierRangeValue() {
        return this.mTierRangeValue;
    }

    public short getTierRelocateCapa() {
        return this.mTierRelocateCapa;
    }

    public long getTotalTier() {
        return this.mTotalTier;
    }

    public long getUseTier() {
        return this.mUseTier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mDTPoolID;
        result = 31 * result + this.mDriveAttribute;
        result = 31 * result + (this.mLdevList == null ? 0 : this.mLdevList.hashCode());
        result = 31 * result + this.mRaidLevel;
        result = 31 * result + this.mTierOrder;
        result = 31 * result + (this.mSerialNumber == null ? 0 : this.mSerialNumber.hashCode());
        result = 31 * result + (int)(this.mTierRangeDelta ^ this.mTierRangeDelta >>> 32);
        result = 31 * result + (int)(this.mTierRangeValue ^ this.mTierRangeValue >>> 32);
        result = 31 * result + (int)(this.mTotalTier ^ this.mTotalTier >>> 32);
        result = 31 * result + (int)(this.mUseTier ^ this.mUseTier >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TierInfo [mSerialNumber=");
        builder.append(this.mSerialNumber);
        builder.append(", mDTPoolID=");
        builder.append(this.mDTPoolID);
        builder.append(", mTierOrder=");
        builder.append(this.mTierOrder);
        builder.append(", mDriveAttribute=");
        builder.append(this.mDriveAttribute);
        builder.append(", mRaidLevel=");
        builder.append(this.mRaidLevel);
        builder.append(", mTierRangeDelta=");
        builder.append(this.mTierRangeDelta);
        builder.append(", mTierRangeValue=");
        builder.append(this.mTierRangeValue);
        builder.append(", mTotalTier=");
        builder.append(this.mTotalTier);
        builder.append(", mUseTier=");
        builder.append(this.mUseTier);
        builder.append(", mTierAllocateCapa=");
        builder.append(this.mTierAllocateCapa);
        builder.append(", mTierRelocateCapa=");
        builder.append(this.mTierRelocateCapa);
        builder.append(", mLdevList=");
        builder.append(this.mLdevList);
        builder.append("]");
        return builder.toString();
    }
}

