/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_ChangeDataAllString;
import sanproject.common.Robj_interface_DISKgetErrorLogInfo;

public class AlertIndicationInstrumentation
extends BaseInstrumentation {
    private static String drm28Msg = "Thin provisioned Pool with identifier %s capacity in use nearing available limit.";
    private static String drm29Msg = "Thin provisioned Pool with identifier %s capacity in use exceeded available limit.";
    private static String drm30Msg = "Thin provisioned Pool with identifier %s capacity condition cleared.";
    private static final String SERVISE = "Servise";
    private static final String MODERTATE = "Moderate";
    private static final String SERIOUS = "Serious";
    private static final String ACUTE = "Acute";
    private static final UnsignedInteger16 UNKNOWN = ProviderConstants.UINT16_ZED;
    private static final UnsignedInteger16 FATAL = ProviderConstants.UINT16_TWO;
    private static final UnsignedInteger16 CRITICAL = ProviderConstants.UINT16_THREE;
    private static final UnsignedInteger16 MINOR = ProviderConstants.UINT16_FOUR;
    private static final UnsignedInteger16 MAJOR = ProviderConstants.UINT16_FIVE;
    private static FaultThread worker = null;
    private static long sleepMillis = 0L;
    private static boolean mGenericFaultStarted = false;
    private static Map<String, UnsignedInteger16> sevMap = new HashMap<String, UnsignedInteger16>();
    private static final String[] SUPPORTED_INDICATIONS = new String[]{"select * from HITACHI_AlertIndication", "select * from CIM_AlertIndication", "SELECT * FROM CIM_AlertIndication WHERE OwningEntity='SNIA' and MessageID='DRM28'", "SELECT * FROM CIM_AlertIndication WHERE OwningEntity='SNIA' and MessageID='DRM29'", "SELECT * FROM CIM_AlertIndication WHERE OwningEntity='SNIA' and MessageID='DRM30'"};
    Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.alert");
    private boolean drm28Listening;
    private boolean drm29Listening;
    private boolean drm30Listening;

    public static long getSleepMillis() {
        return sleepMillis;
    }

    public static String[] getSupportedIndications() {
        return SUPPORTED_INDICATIONS;
    }

    private static synchronized boolean isGenericStarted() {
        return mGenericFaultStarted;
    }

    private static synchronized void setGenericListening(boolean started) {
        mGenericFaultStarted = started;
    }

    public AlertIndicationInstrumentation() {
        int sleepSec = ProviderProperties.getErrorCheckIntervalSeconds();
        sleepMillis = TimeUnit.MILLISECONDS.convert(sleepSec, TimeUnit.SECONDS);
        this.drm30Listening = false;
        this.drm29Listening = false;
        this.drm28Listening = false;
        CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.THINPOOL, new cacheUpdate(), null);
    }

    private CIMInstance createTestSubscription(CIMObjectPath opListener) {
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("Handler", new CIMDataType("CIM_ListenerDestination"), (Object)opListener, true), new CIMProperty("Filter", new CIMDataType("CIM_ManagedElement"), null, true)};
        CIMObjectPath opSubscription = new CIMObjectPath(opListener.getScheme(), opListener.getHost(), opListener.getPort(), JServerProperties.getInteropNamespace(), "WS_IndicationSubscription", keys);
        return new CIMInstance(opSubscription, keys);
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        throw new WBEMException(7);
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        throw new WBEMException(7);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath p, Object ... o) throws Exception {
        return null;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        return null;
    }

    private Calendar getLogTime(String eventDate, String eventTime) {
        Date d1;
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            d1 = df.parse(eventDate + " " + eventTime);
        }
        catch (ParseException e) {
            this.mLogger.log(Level.SEVERE, "Unable to parse log date/time: " + eventDate + "/" + eventTime, e);
            d1 = new Date();
        }
        Calendar ret = Calendar.getInstance();
        ret.setTime(d1);
        return ret;
    }

    private CIMProperty<?>[] getProperties(RMIObjectMapping device, Robj_interface_DISKgetErrorLogInfo log) throws WBEMException {
        Calendar cal = this.getLogTime(log.getStrEventListDate(), log.getStrEventListTime());
        CIMDateTimeAbsolute eventTime = new CIMDateTimeAbsolute(cal);
        this.getSeverityTable(device);
        return this.getProperties(device, log.getStrEventListREFCODE(), log.getStrEventListREFCODE(), (CIMDateTime)eventTime, sevMap.get(log.getStrEventListREFCODE()));
    }

    private CIMProperty<?>[] getProperties(RMIObjectMapping device, String description, String eventID, CIMDateTime eventTime, UnsignedInteger16 perceivedSeverity) throws WBEMException {
        String systemName;
        CIMObjectPath opSS;
        String providerName = device.isHitachiSystem() ? "HITACHI SMI-S Provider" : "SVP CLI/SMI-S";
        try {
            opSS = this.getStorageSystemOP(device.getRMIObject());
            systemName = device.getStorageSystemName();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Unable to get system name", null, e);
        }
        if (sevMap.isEmpty()) {
            this.getSeverityTable(device);
        }
        return new CIMProperty[]{new CIMProperty("Description", CIMDataType.STRING_T, (Object)description, false), new CIMProperty("AlertingManagedElement", CIMDataType.STRING_T, (Object)(opSS == null ? "null" : opSS.toString()), false), new CIMProperty("AlertingElementFormat", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("AlertType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("PerceivedSeverity", CIMDataType.UINT16_T, (Object)sevMap.get(Long.toString(null == perceivedSeverity ? 0L : perceivedSeverity.longValue())), false), new CIMProperty("ProbableCause", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("EventID", CIMDataType.STRING_T, (Object)eventID, false), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", false), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, false), new CIMProperty("ProviderName", CIMDataType.STRING_T, (Object)providerName, false), new CIMProperty("EventTime", CIMDataType.DATETIME_T, (Object)eventTime, false), new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false)};
    }

    private synchronized void getSeverityTable(RMIObjectMapping device) {
        try {
            if (sevMap.isEmpty()) {
                RMIObjectCache rmiobj = device.getRMIObject();
                ArrayList<String> array = new ArrayList<String>();
                array.add("Rsim");
                ArrayList<?> retArray = rmiobj.getDataChangeTable(array);
                for (Object x : retArray) {
                    Robj_interface_ChangeDataAllString[] elems;
                    for (Robj_interface_ChangeDataAllString elem : elems = (Robj_interface_ChangeDataAllString[])x) {
                        UnsignedInteger16 value;
                        String refCode = elem.getStrChangeData5();
                        if (refCode != null && refCode.length() > 0) {
                            if (refCode.startsWith(SERVISE)) {
                                value = MINOR;
                            } else if (refCode.startsWith(MODERTATE)) {
                                value = MAJOR;
                            } else if (refCode.startsWith(SERIOUS)) {
                                value = CRITICAL;
                            } else if (refCode.startsWith(ACUTE)) {
                                value = FATAL;
                            } else {
                                this.mLogger.log(Level.WARNING, "Unknown reference code: {0}", refCode);
                                value = UNKNOWN;
                            }
                        } else {
                            this.mLogger.log(Level.WARNING, "Invalid reference code: {0}", refCode);
                            value = UNKNOWN;
                        }
                        sevMap.put(elem.getStrMibData(), value);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.mLogger.log(Level.SEVERE, "Error getting severity table", e);
            sevMap.clear();
        }
    }

    private CIMObjectPath getStorageSystemOP(RMIObjectCache rmiObjectCache) {
        CIMObjectPath ret;
        try {
            BaseInstrumentation ss = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation");
            CIMObjectPath tObj = new CIMObjectPath(null, null, null, ProviderLibs.getImplementationNamespace(), "HITACHI_AlertIndication", null);
            ret = ss.generateObjectPath(tObj, rmiObjectCache);
        }
        catch (Exception e) {
            ret = null;
            this.mLogger.log(Level.SEVERE, "Unable to get StorageSystem", e);
        }
        return ret;
    }

    private void handleDRMAlert(String query, boolean startListening) {
        if (query.contains("DRM28")) {
            this.drm28Listening = startListening;
        } else if (query.contains("DRM29")) {
            this.drm29Listening = startListening;
        } else if (query.contains("DRM30")) {
            this.drm30Listening = startListening;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        this.mLogger.finest("Request for \"" + query + "\", startListening: " + startListening);
        String selectStmt = "select *";
        String querySelect = query.substring(0, "select *".length());
        if (querySelect.compareToIgnoreCase("select *") == 0) {
            if (query.contains("DRM")) {
                this.handleDRMAlert(query, startListening);
                return;
            }
            if (startListening) {
                if (AlertIndicationInstrumentation.isGenericStarted()) return;
                this.mLogger.finer("Starting to look for alerts");
                Class<AlertIndicationInstrumentation> clazz = AlertIndicationInstrumentation.class;
                synchronized (AlertIndicationInstrumentation.class) {
                    if (worker != null) return;
                    AlertIndicationInstrumentation.setGenericListening(true);
                    worker = new FaultThread();
                    worker.setName("Fault Notification Thread");
                    worker.setDaemon(true);
                    this.mLogger.finer("Fault notification thread started.");
                    worker.start();
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
            }
            AlertIndicationInstrumentation.setGenericListening(false);
            Class<AlertIndicationInstrumentation> clazz = AlertIndicationInstrumentation.class;
            synchronized (AlertIndicationInstrumentation.class) {
                worker = null;
                // ** MonitorExit[var5_6] (shouldn't be in output)
                this.mLogger.finer("No one is listening to alerts anymore, terminating thread");
                return;
            }
        }
        this.mLogger.finest("The query is not supported: " + query);
    }

    public void sendTestAlert(RMIObjectMapping device, String description, String eventID, CIMDateTime eventTime, UnsignedInteger16 perceivedSeverity, CIMObjectPath listener) throws WBEMException {
        this.mLogger.info("Sending test alert indication");
        CIMObjectPath obj = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_AlertIndication", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        CIMProperty<?>[] props = this.getProperties(device, description, eventID, eventTime, perceivedSeverity);
        CIMInstance indication = new CIMInstance(obj, props);
        if (null == listener) {
            mHandle.deliverEvent(indication, null);
        } else {
            CIMInstance instSubscription = this.createTestSubscription(listener);
            mHandle.deliverEvent(indication, new CIMInstance[]{instSubscription});
        }
        this.mLogger.info("Indications submitted to server.");
    }

    private class FaultThread
    extends Thread {
        private Map<String, Robj_interface_DISKgetErrorLogInfo[]> dataLogs;
        private Collection<RMIObjectMapping> devices;

        FaultThread() {
            try {
                this.devices = RMIObjectMapping.getAllRMIObjectMappings();
                this.dataLogs = new HashMap<String, Robj_interface_DISKgetErrorLogInfo[]>();
                for (RMIObjectMapping device : this.devices) {
                    Robj_interface_DISKgetErrorLogInfo[] dataLog = device.getRMIObject().getErrorLogInfo();
                    this.dataLogs.put(device.getSerialNumber(), dataLog);
                }
            }
            catch (Exception e) {
                if (AlertIndicationInstrumentation.this.mLogger.isLoggable(Level.SEVERE)) {
                    AlertIndicationInstrumentation.this.mLogger.log(Level.SEVERE, "getErrorInfo failed.", e);
                }
                this.dataLogs.clear();
            }
        }

        private void compareLogs() {
            for (RMIObjectMapping device : this.devices) {
                try {
                    List<Robj_interface_DISKgetErrorLogInfo> logs;
                    Robj_interface_DISKgetErrorLogInfo[] currentLogs = device.getRMIObject().getErrorLogInfo();
                    Robj_interface_DISKgetErrorLogInfo[] oldLog = this.dataLogs.get(device.getSerialNumber());
                    if (null == oldLog) {
                        AlertIndicationInstrumentation.this.mLogger.log(Level.INFO, "No old logs for {0}, checking for new ones", device.getSerialNumber());
                        this.dataLogs.put(device.getSerialNumber(), currentLogs);
                        logs = Arrays.asList(currentLogs);
                    } else {
                        AlertIndicationInstrumentation.this.mLogger.log(Level.INFO, "Old logs exist for {0}, comparing with new ones", device.getSerialNumber());
                        ArrayList<Robj_interface_DISKgetErrorLogInfo> tList = new ArrayList<Robj_interface_DISKgetErrorLogInfo>();
                        for (Robj_interface_DISKgetErrorLogInfo curLog : currentLogs) {
                            boolean matched = false;
                            for (int idx2 = 0; idx2 < oldLog.length && !matched; ++idx2) {
                                Robj_interface_DISKgetErrorLogInfo log = oldLog[idx2];
                                matched = this.isSameDISKGetErrorLogInfo(curLog, log);
                            }
                            if (matched) continue;
                            tList.add(curLog);
                        }
                        logs = tList;
                    }
                    if (logs.size() > 0) {
                        this.sendAlerts(device, logs);
                        this.dataLogs.put(device.getSerialNumber(), currentLogs);
                        continue;
                    }
                    AlertIndicationInstrumentation.this.mLogger.log(Level.INFO, "No differences detected between logs for {0}", device.getSerialNumber());
                }
                catch (Exception e) {
                    AlertIndicationInstrumentation.this.mLogger.log(Level.SEVERE, "Unable to properly determine alerts.", e);
                }
            }
        }

        private boolean isSameDISKGetErrorLogInfo(Robj_interface_DISKgetErrorLogInfo curLog, Robj_interface_DISKgetErrorLogInfo oldLog) {
            boolean ret = false;
            if (curLog.getStrEventListREFCODE().compareTo(oldLog.getStrEventListREFCODE()) == 0 && curLog.getStrEventListTime().compareTo(oldLog.getStrEventListTime()) == 0 && curLog.getStrEventListDate().compareTo(oldLog.getStrEventListDate()) == 0) {
                ret = true;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                if (!AlertIndicationInstrumentation.isGenericStarted()) {
                    AlertIndicationInstrumentation.this.mLogger.log(Level.INFO, "Alert thread exiting.");
                    return;
                }
                try {
                    this.compareLogs();
                    AlertIndicationInstrumentation.this.mLogger.finest("Comparision done, sleeping for " + sleepMillis + " milliseconds");
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    AlertIndicationInstrumentation.this.mLogger.log(Level.INFO, "Alert thread interupted.");
                    AlertIndicationInstrumentation.setGenericListening(false);
                    Class<AlertIndicationInstrumentation> clazz = AlertIndicationInstrumentation.class;
                    // MONITORENTER : com.hitachi.smi.instrumentation.AlertIndicationInstrumentation.class
                    worker = null;
                    // MONITOREXIT : clazz
                    continue;
                }
                break;
            }
        }

        private void sendAlerts(RMIObjectMapping device, List<Robj_interface_DISKgetErrorLogInfo> logs) {
            AlertIndicationInstrumentation.this.mLogger.info("Sending " + logs.size() + " alert indications");
            CIMObjectPath obj = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_AlertIndication", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            for (Robj_interface_DISKgetErrorLogInfo log : logs) {
                try {
                    CIMProperty[] props = AlertIndicationInstrumentation.this.getProperties(device, log);
                    CIMInstance indication = new CIMInstance(obj, props);
                    BaseInstrumentation.mHandle.deliverEvent(indication, null);
                }
                catch (Throwable t) {
                    AlertIndicationInstrumentation.this.mLogger.log(Level.SEVERE, "Execption generating alert for " + device, t);
                }
            }
            AlertIndicationInstrumentation.this.mLogger.info("Indications submitted to server.");
        }
    }

    private class cacheUpdate
    implements CacheUpdateNotifier {
        private final ArrayList<String> warningSent = new ArrayList();
        private final ArrayList<String> severeSent = new ArrayList();

        @Override
        public <T extends Serializable> void cacheItemAdded(T pObj) {
        }

        @Override
        public <T extends Serializable> void cacheItemDeleted(T pObj) {
        }

        @Override
        public <T extends Serializable> void cacheItemModified(T pObj) {
            if (AlertIndicationInstrumentation.this.drm28Listening || AlertIndicationInstrumentation.this.drm29Listening || AlertIndicationInstrumentation.this.drm30Listening) {
                ThinPool oldTP = (ThinPool)pObj;
                try {
                    RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(oldTP.getSerialNumber());
                    ThinPool tp = ThinPool.find(mapping.getRMIObject(), oldTP.getPoolID(), ThinPool.ThinPoolType.AOU);
                    if (tp != null) {
                        ThinPool.UpperPoolStatus status = tp.getPoolStatusUpper();
                        this.sendDRM28Indication(tp, status);
                        this.sendDRM29Indication(tp, status);
                        this.sendDRM30Indication(tp, status);
                    } else {
                        AlertIndicationInstrumentation.this.mLogger.severe("AlertIndication indicates that ThinPool(" + oldTP.getPoolID() + ") was modified but it does not exist.");
                    }
                }
                catch (WBEMException we) {
                    AlertIndicationInstrumentation.this.mLogger.log(Level.SEVERE, "AlertIndication indicates that ThinPool(" + oldTP.getPoolID() + ") was modified but an exception occurred getting it from the cache");
                }
            }
        }

        private CIMProperty<?>[] getProperties(ThinPool tp, String msg, UnsignedInteger16 pSev) throws WBEMException {
            String systemName;
            RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
            String providerName = mapping.isHitachiSystem() ? "HITACHI SMI-S Provider" : "SVP CLI/SMI-S";
            CIMObjectPath opSS = AlertIndicationInstrumentation.this.getStorageSystemOP(mapping.getRMIObject());
            try {
                systemName = mapping.getStorageSystemName();
            }
            catch (Exception e) {
                systemName = "null";
                AlertIndicationInstrumentation.this.mLogger.log(Level.SEVERE, "Unable to get system name", e);
            }
            if (sevMap.isEmpty()) {
                AlertIndicationInstrumentation.this.getSeverityTable(RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber()));
            }
            return new CIMProperty[]{new CIMProperty("Description", CIMDataType.STRING_T, (Object)msg, false), new CIMProperty("AlertingManagedElement", CIMDataType.STRING_T, (Object)(opSS == null ? "null" : opSS.toString()), false), new CIMProperty("AlertingElementFormat", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("AlertType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("PerceivedSeverity", CIMDataType.UINT16_T, (Object)pSev, false), new CIMProperty("ProbableCause", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("EventID", CIMDataType.STRING_T, null, false), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", false), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, false), new CIMProperty("ProviderName", CIMDataType.STRING_T, (Object)providerName, false), new CIMProperty("EventTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false), new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false)};
        }

        private void sendAlert(ThinPool tp, String msg, UnsignedInteger16 pSev) {
            AlertIndicationInstrumentation.this.mLogger.info("Sending alert indication: " + msg);
            CIMObjectPath obj = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_AlertIndication", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            try {
                CIMProperty<?>[] props = this.getProperties(tp, msg, pSev);
                CIMInstance indication = new CIMInstance(obj, props);
                BaseInstrumentation.mHandle.deliverEvent(indication, null);
                AlertIndicationInstrumentation.this.mLogger.info("Indication submitted to server.");
            }
            catch (Throwable t) {
                AlertIndicationInstrumentation.this.mLogger.log(Level.SEVERE, "Execption generating alert for " + tp.getSerialNumber(), t);
            }
        }

        private void sendDRM28Indication(ThinPool tp, ThinPool.UpperPoolStatus status) {
            if (AlertIndicationInstrumentation.this.drm28Listening && status == ThinPool.UpperPoolStatus.EXCEEDED_VARIABLE_THRESHOLD) {
                String poolID = Short.toString(tp.getPoolID());
                String msg = String.format(drm28Msg, poolID);
                this.sendAlert(tp, msg, MINOR);
                if (!this.warningSent.contains(poolID)) {
                    this.warningSent.add(poolID);
                }
            }
        }

        private void sendDRM29Indication(ThinPool tp, ThinPool.UpperPoolStatus status) {
            if (AlertIndicationInstrumentation.this.drm29Listening && (status == ThinPool.UpperPoolStatus.EXCEEDED_FIXED_THRESHOLD || status == ThinPool.UpperPoolStatus.EXCEEDED_VARIABLE_THRESHOLD_DEPLETION)) {
                String poolID = Short.toString(tp.getPoolID());
                String msg = String.format(drm29Msg, poolID);
                this.sendAlert(tp, msg, MAJOR);
                if (!this.severeSent.contains(poolID)) {
                    this.warningSent.remove(poolID);
                    this.severeSent.add(poolID);
                }
            }
        }

        private void sendDRM30Indication(ThinPool tp, ThinPool.UpperPoolStatus status) {
            String poolID;
            if (AlertIndicationInstrumentation.this.drm30Listening && (this.warningSent.contains(poolID = Short.toString(tp.getPoolID())) || this.severeSent.contains(poolID)) && ThinPool.UpperPoolStatus.EXCEEDED_FIXED_THRESHOLD != status && ThinPool.UpperPoolStatus.EXCEEDED_VARIABLE_THRESHOLD != status && ThinPool.UpperPoolStatus.EXCEEDED_VARIABLE_THRESHOLD_DEPLETION != status) {
                String msg = String.format(drm30Msg, poolID);
                this.sendAlert(tp, msg, UNKNOWN);
                this.warningSent.remove(poolID);
                this.severeSent.remove(poolID);
            }
        }
    }
}

