/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class ArrayGroupBasedOnDiskExtentInstrumentation
extends BaseAssocInstrumentation {
    protected ArrayGroupBasedOnDiskExtentInstrumentation() {
        super("HITACHI_ArrayGroupBasedOnDiskExtent", "HITACHI_DiskExtent", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskExtentInstrumentation"), "HITACHI_ArrayGroup", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ArrayGroupInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ArrayGroupBasedOnDiskExtent".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    ChassisArrayGroup cag;
                    PDEVInfoEntry entry;
                    int[] deviceIDValues;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deDeviceID = objectName.getKey("DeviceID");
                    if (null != deDeviceID && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID((String)deDeviceID.getValue())) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && -1 != entry.getFb4() && -1 != entry.getPg() && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), entry.getFb4(), entry.getPg(), isObjectPath))) {
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, cag));
                        } else {
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, cag));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instArrayGroup;
                    block21: {
                        instArrayGroup = null;
                        try {
                            instArrayGroup = this.getReference2Instrumentation().getInstance(objectName, new String[0]);
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) break block21;
                            throw e;
                        }
                    }
                    if (null != instArrayGroup) {
                        String cpvDeviceID;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMObjectPath opArrayGroup = instArrayGroup.getObjectPath();
                        String string = cpvDeviceID = opArrayGroup.getKey("DeviceID") != null ? (String)opArrayGroup.getKey("DeviceID").getValue() : null;
                        if (null != cpvDeviceID) {
                            Integer[] fbpg = ProviderLibs.getFBPGFromDeviceID(cpvDeviceID);
                            int fb4 = fbpg[0];
                            int pg = fbpg[1];
                            if (-1 != fb4 && -1 != pg) {
                                PDEVInfoEntry pdev;
                                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                                while (null != (pdev = pdevs.poll())) {
                                    if (fb4 != pdev.getFb4() || pg != pdev.getPg()) continue;
                                    if (isObjectPath) {
                                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, pdev));
                                        continue;
                                    }
                                    iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, pdev));
                                }
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                PDEVInfoEntry pdev;
                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                callback = null;
                while (null != (pdev = pdevs.poll())) {
                    ChassisArrayGroup cag;
                    int fb4 = pdev.getFb4();
                    int pg = pdev.getPg();
                    if (-1 == fb4 || -1 == pg || null == (cag = ChassisArrayGroup.find(device.getRMIObject(), fb4, pg, true))) continue;
                    CIMObjectPath opDiskExtent = this.getReference1Instrumentation().generateObjectPath(op, pdev);
                    CIMObjectPath opArrayGroup = this.getReference2Instrumentation().generateObjectPath(op, cag);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opDiskExtent, opArrayGroup));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opDiskExtent, opArrayGroup));
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            if (iter != null && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        CIMProperty[] ret = new CIMProperty[]{new CIMProperty("StartingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("EndingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("OrderIndex", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false)};
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDiskExtent;
            String agPropName = this.getReference2PropertyName();
            CIMObjectPath opArrayGroup = op.getKey(agPropName) != null ? (CIMObjectPath)op.getKey(agPropName).getValue() : null;
            String dePropName = this.getReference1PropertyName();
            CIMObjectPath cIMObjectPath = opDiskExtent = op.getKey(dePropName) != null ? (CIMObjectPath)op.getKey(dePropName).getValue() : null;
            if (null != opArrayGroup && null != opDiskExtent) {
                String agSystemName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opArrayGroup, "SystemName");
                String deDeviceID = opDiskExtent.getKey("DeviceID") != null ? (String)opDiskExtent.getKey("DeviceID").getValue() : null;
                String deSystemName = opDiskExtent.getKey("SystemName") != null && opDiskExtent.getKey("SystemName").getValue() != null ? (String)opDiskExtent.getKey("SystemName").getValue() : null;
                String agDeviceID = null != opArrayGroup.getKey("DeviceID") ? (String)opArrayGroup.getKey("DeviceID").getValue() : null;
                String string = agSystemName = null != opArrayGroup.getKey("SystemName") ? (String)opArrayGroup.getKey("SystemName").getValue() : null;
                if (deDeviceID != null && null != agDeviceID && null != deSystemName && null != agSystemName && agSystemName.equals(deSystemName) && deSystemName.equals(device.getStorageSystemName())) {
                    PDEVInfoEntry entry;
                    int[] deviceIDValues;
                    Integer[] fbpg = ProviderLibs.getFBPGFromDeviceID(agDeviceID);
                    int fb4 = fbpg[0];
                    int pg = fbpg[1];
                    if (-1 != fb4 && -1 != pg && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(deDeviceID)) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && fb4 == entry.getFb4() && pg == entry.getPg()) {
                        return this.generateInstance(op, propertyList, opDiskExtent, opArrayGroup);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ArrayGroupBasedOnDiskExtent".equalsIgnoreCase(assocName.getObjectName())) {
                CIMInstance instArrayGroup;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    ChassisArrayGroup cag;
                    PDEVInfoEntry entry;
                    int[] deviceIDValues;
                    CIMInstance instDiskExtent = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deDeviceID = objectName.getKey("DeviceID");
                    if (null != deDeviceID && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID((String)deDeviceID.getValue())) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && -1 != entry.getFb4() && -1 != entry.getPg() && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), entry.getFb4(), entry.getPg(), isObjectPath))) {
                        CIMObjectPath opArrayGroup = this.getReference2Instrumentation().generateObjectPath(objectName, cag);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, instDiskExtent.getObjectPath(), opArrayGroup));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, instDiskExtent.getObjectPath(), opArrayGroup));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName) && null != (instArrayGroup = this.getReference2Instrumentation().getInstance(objectName, new String[0]))) {
                    String cpvDeviceID;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    String string = cpvDeviceID = objectName.getKey("DeviceID") != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                    if (null != cpvDeviceID) {
                        Integer[] fbpg = ProviderLibs.getFBPGFromDeviceID(cpvDeviceID);
                        int fb4 = fbpg[0];
                        int pg = fbpg[1];
                        if (-1 != fb4 && -1 != pg) {
                            PDEVInfoEntry pdev;
                            CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                            PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                            LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                            while (null != (pdev = pdevs.poll())) {
                                if (fb4 != pdev.getFb4() || pg != pdev.getPg()) continue;
                                CIMObjectPath opDiskExtent = this.getReference1Instrumentation().generateObjectPath(objectName, pdev);
                                if (isObjectPath) {
                                    iter.add(this.generateObjectPath(objectName, opDiskExtent, instArrayGroup.getObjectPath()));
                                    continue;
                                }
                                iter.add(this.generateInstance(objectName, propertyList, opDiskExtent, instArrayGroup.getObjectPath()));
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

