/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageHardwareIDs;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class AssociatedPrivilegeInstrumentation
extends BaseAssocInstrumentation {
    protected AssociatedPrivilegeInstrumentation() {
        super("HITACHI_AssociatedPrivilege", "HITACHI_StorageHardwareID", "Subject", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageHardwareIDInstrumentation"), "HITACHI_SCSIProtocolController", "Target", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_AssociatedPrivilege".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        this.getSCSIPCs(device, iter, assocName, objectName, propertyList, isObjectPath, true);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    this.getHardwareIDs(device, iter, assocName, objectName, propertyList, isObjectPath, true);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CloseableAddableIterator scsiPCs = new CloseableAddableIterator();
                ProviderLibs.enumerateCIMOMInstances(new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), null), (CloseableAddableIterator<CIMInstance>)scsiPCs, mHandle);
                while (scsiPCs.hasNext()) {
                    CIMInstance inst = (CIMInstance)scsiPCs.next();
                    this.getHardwareIDs(device, iter, op, inst.getObjectPath(), propertyList, isObjectPath, false);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath objectName, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath opAssoc = this.generateObjectPath(objectName, o);
        CIMProperty[] props = new CIMProperty[]{opAssoc.getKey(this.getReference1PropertyName()), opAssoc.getKey(this.getReference2PropertyName()), opAssoc.getKey("UseKey"), new CIMProperty("PrivilegeGranted", CIMDataType.BOOLEAN_T, (Object)true), new CIMProperty("Activities", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_FIVE, ProviderConstants.UINT16_SIX})};
        return new CIMInstance(opAssoc, props).filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath objectPath, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{CIMObjectPath.class, CIMObjectPath.class}, o, "HITACHI_AssociatedPrivilege");
        CIMObjectPath tmp = (CIMObjectPath)o[1];
        StringBuilder useKey = new StringBuilder((String)tmp.getKeyValue("DeviceID"));
        useKey.append(".");
        tmp = (CIMObjectPath)o[0];
        String hostID = ProviderLibs.getEndString((String)tmp.getKeyValue("InstanceID"));
        useKey.append(hostID);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(this.getReference1PropertyName(), new CIMDataType(this.getReference1ClassName()), (Object)((CIMObjectPath)o[0]), true), new CIMProperty(this.getReference2PropertyName(), new CIMDataType(this.getReference2ClassName()), (Object)((CIMObjectPath)o[1]), true), new CIMProperty("UseKey", CIMDataType.STRING_T, (Object)useKey.toString(), true)};
        return new CIMObjectPath(objectPath.getScheme(), objectPath.getHost(), objectPath.getPort(), objectPath.getNamespace(), "HITACHI_AssociatedPrivilege", keys, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
    }

    private void getHardwareIDs(RMIObjectMapping device, CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath scsiPC, String[] propertyList, boolean isObjectPath, boolean isAssocCall) throws WBEMException {
        String deviceID = (String)scsiPC.getKeyValue("DeviceID");
        String portID = ProviderLibs.getAllButEndString(deviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
        String hostGrpID = ProviderLibs.getEndString(deviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
        StorageHardwareIDs shIDs = StorageHardwareIDs.getStorageHardwareIDs();
        Set<String> hardIDs = shIDs.getAllStorageHardwareIDs(device, null, portID, hostGrpID, null, null, null, null);
        for (String hardID : hardIDs) {
            try {
                CIMObjectPath hwID = this.getReference1Instrumentation().generateObjectPath(scsiPC, device.getRMIObject(), hardID);
                if (isObjectPath) {
                    CIMObjectPath retOP = !isAssocCall ? this.generateObjectPath(assocName, hwID, scsiPC) : hwID;
                    if (retOP == null) continue;
                    iter.add(retOP);
                    continue;
                }
                CIMInstance ret = !isAssocCall ? this.generateInstance(assocName, propertyList, hwID, scsiPC) : this.getReference1Instrumentation().generateInstance(hwID, propertyList, device.getRMIObject(), hardID);
                if (ret == null) continue;
                iter.add(ret);
            }
            catch (Throwable e) {
                throw new WBEMException(1, e.toString(), null, e);
            }
        }
    }

    private void getSCSIPCs(RMIObjectMapping device, CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath hwID, String[] propertyList, boolean isObjectPath, boolean isAssocCall) throws WBEMException {
        String instID = (String)hwID.getKeyValue("InstanceID");
        String hostWWN = ProviderLibs.getEndString(instID);
        ClosableAddableIteratorCB<PortandHostGroupInfo> callback = new ClosableAddableIteratorCB<PortandHostGroupInfo>();
        PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, device.getStorageSystemName(), null, null, null, hostWWN, false, null, false);
        CloseableAddableIterator<PortandHostGroupInfo> phgiIter = callback.getWrappedCloseableAddableIter();
        while (phgiIter.hasNext()) {
            PortandHostGroupInfo phgi = (PortandHostGroupInfo)phgiIter.next();
            try {
                CIMObjectPath scsiPC = this.getReference2Instrumentation().generateObjectPath(hwID, phgi);
                if (isObjectPath) {
                    CIMObjectPath retOP = !isAssocCall ? this.generateObjectPath(assocName, hwID, scsiPC) : hwID;
                    if (retOP == null) continue;
                    iter.add(retOP);
                    continue;
                }
                CIMInstance ret = !isAssocCall ? this.generateInstance(assocName, propertyList, hwID, scsiPC) : this.getReference2Instrumentation().generateInstance(scsiPC, propertyList, phgi);
                if (ret == null) continue;
                iter.add(ret);
            }
            catch (Exception e) {
                throw new WBEMException(1, e.toString(), null, (Throwable)e);
            }
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_AssociatedPrivilege".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        this.getSCSIPCs(device, iter, assocName, objectName, propertyList, isObjectPath, false);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    this.getHardwareIDs(device, iter, assocName, objectName, propertyList, isObjectPath, false);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }
}

