/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class DiskFirmwareInstrumentation
extends BaseInstrumentation {
    static final String VER_STRING = "0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Integer iRDevNum;
            Integer iCDevNum;
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues);
            int expCDevNum = -1;
            int expRDevNum = -1;
            Integer n = iCDevNum = null != expectedValues ? (Integer)expectedValues.get("CDevNum") : null;
            if (null != iCDevNum) {
                expCDevNum = iCDevNum;
            }
            Integer n2 = iRDevNum = null != expectedValues ? (Integer)expectedValues.get("RDevNum") : null;
            if (null != iRDevNum) {
                expRDevNum = iRDevNum;
            }
            for (RMIObjectMapping device : devices) {
                PDEVInfoEntry pdev;
                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, expCDevNum, expRDevNum);
                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                callback = null;
                while (null != (pdev = pdevs.poll())) {
                    CIMObjectPath retOP;
                    if (null != refInfo) {
                        retOP = this.generateObjectPath(op, pdev);
                        refInfo.addReference(iter, retOP);
                        continue;
                    }
                    if (isObjectPath) {
                        retOP = this.generateObjectPath(op, pdev);
                        iter.add(retOP);
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, pdev));
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            if (iter != null && !iter.isDone() && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        PDEVInfoEntry infoEntry = (PDEVInfoEntry)o[0];
        String instanceID = RMIObjectMapping.getRMIObjectMapping(infoEntry.getSerialNumber()).getStorageSystemName() + "." + infoEntry.getDeviceID();
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] retProps = new CIMProperty[]{keys[0], new CIMProperty("VersionString", CIMDataType.STRING_T, (Object)VER_STRING, false), new CIMProperty("Manufacturer", CIMDataType.STRING_T, (Object)"HITACHI", false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)instanceID, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)instanceID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)instanceID, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)instanceID, false)};
        return new CIMInstance(retOP, retProps).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{PDEVInfoEntry.class}, o, "HITACHI_DiskFirmware");
        PDEVInfoEntry infoEntry = (PDEVInfoEntry)o[0];
        String instanceID = RMIObjectMapping.getRMIObjectMapping(infoEntry.getSerialNumber()).getStorageSystemName() + "." + infoEntry.getDeviceID();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instanceID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DiskFirmware", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            String serial;
            RMIObjectMapping device;
            String instID = (String)(null != op.getKey("InstanceID") ? op.getKey("InstanceID").getValue() : null);
            if (null != instID && null != (device = RMIObjectMapping.getRMIObjectMapping(serial = ProviderLibs.getSerialFromString(instID)))) {
                String[] retSysName = new String[1];
                int[] deviceIDVals = PDEVInfoEntry.parseTag(instID, retSysName);
                String ssName = device.getStorageSystemName();
                if (null != ssName && ssName.equals(retSysName[0]) && null != deviceIDVals) {
                    PDEVInfoEntry infoEntry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDVals[0], deviceIDVals[1]);
                    return this.generateInstance(op, propertyList, infoEntry);
                }
            }
            throw new WBEMException(6, op != null ? op.toString() : null);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

