/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public final class ElementConfigurationCapabilitiesSnapshotPoolInstrumentation
extends BaseAssocInstrumentation {
    protected ElementConfigurationCapabilitiesSnapshotPoolInstrumentation() {
        super("HITACHI_ElementConfigurationCapabilitiesSnapshotPool", "HITACHI_SnapshotPool", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SnapshotPoolInstrumentation"), "HITACHI_StorageConfigurationCapabilitiesOfSnapshotPool", "Capabilities", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageConfigurationCapabilitiesOfSnapshotPoolInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (int x = 0; x < devices.size(); ++x) {
                CustomCloseableIterator<CIMObjectPath> ant;
                if (isObjectPath) {
                    ant = new CustomCloseableIterator<CIMObjectPath>();
                    this.getReference1Instrumentation().enumerate(ant, new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference1ClassName(), null), null, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedValues, refInfo);
                    this.getObjPath(ant, continueOnError, op, iter);
                    continue;
                }
                ant = new CustomCloseableIterator();
                this.getReference1Instrumentation().enumerate(ant, new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference1ClassName(), null), null, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedValues, refInfo);
                this.getInstance(ant, continueOnError, op, propertyList, iter);
            }
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private void getInstance(CustomCloseableIterator<CIMInstance> ants, boolean continueOnError, CIMObjectPath op, String[] propertyList, CustomCloseableIterator<?> result) throws WBEMException {
        try {
            while (ants.hasNext()) {
                CIMInstance antInst = (CIMInstance)ants.next();
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(antInst.getObjectPath(), "InstanceID");
                String instID = (String)antInst.getPropertyValue("InstanceID");
                String poolID = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                ThinPool pool = ThinPool.find(device.getRMIObject(), Short.parseShort(poolID), ThinPool.ThinPoolType.QS);
                if (pool != null) {
                    CIMObjectPath opDep = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                    CIMInstance ret = this.generateInstance(op, propertyList, antInst.getObjectPath(), opDep);
                    if (ret == null) continue;
                    result.add(ret);
                    continue;
                }
                mLogger.info("Unable to find Snapshot Pool that matches " + instID);
            }
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void getObjPath(CustomCloseableIterator<CIMObjectPath> ants, boolean continueOnError, CIMObjectPath op, CustomCloseableIterator<?> result) throws Exception {
        while (ants.hasNext()) {
            CIMObjectPath antObj = (CIMObjectPath)ants.next();
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(antObj, "InstanceID");
            String instID = (String)antObj.getKey("InstanceID").getValue();
            String poolID = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            ThinPool pool = ThinPool.find(device.getRMIObject(), Short.parseShort(poolID), ThinPool.ThinPoolType.QS);
            if (pool != null) {
                CIMObjectPath depObj = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath retOP = this.generateObjectPath(op, antObj, depObj);
                if (retOP == null) continue;
                result.add(retOP);
                continue;
            }
            mLogger.info("Unable to find Snapshot Pool that matches " + instID);
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String sysName = null != objectName && null != objectName.getKey("InstanceID") ? (String)objectName.getKey("InstanceID").getValue() : null;
        hTable.put("SystemName", sysName);
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != objectName && null != objectName.getKey("InstanceID") ? (String)objectName.getKey("InstanceID").getValue() : null;
        hTable.put("SystemName", name);
        return hTable;
    }
}

