/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FCPortCallbackHandler;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class FCPortInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_FCPort", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_FCPort added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_FCPort", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_FCPort deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_FCPort", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                FCPort port = (FCPort)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
                FCPort newInst = FCPort.find(port.getPortWWN(), FCPort.PortTypeRequested.ALL, device.getRMIObject());
                if (newInst != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a fort that with WWN of: " + port.getPortWWN());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_FCPort modified indication instance", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        new ArrayList(devices.size());
        try {
            Short expPort = null;
            String expWWN = null;
            if (null != expectedValues) {
                String val = (String)expectedValues.get("PortID");
                if (null != val) {
                    if (1 != devices.size()) {
                        mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, device infoinvalid. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_FCPort", expectedValues, devices.size()});
                        if (null != iter) {
                            iter.done();
                        }
                        return;
                    }
                    try {
                        expPort = new Short((String)expectedValues.get("PortID"));
                    }
                    catch (NumberFormatException e) {
                        throw new WBEMException(1, "Invalid short value for FCPort port Property");
                    }
                } else {
                    val = (String)expectedValues.get("HostWWN");
                    if (null != val) {
                        expWWN = val;
                    } else {
                        mLogger.warning("ExpectedValues does not contain any recognizable values: " + expectedValues.toString());
                    }
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                FCPortCallbackHandler<FCPort> callback = new FCPortCallbackHandler<FCPort>(deviceIter, isObjectPath, refInfo, op, propertyList, FCPort.PortTypeRequested.OPEN, this);
                FCPort.getFCPorts(device.getRMIObject(), callback, isObjectPath, null == propertyList || propertyList.length > 0, expWWN, null, expPort);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath pOP, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(pOP, o);
        FCPort pInfo = (FCPort)o[0];
        CIMInstance ret = null;
        if (null != pInfo && null != pOP) {
            try {
                CIMProperty[] keys = retOP.getKeys();
                Byte portKind = pInfo.getPortkind();
                UnsignedInteger16[] fc4Types = portKind.intValue() == 7 || portKind.intValue() == 8 ? new UnsignedInteger16[]{new UnsignedInteger16(28)} : new UnsignedInteger16[]{ProviderConstants.UINT16_EIGHT};
                CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("PortType", CIMDataType.UINT16_T, (Object)pInfo.getPortType(), false), new CIMProperty("OtherPortType", CIMDataType.STRING_T, (Object)pInfo.getOtherPortType(), false), new CIMProperty("SupportedFC4Types", CIMDataType.UINT16_ARRAY_T, (Object)fc4Types, false), new CIMProperty("ActiveFC4Types", CIMDataType.UINT16_ARRAY_T, (Object)fc4Types, false), new CIMProperty("PortDiscriminator", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("Speed", CIMDataType.UINT64_T, (Object)pInfo.getByDKCChannelSpeedAsUInt64(), false), new CIMProperty("PortNumber", CIMDataType.UINT16_T, (Object)new UnsignedInteger16((int)pInfo.getPort()), false), new CIMProperty("LinkTechnology", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FOUR, false), new CIMProperty("PermanentAddress", CIMDataType.STRING_T, (Object)pInfo.getPortWWN(), false), new CIMProperty("NetworkAddresses", CIMDataType.STRING_ARRAY_T, (Object)new String[]{pInfo.getPortWWN()}, false), new CIMProperty("SupportedMaximumTransmissionUnit", CIMDataType.UINT64_T, (Object)new UnsignedInteger64("2112"), false), new CIMProperty("MaxSpeed", CIMDataType.UINT64_T, (Object)pInfo.getPortSpeed(), false), new CIMProperty("UsageRestriction", CIMDataType.UINT16_T, (Object)pInfo.getPortRestriction(), false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)pInfo.getStrPortDisplayName(), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)pInfo.getStrPortDisplayName(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)pInfo.getStrPortDisplayName(), false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)pInfo.getStrPortDisplayName(), false)};
                ret = new CIMInstance(retOP, props).filterProperties(propList);
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        return ret;
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{FCPort.class}, o, "HITACHI_FCPort");
        FCPort pInfo = (FCPort)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(pInfo.getSerialNumber());
        String systemName = device.getStorageSystemName() + "." + pInfo.getControlID();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_FCPort", true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)pInfo.getPortWWN(), true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_FCPort", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            FCPort fcPort;
            String sysNameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null != deviceIDKeyVal && null != sysNameKeyVal && null != ccName && ccName.equals("HITACHI_FCPort") && null != sccName && sccName.equals("HITACHI_StorageProcessorSystem") && (fcPort = FCPort.find(deviceIDKeyVal, FCPort.PortTypeRequested.OPEN, device.getRMIObject())) != null) {
                return this.generateInstance(op, propertyList, fcPort);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_FCPort".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_FCPort".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_FCPort AND SourceInstance.CIM_FCPort::NetworkAddresses <> PreviousInstance.CIM_FCPort::NetworkAddresses".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_FCPort AND SourceInstance.Speed <> PreviousInstance.Speed".equals(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
        }
    }
}

