/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class FreeSpaceInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"InstanceID", "SystemName"});
        try {
            String chassisArrayID;
            String expInstID = null != expectedValues ? (String)expectedValues.get("InstanceID") : null;
            int fb4 = -1;
            int ag = -1;
            if (expInstID != null) {
                Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                fb4 = rets[0];
                ag = rets[1];
            }
            String string = chassisArrayID = null != expectedValues ? (String)expectedValues.get("ChassisArrayID") : null;
            if (chassisArrayID != null) {
                Integer[] rets = ProviderLibs.getChassisArrayIDInts(chassisArrayID);
                fb4 = rets[0];
                ag = rets[1];
            }
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(iter, isObjectPath, refInfo, op, propertyList, ag);
                ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, isObjectPath, fb4);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath theObjPath = this.generateObjectPath(p, o);
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        Integer fsIndex = (Integer)o[1];
        CIMProperty<?>[] props = this.getProperties(theObjPath.getKeys(), cag, fsIndex);
        CIMInstance ci = new CIMInstance(theObjPath, props);
        return ci.filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ChassisArrayGroup.class, Integer.class}, o, "HITACHI_FreeSpace");
        CIMObjectPath ret = null;
        try {
            ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
            Integer fsIndex = (Integer)o[1];
            if (null != op && null != cag) {
                String keyValue = cag.getChassis() + "." + cag.getArrayGroup() + "." + fsIndex;
                CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_FreeSpace", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber()).getStorageSystemName(), true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)keyValue, true)};
                ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_FreeSpace", keys, op.getXmlSchemaName());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == deviceIDKeyVal || null == sysNameKeyVal || null == ccName || !ccName.equals("HITACHI_FreeSpace") || null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            Integer[] cagVals = ProviderLibs.getChassisAndArrayGroupFromDeviceID(deviceIDKeyVal);
            ChassisArrayGroup data = ChassisArrayGroup.find(device.getRMIObject(), null, cagVals[0], cagVals[1], false);
            if (data != null) {
                CIMInstance ci = this.generateInstance(op, propertyList, data, cagVals[2]);
                return ci;
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private CIMProperty<?>[] getProperties(CIMProperty<?>[] keys, ChassisArrayGroup cag, Integer fsIndex) throws Exception {
        String SPCAG = String.valueOf(cag.getChassis()) + "." + cag.getArrayGroup() + "." + fsIndex;
        ArrayList props = new ArrayList();
        ProviderLibs.addKeysToProperties(keys, props);
        props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)SPCAG, false));
        boolean raid1Plus = true;
        if (cag.getRaidLevel().compareTo("UNKNOWN") == 0 || cag.getRaidLevel().equalsIgnoreCase("RAID0")) {
            raid1Plus = false;
        }
        UnsignedInteger16 cvConsistsOf = cag.getConsistsOf(null);
        props.add(new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)cvConsistsOf, false));
        String rl = cag.getRaidLevel();
        props.add(new CIMProperty("ErrorMethodology", CIMDataType.STRING_T, (Object)rl, false));
        UnsignedInteger64 cvBlockSize = cag.getBlockSize();
        props.add(new CIMProperty("BlockSize", CIMDataType.UINT64_T, (Object)cvBlockSize, false));
        UnsignedInteger64 cvNumberOfBlocks = cag.getNumFreeBlocks(fsIndex);
        props.add(new CIMProperty("NumberOfBlocks", CIMDataType.UINT64_T, (Object)cvNumberOfBlocks, false));
        props.add(new CIMProperty("ConsumableBlocks", CIMDataType.UINT64_T, (Object)cvNumberOfBlocks, false));
        props.add(new CIMProperty("IsBasedOnUnderlyingRedundancy", CIMDataType.BOOLEAN_T, (Object)raid1Plus, false));
        props.add(new CIMProperty("SequentialAccess", CIMDataType.BOOLEAN_T, (Object)false, false));
        UnsignedInteger16[] cvExtentStatus = new UnsignedInteger16[]{ProviderConstants.UINT16_SIX};
        props.add(new CIMProperty("ExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)cvExtentStatus, false));
        props.add(new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)raid1Plus, false));
        int vDataRedundency = ProviderLibs.getDataRedudancy(cag.getRaidLevel());
        UnsignedInteger16 cvDataRedundancy = new UnsignedInteger16(vDataRedundency);
        props.add(new CIMProperty("DataRedundancy", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false));
        int val = ProviderLibs.getPackageRedudancy(cag.getRaidLevel());
        UnsignedInteger16 value = new UnsignedInteger16(val);
        props.add(new CIMProperty("PackageRedundancy", CIMDataType.UINT16_T, (Object)value, false));
        props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false));
        props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false));
        props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
        props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
        props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
        props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
        props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
        props.add(new CIMProperty("ExtentStripeLength", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ONE, false));
        props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)SPCAG, false));
        props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)SPCAG, false));
        props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)SPCAG, false));
        props.add(new CIMProperty("IsConcatenated", CIMDataType.BOOLEAN_T, (Object)false, false));
        props.add(new CIMProperty("ExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"SNIA:Remaining"}, false));
        CIMProperty[] ret = props.toArray(new CIMProperty[props.size()]);
        return ret;
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        private int mArrayGroup;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, int ag) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mArrayGroup = -1;
            this.mArrayGroup = ag;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E cag = item;
                    if (((ChassisArrayGroup)cag).getFsIndex() < 0) {
                        ret = true;
                    }
                    if (-1 != this.mArrayGroup && ((ChassisArrayGroup)cag).getArrayGroup() != this.mArrayGroup) {
                        ret = true;
                    }
                    List<UnsignedInteger64> freeSpaces = ((ChassisArrayGroup)cag).getContainedFreeSpaces();
                    for (int count = 0; count < freeSpaces.size(); ++count) {
                        CIMObjectPath retOP = FreeSpaceInstrumentation.this.generateObjectPath(this.mOP, cag, count);
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, retOP);
                            continue;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(retOP);
                            continue;
                        }
                        CIMInstance ci = FreeSpaceInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, cag, count);
                        this.mIter.add(ci);
                    }
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

