/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class HostedStoragePoolInstrumentation
extends BaseAssocInstrumentation {
    protected HostedStoragePoolInstrumentation() {
        super("HITACHI_HostedStoragePool", "HITACHI_StorageSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_StoragePool", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        boolean closeIter = true;
        try {
            if (null != assocName && "HITACHI_HostedStoragePool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                        expectedVals.put("SystemName", device.getStorageSystemName());
                        closeIter = false;
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedVals, null);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("GroupComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (closeIter && null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath spOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StoragePool", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(ssOP, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                expectedVals.put("SystemName", device.getStorageSystemName());
                this.getReference2Instrumentation().enumerate(deviceIter, spOP, new String[0], null, null, continueOnError, true, expectedVals, newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedStoragePool".equalsIgnoreCase(assocName.getObjectName())) {
                CIMObjectPath opRef = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageSystem") && (null == role || role.equalsIgnoreCase("GroupComponent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath spOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_StoragePool", null);
                    ReferenceInfo newRefInfo = new ReferenceInfo(opRef, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                    Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                    expectedVals.put("SystemName", device.getStorageSystemName());
                    this.getReference2Instrumentation().enumerate(iter, spOP, new String[0], null, null, continueOnError, true, expectedVals, newRefInfo);
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StoragePool") && (null == role || role.equalsIgnoreCase("PartComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, ssOP, opRef));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, ssOP, opRef));
                    }
                    if (null != iter) {
                        iter.done();
                    }
                } else if (null != iter) {
                    iter.done();
                }
            } else if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

