/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class HostedStoragePoolPrimordialInstrumentation
extends BaseAssocInstrumentation {
    private static final String CN_STORAGE_POOL_PRIMORDIAL = "HITACHI_StoragePoolPrimordial";

    protected HostedStoragePoolPrimordialInstrumentation() {
        super("HITACHI_HostedStoragePoolPrimordial", "HITACHI_StorageSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), CN_STORAGE_POOL_PRIMORDIAL, "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolPrimordialInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        boolean closeIter = true;
        try {
            if (null != assocName && "HITACHI_HostedStoragePoolPrimordial".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                        expectedVals.put("SystemName", device.getStorageSystemName());
                        closeIter = false;
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedVals, null);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("GroupComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                    if (null != iter) {
                        iter.done();
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (closeIter && null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath sppOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), CN_STORAGE_POOL_PRIMORDIAL, null);
                ReferenceInfo newRefInfo = new ReferenceInfo(ssOP, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                expectedVals.put("SystemName", device.getStorageSystemName());
                this.getReference2Instrumentation().enumerate(deviceIter, sppOP, new String[0], null, null, continueOnError, true, expectedVals, newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedStoragePoolPrimordial".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageSystem") && (null == role || role.equalsIgnoreCase("GroupComponent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath sppOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), CN_STORAGE_POOL_PRIMORDIAL, null);
                    ReferenceInfo newRefInfo = new ReferenceInfo(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()), null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                    Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                    expectedVals.put("SystemName", device.getStorageSystemName());
                    this.getReference2Instrumentation().enumerate(iter, sppOP, new String[0], null, null, continueOnError, true, expectedVals, newRefInfo);
                } else if (objectName.getObjectName().equalsIgnoreCase(CN_STORAGE_POOL_PRIMORDIAL) && (null == role || role.equalsIgnoreCase("PartComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, ssOP, newOP));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, ssOP, newOP));
                    }
                    if (null != iter) {
                        iter.done();
                    }
                } else if (null != iter) {
                    iter.done();
                }
            } else if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

