/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class ImportingSCSIProtocolControllerInstrumentation
extends BaseInstrumentation {
    private static final String IMPORTING_SCSI_PROTOCOL_CONTROLLER = "HITACHI_ImportingSCSIProtocolController".substring("HITACHI_".length());
    private static final int UNITS_CONTROLLED = 63232;

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter && !iter.isClosed()) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        try {
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("MaxUnitsControlled", CIMDataType.UINT32_T, (Object)new UnsignedInteger32(63232L), false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)"HITACHI_ImportingSCSIProtocolController", false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)ProviderConstants.getOpStatusDescriptions(new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}), false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"HITACHI_ImportingSCSIProtocolController", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"HITACHI_ImportingSCSIProtocolController", false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI_ImportingSCSIProtocolController", false)};
            return new CIMInstance(retOP, props).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_ImportingSCSIProtocolController");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        try {
            CIMObjectPath ret = null;
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_ImportingSCSIProtocolController", true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)IMPORTING_SCSI_PROTOCOL_CONTROLLER, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)rmiObj.getSMISMappingContainer().getStorageSystemName(), true)};
            ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ImportingSCSIProtocolController", keys, op.getXmlSchemaName());
            return ret;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String cpvSystemName;
            String cpvCCName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String cpvSCCNName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String cpvDeviceID = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = cpvSystemName = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null != cpvDeviceID && null != cpvSystemName && null != cpvCCName && null != cpvSCCNName && cpvCCName.equals("HITACHI_ImportingSCSIProtocolController") && cpvSCCNName.equals("HITACHI_StorageSystem") && cpvDeviceID.equals(IMPORTING_SCSI_PROTOCOL_CONTROLLER) && cpvSystemName.equals(device.getStorageSystemName())) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
    }
}

