/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class MaskingCapabilitiesInstrumentation
extends BaseInstrumentation {
    private static final String MASKING_CAP = "MaskingCapabilities";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues);
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        UnsignedInteger16[] cvValidHWTypes = new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_FIVE};
        CIMProperty[] retProps = new CIMProperty[]{keys[0], new CIMProperty("ValidHardwareIdTypes", CIMDataType.UINT16_ARRAY_T, (Object)cvValidHWTypes, false), new CIMProperty("PortsPerView", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("ClientSelectableDeviceNumbers", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("AttachDeviceSupported", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("OneHardwareIDPerView", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("UniqueUnitNumbersPerPort", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("PrivilegeDeniedSupported", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("ProtocolControllerRequiresAuthorizedIdentity", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("ProtocolControllerSupportsCollections", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("ExposePathsWithNameAndHostTypeSupported", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("ExposePathsSupported", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("CreateProtocolControllerSupported", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("MaximumMapCount", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(0), false), new CIMProperty("SPCAllowsNoLUs", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("SPCAllowsNoTargets", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("SPCAllowsNoInitiators", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("SPCSupportsDefaultViews", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)MASKING_CAP, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)MASKING_CAP, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)MASKING_CAP, false)};
        return new CIMInstance(retOP, retProps).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_MaskingCapabilities");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String systemName = rmiObj.getSMISMappingContainer().getStorageSystemName();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)systemName, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_MaskingCapabilities", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            String ssName = device.getStorageSystemName();
            if (null == instID || !instID.equals(ssName)) {
                throw new WBEMException(6, op != null ? op.toString() : null);
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        if ("GetElementNameCapabilities".equalsIgnoreCase(pMethodName)) {
            int elType = -1;
            boolean isFC = true;
            String goalClz = null;
            for (CIMArgument<?> arg : pInArgs) {
                if (arg.getName().equalsIgnoreCase("ElementType")) {
                    UnsignedInteger16 val = (UnsignedInteger16)arg.getValue();
                    elType = val.intValue();
                }
                if (!arg.getName().equalsIgnoreCase("Goal")) continue;
                CIMObjectPath obj = (CIMObjectPath)arg.getValue();
                goalClz = obj.getObjectName();
                if ("HITACHI_FCPort".equalsIgnoreCase(goalClz)) {
                    isFC = true;
                    continue;
                }
                if ("HITACHI_iSCSIProtocolEndpoint".equalsIgnoreCase(obj.getObjectName())) {
                    isFC = false;
                    continue;
                }
                mLogger.log(Level.SEVERE, "Invalid 'Goal' reference: {0}", arg);
                return ProviderConstants.UINT32_FIVE;
            }
            if (2 != elType && 3 != elType) {
                mLogger.log(Level.SEVERE, "{0} returning 5 because ElementType has an invalid value: {1}", new Object[]{"GetElementNameCapabilities", elType});
                return ProviderConstants.UINT16_FIVE;
            }
            if (isFC) {
                pOutArgs[0] = new CIMArgument("ElementNameMask", CIMDataType.STRING_T, (Object)"[0-9 a-z A-Z \\b ! # \\$ % & ' \\( \\) + \\- \\. = @ \\[ \\] \\^ _ ` \\{ \\} ~]*");
                if (2 == elType) {
                    pOutArgs[1] = new CIMArgument("SupportedFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO});
                    pOutArgs[2] = new CIMArgument("MaxElementNameLen", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(16));
                } else {
                    pOutArgs[1] = new CIMArgument("SupportedFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_FOUR});
                    pOutArgs[2] = new CIMArgument("MaxElementNameLen", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(64));
                }
            } else if (2 == elType) {
                pOutArgs[0] = new CIMArgument("ElementNameMask", CIMDataType.STRING_T, (Object)"[0-9 a-z A-Z : ,]*");
                pOutArgs[1] = new CIMArgument("SupportedFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO});
                pOutArgs[2] = new CIMArgument("MaxElementNameLen", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(223));
            } else {
                pOutArgs[0] = new CIMArgument("ElementNameMask", CIMDataType.STRING_T, (Object)"[0-9 a-z A-Z \\b ! # \\$ % & ' \\( \\) + \\- \\. = @ \\[ \\] \\^ _ \\{ \\} ~ :]*");
                pOutArgs[1] = new CIMArgument("SupportedFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_FOUR});
                pOutArgs[2] = new CIMArgument("MaxElementNameLen", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(32));
            }
            return ProviderConstants.UINT16_ZED;
        }
        throw new WBEMException(17, "HITACHI_MaskingCapabilities doesn't know the method: " + pMethodName);
    }
}

