/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class MemberOfStatisticsCollectionArrayGroupInstrumentation
extends BaseAssocInstrumentation {
    protected MemberOfStatisticsCollectionArrayGroupInstrumentation() {
        super("HITACHI_MemberOfStatisticsCollectionArrayGroup", "HITACHI_StatisticsCollection", "Collection", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StatisticsCollectionInstrumentation"), "HITACHI_BlockStatisticalDataArrayGroup", "Member", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.BlockStatisticalDataArrayGroupInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_MemberOfStatisticsCollectionArrayGroup".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Collection")) && (null == resultRole || resultRole.equalsIgnoreCase("Member"))) {
                    Hashtable<String, Object> expectedValues = this.getReference1SearchProperties(objectName);
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedValues, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Member")) && (null == resultRole || resultRole.equalsIgnoreCase("Collection")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            CIMObjectPath opBlockStats = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_BlockStatisticalDataArrayGroup", null);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStatsCol = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                ReferenceInfo newRefInfo = new ReferenceInfo(opStatsCol, null, "Collection", "Member", propertyList, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(deviceIter, opBlockStats, null, null, null, continueOnError, true, this.getReference2SearchProperties(opStatsCol), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opStatCollection) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != opStatCollection && null != opStatCollection.getKey("InstanceID") ? (String)opStatCollection.getKey("InstanceID").getValue() : null;
        hTable.put("SystemName", name);
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opBlockStat) {
        Hashtable<String, Object> expectedValues = new Hashtable<String, Object>();
        try {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opBlockStat, "InstanceID");
            expectedValues.put("SystemName", device.getStorageSystemName());
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Unable to find a managed device using {0}", opBlockStat);
        }
        return expectedValues;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_MemberOfStatisticsCollectionArrayGroup".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StatisticsCollection") && (null == role || role.equalsIgnoreCase("Collection")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_BlockStatisticalDataArrayGroup", null);
                    CIMObjectPath opRedundancySet = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opRedundancySet, null, "Collection", "Member", propertyList, isObjectPath, this);
                    Hashtable<String, Object> expectedValues = this.getReference1SearchProperties(objectName);
                    this.getReference2Instrumentation().enumerate(iter, opStorageProcessorSystem, null, null, null, continueOnError, true, expectedValues, newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_BlockStatisticalDataArrayGroup") && (null == role || role.equalsIgnoreCase("Member")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath opRedundancySet = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opRedundancySet, opStorageProcessorSystem));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opRedundancySet, opStorageProcessorSystem));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

