/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class PhysicalDiskInstrumentation
extends BaseInstrumentation {
    private static final String CPV_MANUFACTURER = "HITACHI";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Tag", expectedValues, new String[]{"SystemName", "Tag"});
            int expCDevNum = -1;
            int expRDevNum = -1;
            String expChassisLoc = null;
            if (null != expectedValues) {
                Integer iRDevNum;
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices, expected 1: " + op);
                }
                Integer iCDevNum = (Integer)expectedValues.get("CDevNum");
                if (null != iCDevNum) {
                    expCDevNum = iCDevNum;
                }
                if (null != (iRDevNum = (Integer)expectedValues.get("RDevNum"))) {
                    expRDevNum = iRDevNum;
                }
                expChassisLoc = (String)expectedValues.get("ChassisLocation");
            }
            for (RMIObjectMapping device : devices) {
                PDEVInfoEntry pdev;
                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, expCDevNum, expRDevNum, expChassisLoc, -1, -1);
                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                callback = null;
                while (null != (pdev = pdevs.poll())) {
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, pdev));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, pdev));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, pdev));
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            if (iter != null && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        PDEVInfoEntry entry = (PDEVInfoEntry)o[0];
        String cdev = String.valueOf(entry.getCdev());
        String rdev = String.valueOf(entry.getRdev());
        String deviceID = entry.getDeviceID();
        String model = entry.getHddKind();
        Object partNum = null;
        String serialNum = entry.getHddSerial();
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], new CIMProperty("CDevNumber", CIMDataType.STRING_T, (Object)cdev, false), new CIMProperty("RDevNumber", CIMDataType.STRING_T, (Object)rdev, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("Manufacturer", CIMDataType.STRING_T, (Object)CPV_MANUFACTURER, false), new CIMProperty("Model", CIMDataType.STRING_T, (Object)model, false), new CIMProperty("SerialNumber", CIMDataType.STRING_T, (Object)serialNum, false), new CIMProperty("PartNumber", CIMDataType.STRING_T, partNum, false), new CIMProperty("VendorEquipmentType", CIMDataType.STRING_T, (Object)model, false), new CIMProperty("PoweredOn", CIMDataType.BOOLEAN_T, (Object)new Boolean(true), false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)deviceID, false)};
        return new CIMInstance(retOP, retProps).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{PDEVInfoEntry.class}, o, "HITACHI_PhysicalDisk");
        PDEVInfoEntry entry = (PDEVInfoEntry)o[0];
        String tag = RMIObjectMapping.getRMIObjectMapping(entry.getSerialNumber()).getStorageSystemName() + "." + entry.getDeviceID();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_PhysicalDisk", true), new CIMProperty("Tag", CIMDataType.STRING_T, (Object)tag, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_PhysicalDisk", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Tag");
        try {
            String cvCCN;
            CIMProperty cpCCN = op.getKey("CreationClassName");
            String string = cvCCN = cpCCN != null ? (String)cpCCN.getValue() : null;
            if ("HITACHI_PhysicalDisk".equals(cvCCN)) {
                String cpvTag;
                CIMProperty cpTag = op.getKey("Tag");
                String string2 = cpvTag = cpTag != null ? (String)cpTag.getValue() : null;
                if (null != cpvTag) {
                    String[] sysName = new String[1];
                    int[] deviceIDValues = PDEVInfoEntry.parseTag(cpvTag, sysName);
                    String ssName = device.getStorageSystemName();
                    if (null != ssName && ssName.equals(sysName[0]) && null != deviceIDValues) {
                        PDEVInfoEntry infoEntry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1]);
                        return this.generateInstance(op, propertyList, infoEntry);
                    }
                }
            }
            throw new WBEMException(6, op != null ? op.toString() : null);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

