/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class ProductPhysicalComponentDKCInstrumentation
extends BaseAssocInstrumentation {
    protected ProductPhysicalComponentDKCInstrumentation() {
        super("HITACHI_ProductPhysicalComponentDKC", "HITACHI_StorageProduct", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProductInstrumentation"), "HITACHI_DKCChassis", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DKCChassisInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ProductPhysicalComponentDKC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        Hashtable<String, Object> expValues = new Hashtable<String, Object>();
                        String systemName = (String)objectName.getKeyValue("Name") + "." + (String)objectName.getKeyValue("IdentifyingNumber");
                        expValues.put("SystemName", systemName);
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expValues, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("GroupComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getModel(), device.getSerialNumber(), device.getVendor()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getModel(), device.getSerialNumber(), device.getVendor()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                Hashtable<String, Object> expValue = new Hashtable<String, Object>();
                String sysName = device.getStorageSystemName();
                expValue.put("SystemName", sysName);
                CIMObjectPath opStorageProduct = this.getReference1Instrumentation().generateObjectPath(op, device.getModel(), device.getSerialNumber(), device.getVendor());
                CIMObjectPath opDKC = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DKCChassis", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(opStorageProduct, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                PassthruIterator deviceIter = new PassthruIterator(iter);
                this.getReference2Instrumentation().enumerate(deviceIter, opDKC, new String[0], null, null, continueOnError, true, expValue, newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ProductPhysicalComponentDKC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageProduct") && (null == role || role.equalsIgnoreCase("GroupComponent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath opDKC = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_DKCChassis", null);
                    CIMObjectPath opObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_StorageProduct", objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opObjectName, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                    Hashtable<String, Object> expValues = new Hashtable<String, Object>();
                    String systemName = (String)objectName.getKeyValue("Name") + "." + (String)objectName.getKeyValue("IdentifyingNumber");
                    expValues.put("SystemName", systemName);
                    this.getReference2Instrumentation().enumerate(iter, opDKC, new String[0], null, null, continueOnError, true, expValues, newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_DKCChassis") && (null == role || role.equalsIgnoreCase("PartComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    CIMObjectPath opStorageProduct = this.getReference1Instrumentation().generateObjectPath(objectName, device.getModel(), device.getSerialNumber(), device.getVendor());
                    CIMObjectPath opDKCChassis = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_DKCChassis", objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opStorageProduct, opDKCChassis));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opStorageProduct, opDKCChassis));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

