/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class SCSIArbitraryLogicalUnitInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    private static final UnsignedInteger16 deviceType = ProviderConstants.UINT16_THREE;
    private static final UnsignedInteger16 enabledDefault = ProviderConstants.UINT16_TWO;
    private static final UnsignedInteger16 enabledState = ProviderConstants.UINT16_FIVE;
    private static final UnsignedInteger16 healthState = ProviderConstants.UINT16_FIVE;
    private static final UnsignedInteger16[] opStatus = new UnsignedInteger16[]{ProviderConstants.UINT16_TWO};
    private static final UnsignedInteger16 requestedState = ProviderConstants.UINT16_TWELVE;
    private static final String[] statusDescs = new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)};

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                DeviceNumber dn = (DeviceNumber)pObj;
                if (dn.isBLUPathCmdDev()) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIArbitraryLogicalUnit", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance sourceInstance = this.generateInstance(op, null, dn);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIArbitraryLogicalUnit added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                DeviceNumber dn = (DeviceNumber)pObj;
                if (dn.isBLUPathCmdDev()) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIArbitraryLogicalUnit", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance sourceInstance = this.generateInstance(op, null, dn);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIArbitraryLogicalUnit deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIArbitraryLogicalUnit", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                DeviceNumber dn = (DeviceNumber)pObj;
                DeviceNumber newDN = DeviceNumber.find(dn.getDNAsString(), RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getRMIObject());
                if (newDN != null) {
                    if (dn.isBLUPathCmdDev() || newDN.isBLUPathCmdDev()) {
                        CIMInstance prevInstance = this.generateInstance(op, null, dn);
                        CIMInstance sourceInstance = this.generateInstance(op, null, newDN);
                        IndicationHelper helper = new IndicationHelper(mHandle);
                        CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                        mHandle.deliverEvent(indication, null);
                    }
                } else {
                    mLogger.severe("Unable to find a volume that with Device ID: " + dn.getDNAsString());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIArbitraryLogicalUnit modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            String expSysName = null != expectedValues ? (String)expectedValues.get("SystemName") : null;
            String deviceIDKeyVal = null != expectedValues ? (String)expectedValues.get("DeviceID") : null;
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                String systemName = device.getStorageSystemName();
                if (null != expSysName && !expSysName.startsWith(systemName)) continue;
                CallbackHandler<DeviceNumber> callback = new CallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList);
                DeviceNumber.getDNs(device.getRMIObject(), callback, false, null == propertyList || propertyList.length > 0, deviceIDKeyVal);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        DeviceNumber dn = (DeviceNumber)o[0];
        String deviceID = dn.getDNAsString();
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("Name", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("DeviceType", CIMDataType.UINT16_T, (Object)deviceType, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)enabledState, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)requestedState, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)enabledDefault, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)opStatus, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)statusDescs, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)healthState, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)deviceID, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_SCSIArbitraryLogicalUnit");
        DeviceNumber dn = (DeviceNumber)o[0];
        String deviceID = dn.getDNAsString();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_SCSIArbitraryLogicalUnit", true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getStorageSystemName(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_SCSIArbitraryLogicalUnit", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            String sysNameKeyVal;
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (!(null != deviceIDKeyVal && null != sysNameKeyVal && sysNameKeyVal.equals(device.getStorageSystemName()) && null != ccName && ccName.equals("HITACHI_SCSIArbitraryLogicalUnit") && null != sccName && sccName.equals("HITACHI_StorageSystem"))) {
                throw new WBEMException(6, op.toString());
            }
            DeviceNumber dn = DeviceNumber.find(deviceIDKeyVal, device.getRMIObject());
            if (dn != null && dn.isBLUPathCmdDev()) {
                return this.generateInstance(op, propertyList, dn);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_SCSIArbitraryLogicalUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_SCSIArbitraryLogicalUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_SCSIArbitraryLogicalUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LDEV, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.LDEV, this, null);
        }
    }

    private class CallbackHandler<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block6: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E dn = item;
                        if (!((DeviceNumber)dn).isBLUPathCmdDev() || !((DeviceNumber)dn).hasPaths()) break block6;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, SCSIArbitraryLogicalUnitInstrumentation.this.generateObjectPath(this.mOP, dn));
                            break block6;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(SCSIArbitraryLogicalUnitInstrumentation.this.generateObjectPath(this.mOP, dn));
                            break block6;
                        }
                        this.mIter.add(SCSIArbitraryLogicalUnitInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, dn));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

