/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class SCSIPCForFCPortInstrumentation
extends BaseAssocInstrumentation {
    protected SCSIPCForFCPortInstrumentation() {
        super("HITACHI_SCSIPCForFCPort", "HITACHI_SCSIProtocolController", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"), "HITACHI_FCPort", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.FCPortInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            String cnSCSIPC = this.getReference1ClassName();
            String cnFCPort = this.getReference2ClassName();
            String pnSCSIPC = this.getReference1PropertyName();
            String pnFCPort = this.getReference2PropertyName();
            if (null != assocName && "HITACHI_SCSIPCForFCPort".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(cnSCSIPC) && (null == role || role.equalsIgnoreCase(pnSCSIPC)) && (null == resultRole || resultRole.equalsIgnoreCase(pnFCPort))) {
                    String portID;
                    CIMProperty propDeviceID;
                    if (shouldTestInst && this.getReference1Instrumentation().instanceExists(objectName) && null != (propDeviceID = objectName.getKey("DeviceID")) && (portID = ProviderLibs.getAllButEndString((String)propDeviceID.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR)).length() > 0) {
                        Hashtable<String, Object> FCPortSearchProps = this.getReference2SearchProperties(objectName);
                        FCPortSearchProps.put("PortID", portID);
                        CIMObjectPath opFCPort = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), cnFCPort, objectName.getKeys(), objectName.getXmlSchemaName());
                        this.getReference2Instrumentation().enumerate(iter, opFCPort, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, FCPortSearchProps, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(cnFCPort) && (null == role || role.equalsIgnoreCase(pnFCPort)) && (null == resultRole || resultRole.equalsIgnoreCase(pnSCSIPC)) && shouldTestInst) {
                    UnsignedInteger16 portID;
                    CIMInstance instFCPort = null;
                    try {
                        instFCPort = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instFCPort && null != (portID = (UnsignedInteger16)instFCPort.getPropertyValue("PortNumber"))) {
                        Hashtable<String, Object> SCSIPCSearchProps = this.getReference1SearchProperties(objectName);
                        SCSIPCSearchProps.put("PortID", String.valueOf(portID.intValue()));
                        CIMObjectPath opSCSIPC = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), cnSCSIPC, objectName.getKeys(), objectName.getXmlSchemaName());
                        this.getReference1Instrumentation().enumerate(iter, opSCSIPC, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, SCSIPCSearchProps, null);
                        needToCloseIter = false;
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            CustomCloseableIterator iterFCPorts = new CustomCloseableIterator();
            CIMObjectPath opFCPort = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), objectName.getKeys(), objectName.getXmlSchemaName());
            this.getReference2Instrumentation().enumerate(iterFCPorts, opFCPort, null, filterQueryLanguage, filterQuery, continueOnError, false, null, null);
            CIMObjectPath opSCSIPC = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference1ClassName(), objectName.getKeys(), objectName.getXmlSchemaName());
            while (iterFCPorts.hasNext()) {
                CIMInstance instFCPort = (CIMInstance)iterFCPorts.next();
                UnsignedInteger16 portID = (UnsignedInteger16)instFCPort.getPropertyValue("PortNumber");
                if (null == portID) continue;
                Hashtable<String, Object> expValues = this.getReference1SearchProperties(instFCPort.getObjectPath());
                expValues.put("PortID", String.valueOf(portID.intValue()));
                CustomCloseableIterator iterSCSIPC = new CustomCloseableIterator();
                this.getReference1Instrumentation().enumerate(iterSCSIPC, opSCSIPC, new String[0], null, null, continueOnError, true, expValues, null);
                while (iterSCSIPC.hasNext()) {
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, iterSCSIPC.next(), instFCPort.getObjectPath()));
                        continue;
                    }
                    CIMInstance instAssoc = this.generateInstance(objectName, propertyList, iterSCSIPC.next(), instFCPort.getObjectPath());
                    if (null == instAssoc) continue;
                    iter.add(instAssoc.filterProperties(propertyList));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        return new CIMProperty[]{new CIMProperty("AccessPriority", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false)};
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != objectName && null != objectName.getKey("SystemName") ? (String)objectName.getKey("SystemName").getValue() : null;
        hTable.put("ElementName", name);
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String sysName = null != objectName && null != objectName.getKey("SystemName") ? (String)objectName.getKey("SystemName").getValue() : null;
        hTable.put("SystemName", sysName);
        return hTable;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            String cnSCSIPC = this.getReference1ClassName();
            String cnFCPort = this.getReference2ClassName();
            String pnSCSIPC = this.getReference1PropertyName();
            String pnFCPort = this.getReference2PropertyName();
            if (null != assocName && "HITACHI_SCSIPCForFCPort".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(cnSCSIPC) && (null == role || role.equalsIgnoreCase(pnSCSIPC))) {
                    String portID;
                    CIMProperty propDeviceID;
                    if (this.getReference1Instrumentation().instanceExists(objectName) && null != (propDeviceID = objectName.getKey("DeviceID")) && (portID = ProviderLibs.getAllButEndString((String)propDeviceID.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR)).length() > 0) {
                        Hashtable<String, Object> FCPortSearchProps = this.getReference2SearchProperties(objectName);
                        FCPortSearchProps.put("PortID", portID);
                        CIMObjectPath opSCSIPC = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                        CIMObjectPath opFCPort = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), cnFCPort, null, objectName.getXmlSchemaName());
                        ReferenceInfo refInfo = new ReferenceInfo(opSCSIPC, null, pnSCSIPC, pnFCPort, propertyList, isObjectPath, this);
                        this.getReference2Instrumentation().enumerate(iter, opFCPort, new String[0], null, null, continueOnError, true, FCPortSearchProps, refInfo);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(cnFCPort) && (null == role || role.equalsIgnoreCase(pnFCPort))) {
                    UnsignedInteger16 portID;
                    CIMInstance instFCPort = null;
                    try {
                        instFCPort = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instFCPort && null != (portID = (UnsignedInteger16)instFCPort.getPropertyValue("PortNumber"))) {
                        Hashtable<String, Object> SCSIPCSearchProps = this.getReference1SearchProperties(objectName);
                        SCSIPCSearchProps.put("PortID", String.valueOf(portID.intValue()));
                        CIMObjectPath opSCSIPC = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), cnSCSIPC, null, objectName.getXmlSchemaName());
                        CIMObjectPath opFCPort = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                        ReferenceInfo refInfo = new ReferenceInfo(null, opFCPort, pnSCSIPC, pnFCPort, propertyList, isObjectPath, this);
                        this.getReference1Instrumentation().enumerate(iter, opSCSIPC, new String[0], null, null, continueOnError, true, SCSIPCSearchProps, refInfo);
                        needToCloseIter = false;
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }
}

