/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class SCSIPCForStorageVolumeInstrumentation
extends BaseAssocInstrumentation
implements CacheUpdateNotifier {
    public static final UnsignedInteger16 DEVICEACCESS = ProviderConstants.UINT16_TWO;

    protected SCSIPCForStorageVolumeInstrumentation() {
        super("HITACHI_SCSIPCForStorageVolume", "HITACHI_SCSIProtocolController", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"), "HITACHI_StorageVolume", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            String cnSCSIPC = this.getReference1ClassName();
            String cnStorageVolume = this.getReference2ClassName();
            String pnSCSIPC = this.getReference1PropertyName();
            String pnStorageVolume = this.getReference2PropertyName();
            if (null != assocName && "HITACHI_SCSIPCForStorageVolume".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(cnSCSIPC) && (null == role || role.equalsIgnoreCase(pnSCSIPC)) && (null == resultRole || resultRole.equalsIgnoreCase(pnStorageVolume))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        short sPortID = -1;
                        short sHostGroupID = -1;
                        CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                        if (null != cpDeviceID) {
                            String cvDeviceID = (String)cpDeviceID.getValue();
                            String portID = ProviderLibs.getAllButEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                            String hostGroup = ProviderLibs.getEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                            try {
                                sPortID = Short.parseShort(portID);
                                sHostGroupID = Short.parseShort(hostGroup);
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        if (-1 != sPortID && -1 != sHostGroupID) {
                            CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                            LUPathObject.getLUPaths(device.getRMIObject(), callback, sPortID);
                            LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                            callback = null;
                            LUPathObject luPath = luPaths.poll();
                            while (luPath != null) {
                                if (sHostGroupID == luPath.getSHostGrp()) {
                                    short ldkc = luPath.getDKC();
                                    short cu = luPath.getCU();
                                    short ldev = luPath.getLDEV();
                                    long bdn = BaseDeviceNumber.makeUniqueDN(ldkc, cu, ldev);
                                    DeviceNumber dn = DeviceNumber.find(Long.toString(bdn), device.getRMIObject());
                                    if (isObjectPath) {
                                        CIMObjectPath op = this.getReference2Instrumentation().generateObjectPath(objectName, dn);
                                        iter.add(op);
                                    } else {
                                        CIMInstance inst = this.getReference2Instrumentation().generateInstance(objectName, propertyList, dn);
                                        iter.add(inst);
                                    }
                                }
                                luPath = luPaths.poll();
                            }
                        }
                    }
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(cnStorageVolume) || null != role && !role.equalsIgnoreCase(pnStorageVolume) || null != resultRole && !resultRole.equalsIgnoreCase(pnSCSIPC) || shouldTestInst && !this.getReference2Instrumentation().instanceExists(objectName))) {
                    short[] deviceIDValues;
                    String deviceID;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID && null != (deviceID = (String)cpDeviceID.getValue()) && -1 != (deviceIDValues = BaseDeviceNumber.getDevIdStringValues(deviceID))[0] && -1 != deviceIDValues[1] && -1 != deviceIDValues[2]) {
                        CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                        LUPathObject.getLUPaths(device.getRMIObject(), callback, deviceIDValues[0], deviceIDValues[1], deviceIDValues[2]);
                        LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                        LUPathObject luPath = luPaths.poll();
                        while (luPath != null) {
                            short portID = luPath.getSPort();
                            short domainID = luPath.getSHostGrp();
                            short ctrID = PortandHostGroupInfo.getCtrIDUsingPortID(portID, device.getSerialNumber());
                            String spcDeviceID = portID + "." + domainID;
                            String spcSystemName = device.getStorageSystemName() + "." + ctrID;
                            Hashtable<String, Object> expectedValues = new Hashtable<String, Object>();
                            expectedValues.put("DeviceID", spcDeviceID);
                            expectedValues.put("ElementName", spcSystemName);
                            CustomCloseableIterator iterSCSIPC = isObjectPath ? new CustomCloseableIterator() : new CustomCloseableIterator();
                            this.getReference1Instrumentation().enumerate(iterSCSIPC, objectName, propertyList, null, null, continueOnError, isObjectPath, expectedValues, null);
                            while (iterSCSIPC.hasNext()) {
                                if (isObjectPath) {
                                    iter.add((CIMObjectPath)iterSCSIPC.next());
                                    continue;
                                }
                                iter.add((CIMInstance)iterSCSIPC.next());
                            }
                            luPath = luPaths.poll();
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                LUPathObject luPath = (LUPathObject)pObj;
                DeviceNumber dn = luPath.getDeviceNumber();
                if (null != dn) {
                    CIMObjectPath opNamespace = new CIMObjectPath(null, null, null, ProviderLibs.getImplementationNamespace(), "", null);
                    short ctrID = PortandHostGroupInfo.getCtrIDUsingPortID(luPath.getSPort(), luPath.getSerialNumber());
                    PortandHostGroupInfo pghi = ProviderLibs.checkForPortNHostGrp(ctrID, luPath);
                    CIMObjectPath opSCSIPC = this.getReference1Instrumentation().generateObjectPath(opNamespace, pghi);
                    CIMObjectPath opSCSIArbitraryLU = this.getReference2Instrumentation().generateObjectPath(opNamespace, dn);
                    CIMInstance sourceInstance = this.generateInstance(opNamespace, opSCSIPC, opSCSIArbitraryLU, luPath.getLunString());
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIPCForStorageVolume added indication: " + pObj, t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                LUPathObject luPath = (LUPathObject)pObj;
                DeviceNumber dn = luPath.getDeviceNumber();
                if (null != dn) {
                    CIMObjectPath opNamespace = new CIMObjectPath(null, null, null, ProviderLibs.getImplementationNamespace(), "", null);
                    short ctrID = PortandHostGroupInfo.getCtrIDUsingPortID(luPath.getSPort(), luPath.getSerialNumber());
                    PortandHostGroupInfo pghi = ProviderLibs.checkForPortNHostGrp(ctrID, luPath);
                    CIMObjectPath opSCSIPC = this.getReference1Instrumentation().generateObjectPath(opNamespace, pghi);
                    CIMObjectPath opSCSIArbitraryLU = this.getReference2Instrumentation().generateObjectPath(opNamespace, dn);
                    CIMInstance sourceInstance = this.generateInstance(opNamespace, opSCSIPC, opSCSIArbitraryLU, luPath.getLunString());
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIPCForStorageVolume deleted indication: " + pObj, t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                String systemName = device.getStorageSystemName();
                CallbackHandler<PortandHostGroupInfo> callback = new CallbackHandler<PortandHostGroupInfo>(deviceIter, isObjectPath, refInfo, op, propertyList);
                PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, systemName, false, continueOnError);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    public CIMInstance generateInstance(CIMObjectPath opObjectName, CIMObjectPath opSCSIPC, CIMObjectPath opStorageVolume, String lunDN) throws Exception {
        CIMObjectPath opAssoc = this.generateObjectPath(opObjectName, opSCSIPC, opStorageVolume);
        CIMProperty cpOpSCSIPC = opAssoc.getKey(this.getReference1PropertyName());
        CIMProperty cpOpStorageVolume = opAssoc.getKey(this.getReference2PropertyName());
        CIMProperty[] props = new CIMProperty[]{cpOpSCSIPC, cpOpStorageVolume, new CIMProperty("DeviceAccess", CIMDataType.UINT16_T, (Object)DEVICEACCESS, false), new CIMProperty("DeviceNumber", CIMDataType.STRING_T, (Object)lunDN, false)};
        return new CIMInstance(opAssoc, props);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block10: {
            try {
                String cvStorageVolumeDeviceID;
                CIMObjectPath opStorageVolume;
                String pnSCSIPC = this.getReference1PropertyName();
                CIMObjectPath opSCSIPC = opObjectName.getKey(pnSCSIPC) != null ? (CIMObjectPath)opObjectName.getKey(pnSCSIPC).getValue() : null;
                String pnStorageVolume = this.getReference2PropertyName();
                CIMObjectPath cIMObjectPath = opStorageVolume = opObjectName.getKey(pnStorageVolume) != null ? (CIMObjectPath)opObjectName.getKey(pnStorageVolume).getValue() : null;
                if (null == opSCSIPC || null == opStorageVolume) break block10;
                short sPort = -1;
                short sHostGroup = -1;
                CIMInstance instSCSIPC = this.getReference1Instrumentation().getInstance(opSCSIPC, null);
                CIMInstance instStorageVolume = this.getReference2Instrumentation().getInstance(opStorageVolume, null);
                CIMProperty cpSCSIPCDeviceID = opSCSIPC.getKey("DeviceID");
                CIMProperty cpSCSIPCSystemName = opSCSIPC.getKey("SystemName");
                CIMProperty cpStorageVolumeDeviceID = opStorageVolume.getKey("DeviceID");
                String string = cvStorageVolumeDeviceID = null != cpStorageVolumeDeviceID ? (String)cpStorageVolumeDeviceID.getValue() : null;
                if (null != cpSCSIPCDeviceID && null != cpSCSIPCSystemName) {
                    String cvSCSIPCDeviceID = (String)cpSCSIPCDeviceID.getValue();
                    String port = ProviderLibs.getAllButEndString(cvSCSIPCDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    String hostGroup = ProviderLibs.getEndString(cvSCSIPCDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    try {
                        sPort = Short.parseShort(port);
                        sHostGroup = Short.parseShort(hostGroup);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if (-1 != sPort && -1 != sHostGroup) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVolume, "SystemName");
                    CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                    LUPathObject.getLUPaths(device.getRMIObject(), callback, sPort);
                    LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                    callback = null;
                    LUPathObject luPath = luPaths.poll();
                    while (luPath != null) {
                        short ldev;
                        short cu;
                        short ldkc;
                        String dn;
                        if (sHostGroup == luPath.getSHostGrp() && (dn = String.valueOf(BaseDeviceNumber.makeUniqueDN(ldkc = luPath.getDKC(), cu = luPath.getCU(), ldev = luPath.getLDEV()))).equals(cvStorageVolumeDeviceID)) {
                            String lunDN = luPath.getLunString();
                            CIMInstance instAssoc = this.generateInstance(opObjectName, instSCSIPC.getObjectPath(), instStorageVolume.getObjectPath(), lunDN);
                            return instAssoc.filterProperties(propertyList);
                        }
                        luPath = luPaths.poll();
                    }
                }
            }
            catch (WBEMException we) {
                if (we.getID() == 6) {
                    throw new WBEMException(6, opObjectName.toString());
                }
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_ProtocolControllerForUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_ProtocolControllerForUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_ProtocolControllerForUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_SCSIPCForStorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_SCSIPCForStorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_SCSIPCForStorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LUPATH, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.LUPATH, this, null);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            String cnSCSIPC = this.getReference1ClassName();
            String cnStorageVolume = this.getReference2ClassName();
            String pnSCSIPC = this.getReference1PropertyName();
            String pnStorageVolume = this.getReference2PropertyName();
            if (null != assocName && "HITACHI_SCSIPCForStorageVolume".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(cnSCSIPC) && (null == role || role.equalsIgnoreCase(pnSCSIPC))) {
                    CIMInstance instSCSIPC = null;
                    try {
                        instSCSIPC = this.getReference1Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException e) {
                        instSCSIPC = null;
                    }
                    if (null != instSCSIPC) {
                        short sPortID = -1;
                        short sHostGroupID = -1;
                        CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                        if (null != cpDeviceID) {
                            String cvDeviceID = (String)cpDeviceID.getValue();
                            String portID = ProviderLibs.getAllButEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                            String hostGroup = ProviderLibs.getEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                            try {
                                sPortID = Short.parseShort(portID);
                                sHostGroupID = Short.parseShort(hostGroup);
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        if (-1 != sPortID && -1 != sHostGroupID) {
                            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                            CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                            LUPathObject.getLUPaths(device.getRMIObject(), callback, sPortID);
                            LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                            callback = null;
                            LUPathObject luPath = luPaths.poll();
                            while (luPath != null) {
                                if (sHostGroupID == luPath.getSHostGrp()) {
                                    short ldkc = luPath.getDKC();
                                    short cu = luPath.getCU();
                                    short ldev = luPath.getLDEV();
                                    long dn = BaseDeviceNumber.makeUniqueDN(ldkc, cu, ldev);
                                    String lunDN = luPath.getLunString();
                                    Hashtable<String, Object> expectedValues = new Hashtable<String, Object>();
                                    String deviceID = String.valueOf(dn);
                                    expectedValues.put("DeviceID", deviceID);
                                    expectedValues.put("SystemName", device.getStorageSystemName());
                                    CustomCloseableIterator iterStorageVolume = new CustomCloseableIterator();
                                    this.getReference2Instrumentation().enumerate(iterStorageVolume, objectName, null, null, null, continueOnError, true, expectedValues, null);
                                    while (iterStorageVolume.hasNext()) {
                                        if (isObjectPath) {
                                            iter.add(this.generateObjectPath(objectName, instSCSIPC.getObjectPath(), iterStorageVolume.next()));
                                            continue;
                                        }
                                        CIMInstance instAssoc = this.generateInstance(objectName, instSCSIPC.getObjectPath(), (CIMObjectPath)iterStorageVolume.next(), lunDN);
                                        iter.add(instAssoc.filterProperties(propertyList));
                                    }
                                }
                                luPath = luPaths.poll();
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(cnStorageVolume) && (null == role || role.equalsIgnoreCase(pnStorageVolume))) {
                    CIMInstance instStorageVolume = null;
                    try {
                        instStorageVolume = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException e) {
                        instStorageVolume = null;
                    }
                    if (null != instStorageVolume) {
                        short[] deviceIDValues;
                        String deviceID;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                        if (null != cpDeviceID && null != (deviceID = (String)cpDeviceID.getValue()) && -1 != (deviceIDValues = BaseDeviceNumber.getDevIdStringValues(deviceID))[0] && -1 != deviceIDValues[1] && -1 != deviceIDValues[2]) {
                            CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                            LUPathObject.getLUPaths(device.getRMIObject(), callback, deviceIDValues[0], deviceIDValues[1], deviceIDValues[2]);
                            LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                            LUPathObject luPath = luPaths.poll();
                            while (luPath != null) {
                                short portID = luPath.getSPort();
                                short domainID = luPath.getSHostGrp();
                                short ctrID = PortandHostGroupInfo.getCtrIDUsingPortID(portID, device.getSerialNumber());
                                String lunDN = luPath.getLunString();
                                String spcDeviceID = portID + "." + domainID;
                                String spcSystemName = device.getStorageSystemName() + "." + ctrID;
                                Hashtable<String, Object> expectedValues = new Hashtable<String, Object>();
                                expectedValues.put("DeviceID", spcDeviceID);
                                expectedValues.put("ElementName", spcSystemName);
                                CustomCloseableIterator iterSCSIPC = new CustomCloseableIterator();
                                this.getReference1Instrumentation().enumerate(iterSCSIPC, objectName, propertyList, null, null, continueOnError, true, expectedValues, null);
                                while (iterSCSIPC.hasNext()) {
                                    if (isObjectPath) {
                                        iter.add(this.generateObjectPath(objectName, iterSCSIPC.next(), instStorageVolume.getObjectPath()));
                                        continue;
                                    }
                                    CIMInstance instAssoc = this.generateInstance(objectName, (CIMObjectPath)iterSCSIPC.next(), instStorageVolume.getObjectPath(), lunDN);
                                    iter.add(instAssoc.filterProperties(propertyList));
                                }
                                luPath = luPaths.poll();
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }

    private class CallbackHandler<E extends PortandHostGroupInfo>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E hostGroupInfo = item;
                    short port = ((PortandHostGroupInfo)hostGroupInfo).getPortID();
                    short hostGroup = ((PortandHostGroupInfo)hostGroupInfo).getHostgroupID();
                    CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)hostGroupInfo).getSerialNumber());
                    LUPathObject.getLUPaths(device.getRMIObject(), callback, port);
                    LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                    callback = null;
                    LUPathObject luPath = luPaths.poll();
                    while (luPath != null) {
                        if (hostGroup == luPath.getSHostGrp()) {
                            short ldkc = luPath.getDKC();
                            short cu = luPath.getCU();
                            short ldev = luPath.getLDEV();
                            String lunDN = luPath.getLunString();
                            long deviceID = BaseDeviceNumber.makeUniqueDN(ldkc, cu, ldev);
                            DeviceNumber dn = DeviceNumber.find(Long.toString(deviceID), device.getRMIObject());
                            CIMObjectPath opStorageVolume = SCSIPCForStorageVolumeInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, dn);
                            CIMObjectPath opSCSIPC = SCSIPCForStorageVolumeInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, hostGroupInfo);
                            if (this.mIsObjectPath) {
                                this.mIter.add(SCSIPCForStorageVolumeInstrumentation.this.generateObjectPath(this.mOP, opSCSIPC, opStorageVolume));
                            } else {
                                CIMInstance ci = SCSIPCForStorageVolumeInstrumentation.this.generateInstance(this.mOP, opSCSIPC, opStorageVolume, lunDN);
                                this.mIter.add(ci.filterProperties(this.mPropertyList));
                            }
                        }
                        luPath = luPaths.poll();
                    }
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

