/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class SnapshotVolumeCompositeExtentBasedOnCompositeLDEVExtentInstrumentation
extends BaseAssocInstrumentation {
    protected SnapshotVolumeCompositeExtentBasedOnCompositeLDEVExtentInstrumentation() {
        super("HITACHI_SnapshotVolumeCompositeExtentBasedOnCompositeLDEVExtent", "HITACHI_CompositeLDEVExtent", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.CompositeLDEVExtentInstrumentation"), "HITACHI_SnapshotVolumeCompositeExtent", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SnapshotVolumeCompositeExtentInstrumentation"));
    }

    private void addCompositeDN(CustomCloseableIterator<?> iter, CIMObjectPath op, DeviceNumber dn, boolean isObjectPath, String[] propertyList) throws Exception {
        if (null != op && null != dn) {
            CIMObjectPath opCompLDev = this.getReference2Instrumentation().generateObjectPath(op, dn);
            CIMObjectPath opLDev = this.getReference1Instrumentation().generateObjectPath(op, dn);
            if (isObjectPath) {
                iter.add(this.generateObjectPath(op, opLDev, opCompLDev));
            } else {
                iter.add(this.generateInstance(op, propertyList, opLDev, opCompLDev));
            }
        }
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SnapshotVolumeCompositeExtentBasedOnCompositeLDEVExtent".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    DeviceNumber dnLDEV;
                    String deviceID;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                    if (null != deviceIDProp && null != (deviceID = (String)deviceIDProp.getValue()) && null != (dnLDEV = DeviceNumber.findHeadLUSE(deviceID, device.getRMIObject())) && dnLDEV.isQSVvol()) {
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, dnLDEV));
                        } else {
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, dnLDEV));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    DeviceNumber dn;
                    String deviceID;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                    if (null != deviceIDProp && null != (deviceID = (String)deviceIDProp.getValue()) && (dn = DeviceNumber.find(deviceID, true, device.getRMIObject())) != null) {
                        Long[] compDNs = dn.getCompositeComponents();
                        if (null != compDNs && compDNs.length > 0) {
                            for (Long compDN : compDNs) {
                                DeviceNumber dnLDEV = DeviceNumber.find(Long.toString(compDN), false, device.getRMIObject());
                                if (null == dnLDEV) continue;
                                if (isObjectPath) {
                                    iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, compDN));
                                    continue;
                                }
                                iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, dnLDEV));
                            }
                        } else if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, dn));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, dn));
                        }
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                Callback<DeviceNumber> callback = new Callback<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList);
                DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1, true, VolumeTypeEnum.QSVVOL);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        return new CIMProperty[]{new CIMProperty("StartingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("EndingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("OrderIndex", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false)};
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opSnapVol;
            CIMObjectPath opCompVol = op.getKey(this.getReference1PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference1PropertyName()).getValue() : null;
            CIMObjectPath cIMObjectPath = opSnapVol = op.getKey(this.getReference2PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference2PropertyName()).getValue() : null;
            if (null != opCompVol && null != opSnapVol) {
                CIMInstance instComp = this.getReference1Instrumentation().getInstance(opCompVol, null);
                CIMInstance instSnap = this.getReference2Instrumentation().getInstance(opSnapVol, null);
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opSnapVol, "SystemName");
                String compDevID = null != opCompVol.getKey("DeviceID") ? (String)opCompVol.getKey("DeviceID").getValue() : null;
                String snapDevID = null != opSnapVol.getKey("DeviceID") ? (String)opSnapVol.getKey("DeviceID").getValue() : null;
                DeviceNumber dn = DeviceNumber.find(compDevID, true, device.getRMIObject());
                if (null != compDevID && null != dn) {
                    CIMObjectPath opNewComp = instComp.getObjectPath();
                    if (compDevID.equals(snapDevID)) {
                        return this.generateInstance(op, propertyList, opNewComp, instSnap.getObjectPath());
                    }
                    Long[] compositeDNs = dn.getCompositeComponents();
                    if (null != compositeDNs && compositeDNs.length > 0) {
                        for (Long compositeDN : compositeDNs) {
                            if (null == compositeDN || !compositeDN.equals(new Long(snapDevID))) continue;
                            DeviceNumber snapDN = DeviceNumber.find(snapDevID, true, device.getRMIObject());
                            CIMObjectPath opNewSnap = this.getReference2Instrumentation().generateObjectPath(op, snapDN);
                            return this.generateInstance(op, propertyList, opNewComp, opNewSnap);
                        }
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        String[] props;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        for (String prop : props = new String[]{"DeviceID", "SystemName"}) {
            CIMProperty cpProp = opRef1.getKey(prop);
            if (null == cpProp) continue;
            String val = (String)cpProp.getValue();
            hTable.put("DeviceID", val);
        }
        return hTable;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SnapshotVolumeCompositeExtentBasedOnCompositeLDEVExtent".equalsIgnoreCase(assocName.getObjectName())) {
                String deviceID = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        DeviceNumber dnCompLDEV;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                        if (null != deviceIDProp && null != (dnCompLDEV = DeviceNumber.findHeadLUSE(deviceID = (String)deviceIDProp.getValue(), device.getRMIObject())) && dnCompLDEV.isQSVvol()) {
                            CIMObjectPath opLDev = this.getReference1Instrumentation().generateObjectPath(objectName, dnCompLDEV);
                            CIMObjectPath opCompLDev = this.getReference2Instrumentation().generateObjectPath(objectName, dnCompLDEV);
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, opLDev, opCompLDev));
                            } else {
                                iter.add(this.generateInstance(objectName, propertyList, opLDev, opCompLDev));
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                    if (null != deviceIDProp && null != (deviceID = (String)deviceIDProp.getValue())) {
                        DeviceNumber dn = DeviceNumber.find(deviceID, true, device.getRMIObject());
                        this.addCompositeDN(iter, objectName, dn, isObjectPath, propertyList);
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private class Callback<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected Callback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) {
                ret = false;
            } else {
                try {
                    if (null != item) {
                        SnapshotVolumeCompositeExtentBasedOnCompositeLDEVExtentInstrumentation.this.addCompositeDN(this.mIter, this.mOP, item, this.mIsObjectPath, this.mPropertyList);
                    }
                }
                catch (Exception e) {
                    WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
                catch (Throwable th) {
                    WBEMException we = new WBEMException(1, th.toString(), null, th);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return ret;
        }
    }
}

