/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class StorageCapabilitiesOfUnpairedSnapshotVolumePoolInstrumentation
extends BaseInstrumentation {
    private static final UnsignedInteger16 UINT16_100 = new UnsignedInteger16(100);
    private static String UNPAIREDSNAPSHOTVOLUMEPOOL = "UnpairedSnapshotVolumePool";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"InstanceID", "SystemName"});
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        String classname = "HITACHI_StorageCapabilitiesOfUnpairedSnapshotVolumePool";
        int schemaNameLength = "HITACHI_".length();
        if (schemaNameLength < "HITACHI_StorageCapabilitiesOfUnpairedSnapshotVolumePool".length()) {
            classname = "HITACHI_StorageCapabilitiesOfUnpairedSnapshotVolumePool".substring(schemaNameLength);
        }
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("NoSinglePointOfFailureDefault", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataRedundancyDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PackageRedundancyDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty("DeltaReservationDefault", CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty("ExtentStripeLengthDefault", CIMDataType.UINT16_T, null, false), new CIMProperty("UserDataStripeDepthDefault", CIMDataType.UINT64_T, null, false), new CIMProperty("ParityLayoutDefault", CIMDataType.UINT16_T, null, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)classname, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)classname, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)classname, false), new CIMProperty("SupportedDataOrganizations", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("SupportedExtentTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_FOUR}, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageCapabilitiesOfUnpairedSnapshotVolumePool");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)(rmiObj.getSMISMappingContainer().getStorageSystemName() + "." + UNPAIREDSNAPSHOTVOLUMEPOOL), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageCapabilitiesOfUnpairedSnapshotVolumePool", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String systemName = ProviderLibs.getAllButEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            String idEndString = ProviderLibs.getEndString(instID);
            if (null != systemName && null != idEndString && systemName.equals(device.getStorageSystemName()) && idEndString.equals(UNPAIREDSNAPSHOTVOLUMEPOOL)) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    public Object invokeMethod(CIMObjectPath op, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        if (methodName.equalsIgnoreCase("CreateSetting")) {
            outArgs[0] = new CIMArgument("NewSetting", new CIMDataType("CIM_StorageSetting"), null);
            return ProviderConstants.UINT32_ONE;
        }
        if (methodName.equalsIgnoreCase("GetSupportedParityLayouts")) {
            outArgs[0] = new CIMArgument("ParityLayout", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
            return ProviderConstants.UINT32_TWO;
        }
        if (methodName.equalsIgnoreCase("GetSupportedStripeDepths")) {
            outArgs[0] = new CIMArgument("StripeDepths", CIMDataType.UINT64_ARRAY_T, (Object)new UnsignedInteger64[0]);
            return ProviderConstants.UINT32_ZED;
        }
        if (methodName.equalsIgnoreCase("GetSupportedStripeDepthRange")) {
            outArgs[0] = new CIMArgument("MinimumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
            outArgs[1] = new CIMArgument("MaximumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
            outArgs[2] = new CIMArgument("StripeDepthDivisor", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
            return ProviderConstants.UINT32_TWO;
        }
        if (methodName.equalsIgnoreCase("GetSupportedStripeLengths")) {
            outArgs[0] = new CIMArgument("StripeLengths", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
            return ProviderConstants.UINT32_TWO;
        }
        if (methodName.equalsIgnoreCase("GetSupportedStripeLengthRange")) {
            outArgs[0] = new CIMArgument("MinimumStripeLength", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
            outArgs[1] = new CIMArgument("MaximumStripeLength", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
            outArgs[2] = new CIMArgument("StripeLengthDivisor", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
            return ProviderConstants.UINT32_THREE;
        }
        throw new WBEMException(17, op.getObjectName() + " does not support the method: " + methodName);
    }
}

