/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageProcessorCardInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageProcessorCard", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageProcessorCard added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageProcessorCard", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageProcessorCard deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageProcessorCard", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                CHAInfo cha = (CHAInfo)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cha.getSerialNumber());
                CHAInfo newCHA = CHAInfo.find(cha.getCtrID(), device.getRMIObject());
                if (newCHA != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newCHA);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a HITACHI_StorageProcessorCardthat that has Control ID: " + cha.getCtrID());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageProcessorCard modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Tag", expectedValues, new String[]{"Tag", "SystemName"});
            int expCtrID = -1;
            if (null != expectedValues) {
                String expTag;
                if (1 != devices.size()) {
                    throw new WBEMException(1, "StorageProcessorSystem: invalid number of devices " + devices.size() + " expectedVals: " + expectedValues);
                }
                String string = expTag = null != expectedValues ? (String)expectedValues.get("Tag") : null;
                if (null != expTag) {
                    try {
                        expCtrID = Integer.parseInt(ProviderLibs.getEndString(expTag, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                    }
                    catch (Exception e) {
                        throw new WBEMException(1, "StorageProcessorSystem: invalid expected name value: " + expTag);
                    }
                }
            }
            for (RMIObjectMapping device : devices) {
                CHAInfo chaInfo;
                CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
                CHAInfo.getCHAInfoByCtrID(device.getRMIObject(), callback, expCtrID);
                LinkedList<CHAInfo> chaInfoList = callback.getReturnValue();
                callback = null;
                while (null != (chaInfo = chaInfoList.poll())) {
                    CIMObjectPath retOP = this.generateObjectPath(op, chaInfo);
                    if (null != refInfo) {
                        refInfo.addReference(iter, retOP);
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(retOP);
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, chaInfo));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter && !iter.isClosed()) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CHAInfo chaInfo = (CHAInfo)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(chaInfo.getSerialNumber());
        CIMProperty[] keys = retOP.getKeys();
        String tag = (String)keys[1].getValue();
        CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], new CIMProperty("Description", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("Manufacturer", CIMDataType.STRING_T, (Object)"HITACHI", false), new CIMProperty("Model", CIMDataType.STRING_T, (Object)device.getModel(), false), new CIMProperty("SerialNumber", CIMDataType.STRING_T, (Object)device.getSerialNumber(), false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)tag, false)};
        return new CIMInstance(retOP, props).filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{CHAInfo.class}, o, "HITACHI_StorageProcessorCard");
        CHAInfo chaInfo = (CHAInfo)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(chaInfo.getSerialNumber());
        String ctrID = String.valueOf(chaInfo.getCtrID());
        String tag = device.getStorageSystemName() + "." + ctrID;
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorCard", true), new CIMProperty("Tag", CIMDataType.STRING_T, (Object)tag, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageProcessorCard", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block7: {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Tag");
            try {
                String tagKeyValue;
                String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
                String string = tagKeyValue = null != op.getKey("Tag") ? (String)op.getKey("Tag").getValue() : null;
                if (null == tagKeyValue || null == ccName || !ccName.equals("HITACHI_StorageProcessorCard")) break block7;
                int ctrID = -1;
                try {
                    ctrID = Integer.parseInt(ProviderLibs.getEndString(tagKeyValue, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (-1 == ctrID) break block7;
                try {
                    CHAInfo chaInfo = CHAInfo.find(ctrID, device.getRMIObject());
                    if (null != chaInfo) {
                        return this.generateInstance(op, propertyList, chaInfo);
                    }
                }
                catch (Exception e) {}
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_StorageProcessorCard".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_StorageProcessorCard".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_StorageProcessorCard".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.CHA, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.CHA, this, null);
        }
    }
}

