/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StorageProcessorSystemDeviceFCPortInstrumentation
extends BaseAssocInstrumentation {
    protected StorageProcessorSystemDeviceFCPortInstrumentation() {
        super("HITACHI_StorageProcessorSystemDeviceFCPort", "HITACHI_StorageProcessorSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"), "HITACHI_FCPort", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.FCPortInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageProcessorSystemDeviceFCPort".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String ctrID;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        CIMProperty cpName = objectName.getKey("Name");
                        if (null != cpName && null != cpName.getValue() && null != (ctrID = ProviderLibs.getEndString((String)cpName.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR))) {
                            try {
                                short sCtrID = Short.parseShort(ctrID);
                                ClosableAddableIteratorCB<FCPort> callback = new ClosableAddableIteratorCB<FCPort>();
                                FCPort.getFCPorts(device.getRMIObject(), callback, isObjectPath, propertyList != null && propertyList.length != 0, null, null);
                                CloseableAddableIterator<FCPort> portList = callback.getWrappedCloseableAddableIter();
                                while (portList.hasNext()) {
                                    FCPort port = (FCPort)portList.next();
                                    if (!port.isRequestedType(FCPort.PortTypeRequested.OPEN) || sCtrID != port.getControlID()) continue;
                                    if (isObjectPath) {
                                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, port));
                                        continue;
                                    }
                                    iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, port));
                                }
                            }
                            catch (Throwable th) {}
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("GroupComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpSysName = objectName.getKey("SystemName");
                    if (null != cpSysName && null != cpSysName.getValue()) {
                        String ctrID = ProviderLibs.getEndString((String)cpSysName.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        CHAInfo chaInfo = CHAInfo.find(Integer.parseInt(ctrID), device.getRMIObject());
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, chaInfo));
                        } else {
                            try {
                                iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, chaInfo));
                            }
                            catch (Throwable th) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                ClosableAddableIteratorCB<FCPort> callback = new ClosableAddableIteratorCB<FCPort>();
                FCPort.getFCPorts(device.getRMIObject(), callback, isObjectPath, propertyList != null && propertyList.length != 0, null, null);
                CloseableAddableIterator<FCPort> portList = callback.getWrappedCloseableAddableIter();
                while (portList.hasNext()) {
                    FCPort port = (FCPort)portList.next();
                    if (!port.isRequestedType(FCPort.PortTypeRequested.OPEN)) continue;
                    CIMObjectPath opStorageProcessorSystem = this.getReference1Instrumentation().generateObjectPath(op, port);
                    CIMObjectPath opFCPort = this.getReference2Instrumentation().generateObjectPath(op, port);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opStorageProcessorSystem, opFCPort));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opStorageProcessorSystem, opFCPort));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageProcessorSystemDeviceFCPort".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String ctrID;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        CIMProperty cpName = objectName.getKey("Name");
                        if (null != cpName && null != cpName.getValue() && null != (ctrID = ProviderLibs.getEndString((String)cpName.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR))) {
                            try {
                                CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_StorageProcessorSystem", objectName.getKeys(), objectName.getXmlSchemaName());
                                short sCtrID = Short.parseShort(ctrID);
                                ClosableAddableIteratorCB<FCPort> callback = new ClosableAddableIteratorCB<FCPort>();
                                FCPort.getFCPorts(device.getRMIObject(), callback, isObjectPath, propertyList != null && propertyList.length != 0, null, null);
                                CloseableAddableIterator<FCPort> portList = callback.getWrappedCloseableAddableIter();
                                while (portList.hasNext()) {
                                    FCPort port = (FCPort)portList.next();
                                    if (!port.isRequestedType(FCPort.PortTypeRequested.OPEN) || sCtrID != port.getControlID()) continue;
                                    CIMObjectPath opFCPort = this.getReference2Instrumentation().generateObjectPath(objectName, port);
                                    if (isObjectPath) {
                                        iter.add(this.generateObjectPath(objectName, opStorageProcessorSystem, opFCPort));
                                        continue;
                                    }
                                    iter.add(this.generateInstance(objectName, propertyList, opStorageProcessorSystem, opFCPort));
                                }
                            }
                            catch (Throwable th) {}
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent"))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    String deviceIDKeyVal = (String)objectName.getKey("DeviceID").getValue();
                    FCPort port = FCPort.find(deviceIDKeyVal, FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                    if (null != port) {
                        CIMObjectPath opFCPort = this.getReference2Instrumentation().generateObjectPath(objectName, port);
                        CIMObjectPath opStorageProcessorSystem = this.getReference1Instrumentation().generateObjectPath(objectName, port);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opStorageProcessorSystem, opFCPort));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, opStorageProcessorSystem, opFCPort));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

