/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCoE;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StorageProcessorSystemDeviceFCoEEthernetPortInstrumentation
extends BaseAssocInstrumentation {
    protected StorageProcessorSystemDeviceFCoEEthernetPortInstrumentation() {
        super("HITACHI_StorageProcessorSystemDeviceFCoEEthernetPort", "HITACHI_StorageProcessorSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"), "HITACHI_FCoEEthernetPort", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.FCoEEthernetPortInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageProcessorSystemDeviceFCoEEthernetPort".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        CIMProperty cpName = objectName.getKey("Name");
                        if (null != cpName && null != cpName.getValue()) {
                            String ctrID = ProviderLibs.getEndString((String)cpName.getValue());
                            try {
                                FCoE fcoe;
                                Short sCtrID = Short.valueOf(ctrID);
                                CommonClassAsList<FCoE> callback = new CommonClassAsList<FCoE>();
                                FCoE.getFCoEs(device.getRMIObject(), callback, sCtrID, (short)-1);
                                LinkedList<FCoE> fcoeList = callback.getReturnValue();
                                callback = null;
                                while (null != (fcoe = fcoeList.poll())) {
                                    if (sCtrID.shortValue() != fcoe.getCtrlIDAsShort()) continue;
                                    if (isObjectPath) {
                                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, fcoe));
                                        continue;
                                    }
                                    iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, fcoe));
                                }
                            }
                            catch (Throwable th) {}
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("GroupComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String portVal = (String)cpDevID.getValue();
                    CIMProperty cpSysName = objectName.getKey("SystemName");
                    String ctrID = ProviderLibs.getEndString((String)cpSysName.getValue());
                    FCoE fcoe = FCoE.find(Short.parseShort(ctrID), Short.parseShort(portVal), device.getRMIObject());
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, fcoe));
                    } else {
                        try {
                            CHAInfo chaInfo = CHAInfo.find(Integer.parseInt(ctrID), device.getRMIObject());
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, chaInfo));
                        }
                        catch (Throwable th) {
                            // empty catch block
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                FCoE fcoe;
                CommonClassAsList<FCoE> callback = new CommonClassAsList<FCoE>();
                FCoE.getFCoEs(device.getRMIObject(), callback, null, null);
                LinkedList<FCoE> fcoeList = callback.getReturnValue();
                callback = null;
                while (null != (fcoe = fcoeList.poll())) {
                    CIMObjectPath opStorageProcessorSystem = this.getReference1Instrumentation().generateObjectPath(op, fcoe);
                    CIMObjectPath opFCoEPort = this.getReference2Instrumentation().generateObjectPath(op, fcoe);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opStorageProcessorSystem, opFCoEPort));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opStorageProcessorSystem, opFCoEPort));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageProcessorSystemDeviceFCoEEthernetPort".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String ctrID;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        CIMProperty cpName = objectName.getKey("Name");
                        if (null != cpName && null != cpName.getValue() && null != (ctrID = ProviderLibs.getEndString((String)cpName.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR))) {
                            try {
                                FCoE fcoe;
                                CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_StorageProcessorSystem", objectName.getKeys(), objectName.getXmlSchemaName());
                                short sCtrID = Short.parseShort(ctrID);
                                CommonClassAsList<FCoE> callback = new CommonClassAsList<FCoE>();
                                FCoE.getFCoEs(device.getRMIObject(), callback, sCtrID, null);
                                LinkedList<FCoE> portList = callback.getReturnValue();
                                callback = null;
                                while (null != (fcoe = portList.poll())) {
                                    if (sCtrID != fcoe.getCtrlIDAsShort()) continue;
                                    CIMObjectPath opFCoE = this.getReference2Instrumentation().generateObjectPath(objectName, fcoe);
                                    if (isObjectPath) {
                                        iter.add(this.generateObjectPath(objectName, opStorageProcessorSystem, opFCoE));
                                        continue;
                                    }
                                    iter.add(this.generateInstance(objectName, propertyList, opStorageProcessorSystem, opFCoE));
                                }
                            }
                            catch (Throwable th) {}
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String portVal = (String)cpDevID.getValue();
                    CIMProperty cpSysName = objectName.getKey("SystemName");
                    String ctrID = ProviderLibs.getEndString((String)cpSysName.getValue());
                    FCoE fcoe = FCoE.find(Short.parseShort(ctrID), Short.parseShort(portVal), device.getRMIObject());
                    if (null != fcoe) {
                        CIMObjectPath opFCoE = this.getReference2Instrumentation().generateObjectPath(objectName, fcoe);
                        CIMObjectPath opStorageProcessorSystem = this.getReference1Instrumentation().generateObjectPath(objectName, fcoe);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opStorageProcessorSystem, opFCoE));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, opStorageProcessorSystem, opFCoE));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

