/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FCoE;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageProcessorSystemInstrumentation
extends BaseInstrumentation {
    private static final String PORTWWN = "PortWWN";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Name", expectedValues, new String[]{"ElementName", "SystemName", "Name"});
            int expCtrID = -1;
            if (null != expectedValues) {
                String expName;
                if (1 != devices.size()) {
                    mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, device infoinvalid. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_StorageProcessorSystem", expectedValues, devices.size()});
                    if (null != iter) {
                        iter.done();
                    }
                    return;
                }
                String string = expName = null != expectedValues ? (String)expectedValues.get("Name") : null;
                if (null != expName) {
                    try {
                        expCtrID = Integer.parseInt(ProviderLibs.getEndString(expName, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                    }
                    catch (Exception e) {
                        throw new WBEMException(1, "StorageProcessorSystem: invalid name value: " + expName, null, (Throwable)e);
                    }
                }
            }
            for (RMIObjectMapping device : devices) {
                CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
                CHAInfo.getCHAInfoByCtrID(device.getRMIObject(), callback, expCtrID);
                LinkedList<CHAInfo> chaInfoList = callback.getReturnValue();
                callback = null;
                CHAInfo chaInfo = chaInfoList.poll();
                while (chaInfo != null) {
                    CIMObjectPath retOP = this.generateObjectPath(op, chaInfo);
                    if (null != refInfo) {
                        refInfo.addReference(iter, retOP);
                    } else if (isObjectPath) {
                        iter.add(retOP);
                    } else {
                        iter.add(this.generateInstance(op, propertyList, chaInfo));
                    }
                    chaInfo = chaInfoList.poll();
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CHAInfo chaInfo = (CHAInfo)o[0];
        try {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(chaInfo.getSerialNumber());
            CommonClassAsList<FCPort> fcpArray = new CommonClassAsList<FCPort>();
            FCPort.getFCPorts(device.getRMIObject(), fcpArray, false, true, null, null);
            LinkedList<FCPort> portList = fcpArray.getReturnValue();
            fcpArray = null;
            CIMProperty<?>[] props = this.getProperties(propertyList, retOP.getKeys(), device, chaInfo, portList);
            CIMInstance ci = new CIMInstance(retOP, props);
            return ci.filterProperties(propertyList);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        String serialNum;
        String ctrID;
        if (null == o || o.length < 1) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_OBJECTPATH_ILLEGAL_ARGUMENT + " " + "HITACHI_StorageProcessorSystem");
        }
        if (o[0] instanceof CHAInfo) {
            CHAInfo inf = (CHAInfo)o[0];
            ctrID = Integer.toString(inf.getCtrID());
            serialNum = inf.getSerialNumber();
        } else if (o[0] instanceof FCPort) {
            FCPort fcPort = (FCPort)o[0];
            ctrID = String.valueOf(fcPort.getControlID());
            serialNum = fcPort.getSerialNumber();
        } else if (o[0] instanceof FCoE) {
            FCoE fcoe = (FCoE)o[0];
            ctrID = String.valueOf(fcoe.getCtrlIDAsShort());
            serialNum = fcoe.getSerialNumber();
        } else {
            throw new WBEMException("Invalid args passed to generateObjectPath, arg is " + (null == o[0] ? "null" : o[0].getClass().getSimpleName()));
        }
        String name = RMIObjectMapping.getRMIObjectMapping(serialNum).getStorageSystemName() + "." + ctrID;
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageProcessorSystem", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block7: {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Name");
            try {
                String nameKeyVal;
                String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
                String string = nameKeyVal = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
                if (null == nameKeyVal || null == ccName || !ccName.equals("HITACHI_StorageProcessorSystem")) break block7;
                int ctrID = -1;
                try {
                    ctrID = Integer.parseInt(ProviderLibs.getEndString(nameKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (-1 == ctrID) break block7;
                try {
                    CHAInfo chaInfo = CHAInfo.find(ctrID, device.getRMIObject());
                    if (null != chaInfo) {
                        return this.generateInstance(op, propertyList, chaInfo);
                    }
                }
                catch (Exception e) {}
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    private CIMProperty<?>[] getProperties(String[] propertyList, CIMProperty<?>[] keys, RMIObjectMapping device, CHAInfo chaInfo, LinkedList<FCPort> portList) throws WBEMException {
        ArrayList props = new ArrayList();
        String ctrName = chaInfo.getDisplayName();
        int ctrID = chaInfo.getCtrID();
        ArrayList<String> otherIdentifyingInfo = new ArrayList<String>();
        ArrayList<String> otherIdentifyingInfoDesc = new ArrayList<String>();
        FCPort port = portList.poll();
        while (null != port) {
            if (port.getControlID() == ctrID) {
                otherIdentifyingInfo.add(port.getPortWWN());
                otherIdentifyingInfoDesc.add(PORTWWN);
            }
            port = portList.poll();
        }
        ProviderLibs.addKeysToProperties(keys, props);
        props.add(new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)"Other", false));
        props.add(new CIMProperty("OtherIdentifyingInfo", CIMDataType.STRING_ARRAY_T, (Object)otherIdentifyingInfo.toArray(new String[otherIdentifyingInfo.size()]), false));
        props.add(new CIMProperty("IdentifyingDescriptions", CIMDataType.STRING_ARRAY_T, (Object)otherIdentifyingInfoDesc.toArray(new String[otherIdentifyingInfoDesc.size()]), false));
        props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
        props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
        props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
        props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false));
        props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
        props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
        props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)ctrName, false));
        props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)ctrName, false));
        props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)ctrName, false));
        props.add(new CIMProperty("Dedicated", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_FIVE}, false));
        return props.toArray(new CIMProperty[props.size()]);
    }
}

