/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class StorageSystemDeviceCompositeLDEVExtentInstrumentation
extends BaseAssocInstrumentation {
    public StorageSystemDeviceCompositeLDEVExtentInstrumentation() {
        super("HITACHI_StorageSystemDeviceCompositeLDEVExtent", "HITACHI_StorageSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_CompositeLDEVExtent", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.CompositeLDEVExtentInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_StorageSystemDeviceCompositeLDEVExtent".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, this.createExpectedVals(device), null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("GroupComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private Hashtable<String, Object> createExpectedVals(RMIObjectMapping device) throws WBEMException {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("SystemName", device.getStorageSystemName());
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opCompLDEV = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_CompositeLDEVExtent", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(opStorageSystem, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(iter, opCompLDEV, new String[0], null, null, continueOnError, true, this.createExpectedVals(device), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block6: {
            try {
                CIMInstance instCompositeLDEVExtent;
                CIMObjectPath opStorageSystem;
                block7: {
                    String ssNameCompositeLDEVExtent;
                    String ssName;
                    CIMObjectPath opCompositeLDEVExtent;
                    String cpnStorageSystem = this.getReference1PropertyName();
                    opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
                    String cpnCompositeLDEVExtent = this.getReference2PropertyName();
                    CIMObjectPath cIMObjectPath = opCompositeLDEVExtent = op.getKey(cpnCompositeLDEVExtent) != null ? (CIMObjectPath)op.getKey(cpnCompositeLDEVExtent).getValue() : null;
                    if (null == opCompositeLDEVExtent || null == opStorageSystem) break block6;
                    String string = ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                    if (null == ssName) break block6;
                    String string2 = ssNameCompositeLDEVExtent = opCompositeLDEVExtent.getKey("SystemName") != null && opCompositeLDEVExtent.getKey("SystemName").getValue() != null ? (String)opCompositeLDEVExtent.getKey("SystemName").getValue() : null;
                    if (!ssName.equalsIgnoreCase(ssNameCompositeLDEVExtent)) break block6;
                    instCompositeLDEVExtent = null;
                    try {
                        instCompositeLDEVExtent = this.getReference2Instrumentation().getInstance(opCompositeLDEVExtent, null);
                    }
                    catch (WBEMException we) {
                        if (we.getID() == 6) break block7;
                        throw we;
                    }
                }
                if (null != instCompositeLDEVExtent) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                    opStorageSystem = this.getReference1Instrumentation().generateObjectPath(opStorageSystem, device.getRMIObject());
                    return this.generateInstance(op, propertyList, opStorageSystem, instCompositeLDEVExtent.getObjectPath());
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_StorageSystemDeviceCompositeLDEVExtent".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageSystem") && (null == role || role.equalsIgnoreCase("GroupComponent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath opCompLDEV = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_CompositeLDEVExtent", null);
                    CIMObjectPath opStorageSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opStorageSystem, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                    this.getReference2Instrumentation().enumerate(iter, opCompLDEV, new String[0], null, null, continueOnError, true, this.createExpectedVals(device), newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_CompositeLDEVExtent") && (null == role || role.equalsIgnoreCase("PartComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opCompLDEV = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opStorageSystem, opCompLDEV));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opStorageSystem, opCompLDEV));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

