/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.LDevNickname;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageVolumeCallbackHandler;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.VirtualLDEV;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;

public class StorageVolumeInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    private static NicknameChanged nickNameListener = null;
    protected static final UnsignedInteger8 deltaReservation = ProviderConstants.UINT8_100;
    private static final UnsignedInteger16 enabledDefault = ProviderConstants.UINT16_TWO;
    private static final UnsignedInteger16 enabledState = ProviderConstants.UINT16_FIVE;
    protected static final UnsignedInteger16[] extentStatus = new UnsignedInteger16[]{ProviderConstants.UINT16_SIX};
    protected static final UnsignedInteger16[] opStatus = new UnsignedInteger16[]{ProviderConstants.UINT16_TWO};
    private static final Boolean primordial = new Boolean(false);
    private static final UnsignedInteger16 requestedState = new UnsignedInteger16(12);
    private static final Boolean sequentialAccess = new Boolean(false);
    private static final String[] statusDescs = new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)};

    protected static String[] getExtentDiscriminator(UnsignedInteger16 usageVal) {
        String[] extentDiscriminator = usageVal.compareTo(ProviderConstants.UINT16_TWO) == 0 || usageVal.compareTo(ProviderConstants.UINT16_32768) == 0 ? new String[]{"SNIA:Allocated"} : (usageVal.compareTo(ProviderConstants.UINT16_32769) == 0 ? new String[]{"SNIA:Reserved", "SNIA:Allocated"} : (usageVal.compareTo(ProviderConstants.UINT16_ONE) == 0 ? new String[]{"SNIA:Reserved", "SNIA:Allocated"} : new String[]{"SNIA:Reserved", "SNIA:Allocated"}));
        return extentDiscriminator;
    }

    private static String getHPZZZZZ(boolean isHitachi, short cu, short ldev) {
        String t;
        if (!isHitachi) {
            int encoded = ProviderLibs.encodeCULDEVNumber(cu, ldev);
            t = String.format("%05d", encoded);
            t = StorageVolumeInstrumentation.trimFromLeft(t, 5);
        } else {
            t = null;
        }
        return t;
    }

    private static void getR50Name(StringBuilder ret, RMIObjectMapping device, int serial, short dkc, short cu, short ldev, String model) throws WBEMException {
        String YYYYSerial;
        String r50;
        boolean isHitachi = device.isHitachiSystem();
        String ZZZZ = StorageVolumeInstrumentation.getHPZZZZZ(isHitachi, cu, ldev);
        switch (model) {
            case "HM800 (S Model)": 
            case "HM800 (M Model)": 
            case "HM800 (H Model)": 
            case "HM800": {
                if (isHitachi) {
                    r50 = " 504";
                    YYYYSerial = null;
                    break;
                }
                mLogger.severe("HM800 marked as non-Hitachi system.");
                r50 = "003";
                String t = String.format("%05d", serial);
                YYYYSerial = StorageVolumeInstrumentation.trimFromLeft(t, 5);
                break;
            }
            case "Raid800": {
                if (isHitachi) {
                    r50 = " 503";
                    YYYYSerial = null;
                    break;
                }
                r50 = "003";
                String t = String.format("%05d", serial);
                YYYYSerial = StorageVolumeInstrumentation.trimFromLeft(t, 5);
                break;
            }
            case "HM700": {
                if (isHitachi) {
                    r50 = " 502";
                    YYYYSerial = null;
                    break;
                }
                r50 = "003";
                String t = String.format("%05d", serial);
                YYYYSerial = StorageVolumeInstrumentation.trimFromLeft(t, 5);
                break;
            }
            case "Raid700": 
            case "Raid600": {
                if (isHitachi) {
                    r50 = String.format("%sR%s", 0 == dkc ? " " : "1", "50");
                    YYYYSerial = null;
                    break;
                }
                r50 = String.format(" %03d", dkc);
                String t = String.format("%05d", serial);
                YYYYSerial = StorageVolumeInstrumentation.trimFromLeft(t, 5);
                break;
            }
            case "Raid500": {
                if (isHitachi) {
                    r50 = " R50";
                    YYYYSerial = null;
                    break;
                }
                r50 = " ";
                String t = String.format("%08d", serial);
                YYYYSerial = StorageVolumeInstrumentation.trimFromLeft(t, 8);
                break;
            }
            default: {
                throw new WBEMException("Unable to generate volume name for model " + model);
            }
        }
        if (isHitachi) {
            String t;
            ret.append("HITACHI");
            ret.append(r50);
            try {
                t = String.format("%05X", serial);
                ret.append(StorageVolumeInstrumentation.trimFromLeft(t, 5));
            }
            catch (NumberFormatException e) {
                mLogger.log(Level.SEVERE, "Unable to get serial number, using 0's", e);
                ret.append(String.format("%05X", 0));
            }
            t = String.format("%02X", cu);
            ret.append(StorageVolumeInstrumentation.trimFromLeft(t, 2));
            t = String.format("%02X", ldev);
            ret.append(StorageVolumeInstrumentation.trimFromLeft(t, 2));
        } else {
            ret.append("R500");
            ret.append(' ');
            ret.append(r50);
            ret.append(YYYYSerial);
            ret.append('0');
            ret.append(ZZZZ);
            ret.append(' ');
        }
    }

    protected static String getStorageVolumeName(DeviceNumber dn, VirtualLDEV vDN) throws WBEMException {
        short ldev;
        short cu;
        short dkc;
        String model;
        int serial;
        if (null == vDN) {
            serial = Integer.parseInt(dn.getSerialNumber());
            model = "HM800";
            dkc = dn.getLdkc();
            cu = dn.getCu();
            ldev = dn.getLdev();
        } else {
            Long serNum = vDN.getvSerialNum();
            serial = serNum.intValue();
            BaseDeviceNumber bdn = vDN.getVirtLDEVInfo();
            short[] vals = BaseDeviceNumber.getDevIdStringValues(bdn.getDNAsString());
            dkc = vals[0];
            ldev = bdn.getLdev();
            cu = bdn.getCu();
            model = vDN.getVModelName();
        }
        if (1 == dn.getVolumeFlag()) {
            String dnAsString = null == vDN ? dn.getDNAsString() : vDN.getVirtLDEVInfo().getDNAsString();
            return String.valueOf(cu) + "+" + dnAsString;
        }
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
        if (null == device) {
            throw new WBEMException(1, "Could not get RMIMapping for device with serial number: " + dn.getSerialNumber());
        }
        int hostMode = -1;
        if (dn.getFirstLUNPort() != -1) {
            try {
                CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
                PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, null, null, Short.toString(dn.getFirstLUNPort()), null, null, false, null, true);
                LinkedList<PortandHostGroupInfo> phgis = callback.getReturnValue();
                callback = null;
                if (phgis != null && phgis.size() > 0) {
                    PortandHostGroupInfo phgi = (PortandHostGroupInfo)phgis.get(0);
                    hostMode = phgi.getHostMode().shortValue();
                }
            }
            catch (Throwable we) {
                mLogger.log(Level.SEVERE, "Exception occurred getting hostMode for DeviceNumber: " + dn + " using default for Host Mode", we);
                hostMode = -1;
            }
        }
        StringBuilder ret = new StringBuilder();
        if (hostMode != 5 && hostMode != 7) {
            StorageVolumeInstrumentation.getR50Name(ret, device, serial, dkc, cu, ldev, model);
        } else {
            StorageVolumeInstrumentation.getVMSTru64Name(ret, device, serial, dkc, cu, ldev, (short)hostMode, model);
        }
        return ret.toString();
    }

    private static void getVMSTru64Name(StringBuilder ret, RMIObjectMapping device, int serial, short dkc, short cu, short ldev, short hostMode, String model) throws WBEMException {
        String xx;
        char betweenUandV;
        String sn5Str = String.format("%5d", serial);
        int sn5 = Integer.parseInt(sn5Str);
        int u = 1 <= sn5 && sn5 < 65535 ? 0 : 1;
        switch (model) {
            case "HM800 (S Model)": 
            case "HM800 (M Model)": 
            case "HM800 (H Model)": 
            case "HM800": {
                betweenUandV = '2';
                ++u;
                if (5 == hostMode) {
                    xx = "00504";
                    break;
                }
                xx = "00000900";
                break;
            }
            case "Raid800": {
                betweenUandV = '7';
                if (5 == hostMode) {
                    xx = "00003";
                    break;
                }
                xx = "00000900";
                break;
            }
            case "HM700": {
                betweenUandV = '3';
                ++u;
                if (5 == hostMode) {
                    xx = "00502";
                    break;
                }
                xx = "00000900";
                break;
            }
            case "Raid700": {
                betweenUandV = '6';
                xx = String.format("%02X", dkc);
                break;
            }
            case "Raid600": {
                betweenUandV = '5';
                xx = String.format("%02X", dkc);
                break;
            }
            case "Raid500": {
                betweenUandV = '4';
                xx = String.format("00%02X", dkc);
                break;
            }
            default: {
                throw new WBEMException("Unable to generate VMS volume name for model " + model);
            }
        }
        String VMS_TRU64 = String.format("60060E80%1d", u);
        ret.append(VMS_TRU64);
        ret.append(betweenUandV);
        String t = String.format("%04X", serial);
        ret.append(t);
        ret.append(xx);
        t = String.format("%05X", serial);
        ret.append(StorageVolumeInstrumentation.trimFromLeft(t, 5));
        if (5 == hostMode) {
            ret.append("0000");
        }
        t = String.format("%02X", cu);
        ret.append(StorageVolumeInstrumentation.trimFromLeft(t, 2));
        t = String.format("%02X", ldev);
        ret.append(StorageVolumeInstrumentation.trimFromLeft(t, 2));
    }

    private static String trimFromLeft(String origStr, int maxChars) {
        String ret = origStr;
        if (ret.length() > maxChars) {
            ret = ret.substring(ret.length() - maxChars);
        }
        return ret;
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageVolume", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageVolume added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageVolume", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageVolume deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageVolume", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                DeviceNumber dn = (DeviceNumber)pObj;
                String serialNumber = dn.getSerialNumber();
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
                if (null == device) {
                    throw new WBEMException(1, "Could not get RMIMapping for device with serial number: " + serialNumber);
                }
                DeviceNumber newInst = DeviceNumber.find(dn.getDNAsString(), device.getRMIObject());
                if (newInst != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a volume that with Device ID: " + dn.getDNAsString());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageVolume modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            String expSysName = null;
            String expInstID = null;
            String refInstID = null;
            String expDeviceID = null;
            String expPoolID = null;
            UnsignedInteger16 expUsage = null;
            Integer fb4 = null;
            Integer pg = null;
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, no device infoavailable. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_StorageVolume", expectedValues, devices.size()});
                    if (null != iter) {
                        iter.done();
                    }
                    return;
                }
                expSysName = (String)expectedValues.get("SystemName");
                expInstID = (String)expectedValues.get("InstanceID");
                refInstID = (String)expectedValues.get("HITACHI_StorageVolume");
                expDeviceID = (String)expectedValues.get("DeviceID");
                expPoolID = (String)expectedValues.get("PoolID");
                expUsage = (UnsignedInteger16)expectedValues.get("Usage");
                fb4 = (Integer)expectedValues.get("fb4");
                pg = (Integer)expectedValues.get("pg");
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                RMIObjectCache rmiObj = device.getRMIObject();
                String systemName = device.getStorageSystemName();
                if (null != expSysName && !expSysName.equalsIgnoreCase(systemName)) continue;
                ChassisArrayGroup cag = null;
                if (null != expInstID) {
                    Integer[] ret = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                    cag = ChassisArrayGroup.find(rmiObj, null, ret[0], ret[1], isObjectPath);
                    if (null == cag) {
                        throw new WBEMException(1, "unable to locate required array group: " + expInstID);
                    }
                } else if (null != refInstID) {
                    int dnIdx = refInstID.lastIndexOf(".");
                    refInstID = refInstID.substring(dnIdx + 1);
                }
                StorageVolumeCallbackHandler<DeviceNumber> callback = new StorageVolumeCallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList, expDeviceID, expInstID, expUsage, cag, VolumeTypeEnum.ALL, this);
                if (expPoolID == null) {
                    if (fb4 != null) {
                        DeviceNumber.getDNs(rmiObj, callback, isObjectPath, true, null, (int)fb4, pg == null ? -1 : pg, -1);
                        continue;
                    }
                    DeviceNumber.getDNs(rmiObj, callback, isObjectPath, null == propertyList || propertyList.length > 0, refInstID, true);
                    continue;
                }
                short thinPoolID = Short.parseShort(expPoolID);
                DeviceNumber.getDNs(rmiObj, callback, thinPoolID, true, VolumeTypeEnum.AOUVOL_OR_QSVVOL);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        CIMObjectPath dnOP = this.generateObjectPath(op, o);
        DeviceNumber devNum = (DeviceNumber)o[0];
        String serialNumber = devNum.getSerialNumber();
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
        if (null == device) {
            throw new WBEMException(1, "Could not get RMIMapping for device with serial number: " + serialNumber);
        }
        try {
            CIMProperty<?>[] retProps = this.getProperties(propertyList, dnOP.getKeys(), devNum);
            CIMInstance ret = new CIMInstance(dnOP, retProps);
            return ret.filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{BaseDeviceNumber.class}, o, "HITACHI_StorageVolume");
        BaseDeviceNumber deviceNum = (BaseDeviceNumber)o[0];
        CIMObjectPath ret = null;
        String systemName = RMIObjectMapping.getRMIObjectMapping(deviceNum.getSerialNumber()).getStorageSystemName();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageVolume", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceNum.getDNAsString(), true)};
        ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageVolume", keys, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            RMIObjectCache rmiObj;
            DeviceNumber dn;
            String deviceIDKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String string = deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            if (null != deviceIDKeyVal && "HITACHI_StorageVolume".equalsIgnoreCase(ccName) && "HITACHI_StorageSystem".equalsIgnoreCase(sccName) && (dn = DeviceNumber.find(deviceIDKeyVal, true, rmiObj = device.getRMIObject())) != null) {
                return this.generateInstance(op, propertyList, dn);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private synchronized NicknameChanged getNicknameListener() {
        if (nickNameListener == null) {
            nickNameListener = new NicknameChanged();
        }
        return nickNameListener;
    }

    CIMProperty<?>[] getProperties(String[] propertyList, CIMProperty<?>[] keys, DeviceNumber dn) throws WBEMException {
        String serialNumber = dn.getSerialNumber();
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
        if (null == device) {
            throw new WBEMException(1, "Could not get RMIMapping for device with serial number: " + serialNumber);
        }
        ArrayList props = new ArrayList();
        UnsignedInteger16 usage = dn.getUsageValue();
        ProviderLibs.addKeysToProperties(keys, props);
        props.add(new CIMProperty("Usage", CIMDataType.UINT16_T, (Object)usage, false));
        props.add(new CIMProperty("IsComposite", CIMDataType.BOOLEAN_T, (Object)false, false));
        UnsignedInteger16 valConsistsOf = null;
        try {
            valConsistsOf = dn.getConsistsOf(null);
        }
        catch (Exception e) {
            mLogger.log(Level.WARNING, "Error getting data", e);
        }
        props.add(new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)valConsistsOf, false));
        props.add(new CIMProperty("Consumed", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(dn.getSpaceConsumed())), false));
        props.add(new CIMProperty("LDKCNumber", CIMDataType.UINT16_T, (Object)new UnsignedInteger16((int)dn.getLdkc()), false));
        props.add(new CIMProperty("NameFormat", CIMDataType.UINT16_T, (Object)ProviderLibs.getNameFormat(dn.getVolumeFlag()), false));
        props.add(new CIMProperty("NameNamespace", CIMDataType.UINT16_T, (Object)ProviderLibs.getNameNameSpace(device, dn.getVolumeFlag()), false));
        props.add(new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)dn.getDataOrganization(), false));
        props.add(new CIMProperty("OtherNameFormat", CIMDataType.STRING_T, (Object)ProviderLibs.getOtherNameFormat(dn), false));
        props.add(new CIMProperty("OtherNameNamespace", CIMDataType.STRING_T, (Object)"VPD83Type3", false));
        String purpose = null;
        if (dn.isBLUPathCmdDev()) {
            purpose = "CommandDevice";
        }
        props.add(new CIMProperty("Purpose", CIMDataType.STRING_T, (Object)purpose, false));
        props.add(new CIMProperty("ErrorMethodology", CIMDataType.STRING_T, (Object)dn.getRaidLevel(), false));
        props.add(new CIMProperty("BlockSize", CIMDataType.UINT64_T, (Object)dn.getBlockSize(), false));
        props.add(new CIMProperty("NumberOfBlocks", CIMDataType.UINT64_T, (Object)dn.getNumOfBlocks(), false));
        props.add(new CIMProperty("ConsumableBlocks", CIMDataType.UINT64_T, (Object)dn.getNumOfBlocks(), false));
        ProviderConstants.RAID_Level raidLevel = ProviderLibs.getRaidLevelFromString(dn.getRaidLevel());
        props.add(new CIMProperty("IsBasedOnUnderlyingRedundancy", CIMDataType.BOOLEAN_T, (Object)(raidLevel != ProviderConstants.RAID_Level.RAID0 && raidLevel != ProviderConstants.RAID_Level.UNKNOWN ? 1 : 0), false));
        props.add(new CIMProperty("SequentialAccess", CIMDataType.BOOLEAN_T, (Object)sequentialAccess, false));
        props.add(new CIMProperty("ExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)extentStatus, false));
        props.add(new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)(raidLevel != ProviderConstants.RAID_Level.RAID0 && raidLevel != ProviderConstants.RAID_Level.UNKNOWN ? 1 : 0), false));
        UnsignedInteger16 valDataRedendancy = new UnsignedInteger16(ProviderLibs.getDataRedudancy(dn.getRaidLevel()));
        props.add(new CIMProperty("DataRedundancy", CIMDataType.UINT16_T, (Object)valDataRedendancy, false));
        UnsignedInteger16 valPackageRedundancy = new UnsignedInteger16(ProviderLibs.getPackageRedudancy(dn.getRaidLevel()));
        props.add(new CIMProperty("PackageRedundancy", CIMDataType.UINT16_T, (Object)valPackageRedundancy, false));
        props.add(new CIMProperty("DeltaReservation", CIMDataType.UINT8_T, (Object)deltaReservation, false));
        props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)primordial, false));
        props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)enabledState, false));
        props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)requestedState, false));
        props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)enabledDefault, false));
        props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)opStatus, false));
        props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)statusDescs, false));
        props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)dn.getHealthState(), false));
        StringBuilder poolID = new StringBuilder("StorageVolume:");
        try {
            poolID = poolID.append(device.getStorageSystemName());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Exception e) {
            throw new WBEMException(1, "Unable to get system name", null, (Throwable)e);
        }
        poolID = poolID.append(".");
        poolID = poolID.append(dn.getLDEVIDString());
        String value = poolID.toString();
        String label = this.getVolumeLabel(dn);
        props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)value, false));
        props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)value, false));
        props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)(null == label || 0 == label.length() ? value : label), false));
        props.add(new CIMProperty("CUImage", CIMDataType.STRING_T, (Object)ProviderLibs.getCUImage(dn), false));
        props.add(new CIMProperty("SubsystemID", CIMDataType.STRING_T, (Object)ProviderLibs.getSubSystemIDString(dn), false));
        props.add(new CIMProperty("EmulatedDevice", CIMDataType.STRING_T, (Object)ProviderLibs.getEmulatedDevice(dn), false));
        props.add(new CIMProperty("CanDelete", CIMDataType.BOOLEAN_T, (Object)true, false));
        props.add(new CIMProperty("ThinlyProvisioned", CIMDataType.BOOLEAN_T, (Object)(dn.isAOUVol() ? 1 : 0), false));
        props.add(new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderLibs.getExtentType(dn), false));
        props.add(new CIMProperty("Label", CIMDataType.STRING_T, (Object)(null == label ? "" : label), false));
        String[] extentDiscriminator = StorageVolumeInstrumentation.getExtentDiscriminator(usage);
        props.add(new CIMProperty("ExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)extentDiscriminator, false));
        props.add(new CIMProperty("StorageTieringSelection", CIMDataType.UINT16_T, (Object)this.getStorageTieringSelection(dn), false));
        this.getVirtualVolumeData(device, dn, props);
        RMIObjectCache rmiObj = device.getRMIObject();
        props.add(new CIMProperty("IsCompressed", CIMDataType.BOOLEAN_T, (Object)dn.isCompressed(rmiObj), false));
        props.add(new CIMProperty("CompressionState", CIMDataType.UINT16_T, null, false));
        props.add(new CIMProperty("CompressionRate", CIMDataType.UINT16_T, null, false));
        return props.toArray(new CIMProperty[props.size()]);
    }

    private UnsignedInteger16 getStorageTieringSelection(DeviceNumber dn) {
        UnsignedInteger16 ret = ProviderConstants.UINT16_TWO;
        if (dn.isAOUVol()) {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
            try {
                ThinPool tp = ThinPool.find(device.getRMIObject(), dn.getThinPoolID(), ThinPool.ThinPoolType.AOU);
                if (null != tp) {
                    if ((tp.getTierControlInfo() & 0x80) != 0) {
                        ret = ProviderConstants.UINT16_THREE;
                    }
                } else {
                    mLogger.log(Level.WARNING, "Could not find ThinPool {0} (which should conatin DN {1}) , defaulting tiering relocation to '3'", new Object[]{dn.getThinPoolID(), dn.getDn()});
                }
            }
            catch (WBEMException e) {
                mLogger.log(Level.SEVERE, "Error finding ThinPool {0} (which should conatin DN {1}) , defaulting tiering relocation to '3'", new Object[]{dn.getThinPoolID(), dn.getDn()});
            }
        }
        return ret;
    }

    private void getVirtualVolumeData(RMIObjectMapping device, DeviceNumber dn, ArrayList<CIMProperty<?>> props) throws WBEMException {
        short[] sArray;
        VirtualLDEV vDN;
        try {
            vDN = VirtualLDEV.find(device.getRMIObject(), dn.getDNAsString());
        }
        catch (Throwable e) {
            if (e instanceof WBEMException) {
                throw e;
            }
            throw new WBEMException(1, "Unexpected exception getting volume data for " + dn, null, e);
        }
        props.add(new CIMProperty("VirtualModel", CIMDataType.STRING_T, (Object)(null == vDN ? "HM800" : vDN.getVModelName()), false));
        props.add(new CIMProperty("VirtualSN", CIMDataType.STRING_T, (Object)(null == vDN ? dn.getSerialNumber() : Long.toString(vDN.getvSerialNum())), false));
        if (null == vDN) {
            short[] sArray2 = new short[3];
            sArray2[0] = dn.getLdkc();
            sArray2[1] = dn.getCu();
            sArray = sArray2;
            sArray2[2] = dn.getLdev();
        } else {
            sArray = BaseDeviceNumber.getDevIdStringValues(vDN.getVirtLDEVInfo().getDNAsString());
        }
        short[] vals = sArray;
        props.add(new CIMProperty("VirtualLDKC", CIMDataType.UINT16_T, (Object)new UnsignedInteger16((int)vals[0]), false));
        props.add(new CIMProperty("VirtualCU", CIMDataType.UINT16_T, (Object)new UnsignedInteger16((int)vals[1]), false));
        props.add(new CIMProperty("VirtualLDEV", CIMDataType.UINT16_T, (Object)new UnsignedInteger16((int)vals[2]), false));
        String volName = StorageVolumeInstrumentation.getStorageVolumeName(dn, vDN);
        props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)volName, false));
        props.add(new CIMProperty("OtherIdentifyingInfo", CIMDataType.STRING_ARRAY_T, (Object)ProviderLibs.getOtherIdentifyingInfo(dn, vDN, volName), false));
        props.add(new CIMProperty("IdentifyingDescriptions", CIMDataType.STRING_ARRAY_T, (Object)ProviderLibs.getIdentifyingDescriptions(dn), false));
    }

    private String getVolumeLabel(DeviceNumber dn) {
        String ret = null;
        try {
            LDevNickname nickName = LDevNickname.find(dn);
            if (nickName != null) {
                ret = nickName.getNickname();
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Error trying to get LDEV Label: " + (Object)((Object)e), e);
        }
        return ret;
    }

    @Override
    public void modifyInstance(CIMInstance modifiedInst, String[] propertyList) throws WBEMException {
        RMIObjectMapping device;
        String propName;
        String strDevID = null;
        if (null != propertyList && 1 != propertyList.length) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)modifiedInst.getObjectPath(), (String)"Can only modify ElementName", (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
        }
        String string = propName = null == propertyList ? null : propertyList[0];
        if (!"ElementName".equalsIgnoreCase(propName)) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)modifiedInst.getObjectPath(), (String)("can not modify " + propName), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
        }
        try {
            CIMObjectPath curOp = modifiedInst.getObjectPath();
            device = ProviderLibs.getManagedDeviceFromObjectPath(curOp, "InstanceID");
            strDevID = (String)curOp.getKeyValue("DeviceID");
        }
        catch (WBEMException we) {
            mLogger.log(Level.SEVERE, we.getMessage(), we);
            device = null;
        }
        if (null != device && null != strDevID) {
            DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
            if (dn != null) {
                CIMInstance currentInst;
                try {
                    currentInst = this.generateInstance(modifiedInst.getObjectPath(), propertyList, dn);
                }
                catch (Throwable t) {
                    if (t instanceof WBEMException) {
                        throw (WBEMException)t;
                    }
                    throw new WBEMException(1, "Error generating instance for modification", null, t);
                }
                ProviderLibs.modifyElementName(currentInst, modifiedInst, dn, mHandle.getProperty("javax.wbem.provider.Principal"), modifiedInst.getObjectPath().getHost(), "HITACHI_AffectedJobElementStorageVolume", "HITACHI_StorageCSOwningJobElement");
            }
        } else {
            throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)modifiedInst.getObjectPath(), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_StorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_StorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StorageVolume AND SourceInstance.OperationalStatus <> PreviousInstance.OperationalStatus".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StorageVolume AND SourceInstance.CIM_StorageVolume::OperationalStatus <> PreviousInstance.CIM_StorageVolume::OperationalStatus".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_StorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_StorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_StorageVolume".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LDEV, this, null);
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LDEVNICKNAME, this.getNicknameListener(), null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.LDEV, this, null);
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.LDEVNICKNAME, this.getNicknameListener(), null);
        }
    }

    private class NicknameChanged
    implements CacheUpdateNotifier {
        private NicknameChanged() {
        }

        @Override
        public <T extends Serializable> void cacheItemAdded(T pObj) {
        }

        @Override
        public <T extends Serializable> void cacheItemDeleted(T pObj) {
        }

        @Override
        public <T extends Serializable> void cacheItemModified(T pObj) {
            if (StorageVolumeInstrumentation.this.isListening()) {
                LDevNickname nick = (LDevNickname)pObj;
                try {
                    DeviceNumber dn = this.getDNFromNickname(nick);
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageVolume", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance newInst = StorageVolumeInstrumentation.this.generateInstance(op, null, dn);
                    CIMProperty[] oldLabel = new CIMProperty[]{new CIMProperty("Label", CIMDataType.STRING_T, (Object)nick.getNickname(), false)};
                    CIMInstance prevInst = newInst.deriveInstance(oldLabel);
                    if (newInst != null) {
                        IndicationHelper helper = new IndicationHelper(BaseInstrumentation.mHandle);
                        CIMInstance indication = helper.createInstModificationInstance(newInst, prevInst);
                        BaseInstrumentation.mHandle.deliverEvent(indication, null);
                    }
                }
                catch (Throwable t) {
                    BaseInstrumentation.mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageVolume modified indication instance", t);
                }
            }
        }

        private DeviceNumber getDNFromNickname(LDevNickname nick) throws WBEMException {
            DeviceNumber dn = null;
            String serialNumber = nick.getSerialNumber();
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
            if (null == device) {
                throw new WBEMException(1, "Could not get RMIMapping for device with serial number: " + serialNumber);
            }
            try {
                dn = DeviceNumber.find(nick.getDeviceNumber(), device.getRMIObject());
                if (dn == null) {
                    BaseInstrumentation.mLogger.severe("Unable to find a volume that with Device ID: " + nick.getDeviceNumber());
                }
            }
            catch (Throwable t) {
                BaseInstrumentation.mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageVolume modified indication instance", t);
            }
            return dn;
        }
    }
}

