/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public final class ThinProvisioningPoolAllocatedFromStoragePoolInstrumentation
extends BaseAssocInstrumentation {
    protected ThinProvisioningPoolAllocatedFromStoragePoolInstrumentation() {
        super("HITACHI_ThinProvisioningPoolAllocatedFromStoragePool", "HITACHI_StoragePool", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolInstrumentation"), "HITACHI_ThinProvisioningPool", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningPoolInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ThinProvisioningPoolAllocatedFromStoragePool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    Hashtable<Short, CIMObjectPath> poolObject = new Hashtable<Short, CIMObjectPath>();
                    Hashtable<Short, ThinPool> thinPoolObject = new Hashtable<Short, ThinPool>();
                    ArrayList<Short> poolIDs = new ArrayList<Short>();
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        CIMProperty instID = objectName.getKey("InstanceID");
                        if (instID != null) {
                            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                            String val = (String)instID.getValue();
                            if (val != null && val.length() > 0) {
                                ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), false, val);
                                if (cag != null) {
                                    this.getThinProvisioningDataFromCAG(objectName, poolIDs, poolObject, thinPoolObject, cag.getContainedDNs());
                                } else {
                                    mLogger.severe("Can not find CAG: " + objectName);
                                }
                            } else {
                                mLogger.severe("InstanceID property doesn't have a value: " + objectName);
                            }
                        } else {
                            mLogger.severe("ObjectPath doesn't have aInstanceID property: " + objectName);
                        }
                    }
                    this.returnAssocElementByThinPool(objectName, isObjectPath, poolIDs, thinPoolObject, iter, propertyList);
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    this.getThinPoolCags(iter, objectName, isObjectPath, propertyList, false);
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                ThinPool tp;
                Hashtable<Short, CIMObjectPath> poolObject = new Hashtable<Short, CIMObjectPath>();
                Hashtable<Short, ThinPool> thinPoolObject = new Hashtable<Short, ThinPool>();
                ArrayList<Short> poolIDs = new ArrayList<Short>();
                CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
                ThinPool.getThinPools(device.getRMIObject(), callback, (short)-1);
                LinkedList<ThinPool> tps = callback.getReturnValue();
                callback = null;
                while (null != (tp = tps.poll())) {
                    CIMObjectPath tpOP = this.getReference2Instrumentation().generateObjectPath(op, tp);
                    this.getThinPoolCags(deviceIter, tpOP, isObjectPath, propertyList, true);
                }
                this.returnRefElementByThinPool(op, isObjectPath, poolIDs, poolObject, thinPoolObject, deviceIter, propertyList);
                deviceIter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath opObjectName, String[] propList, Object ... o) throws Exception {
        if (null == o || o.length < 2) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_INSTANCE_ILLEGAL_ARGUMENT + " " + "HITACHI_ThinProvisioningPoolAllocatedFromStoragePool");
        }
        ThinPool tp = (ThinPool)o[1];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
        CIMInstance tpInst = this.getReference2Instrumentation().generateInstance(opObjectName, null, tp);
        CIMObjectPath opAssoc = this.generateObjectPath(opObjectName, o[0], tpInst.getObjectPath());
        CIMObjectPath poolOP = (CIMObjectPath)o[0];
        CIMProperty poolInstID = poolOP.getKey("InstanceID");
        String poolInstIDVal = (String)poolInstID.getValue();
        Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(poolInstIDVal);
        int poolFB4 = rets[0];
        int poolAG = rets[1];
        poolOP = null;
        poolInstID = null;
        poolInstIDVal = null;
        rets = null;
        UnsignedInteger64 value = ProviderConstants.UINT64_ZED;
        BigInteger spaceConsumed = BigInteger.ZERO;
        Set<String> ldevs = tp.getContainingLDEVs();
        for (String ldev : ldevs) {
            DeviceNumber dn = DeviceNumber.find(ldev, device.getRMIObject());
            int dnAG = ChassisArrayGroup.makeArrayGroup(dn.getFb4(), dn.getPg(), dn.getVdev(), true);
            if (dnAG != poolAG || dn.getFb4() != poolFB4) continue;
            spaceConsumed = spaceConsumed.add(BigInteger.valueOf(dn.getNumOfBytes()));
        }
        value = new UnsignedInteger64(spaceConsumed);
        CIMProperty[] keys = opAssoc.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], new CIMProperty("SpaceConsumed", CIMDataType.UINT64_T, (Object)value, false)};
        return new CIMInstance(opAssoc, props).filterProperties(propList);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opStoragePool;
            String pnReference1 = this.getReference1PropertyName();
            CIMObjectPath cIMObjectPath = opStoragePool = opObjectName.getKey(pnReference1) != null ? (CIMObjectPath)opObjectName.getKey(pnReference1).getValue() : null;
            if (this.getReference1Instrumentation().instanceExists(opStoragePool)) {
                ThinPool tp;
                CIMObjectPath opThinPool;
                String pnReference2 = this.getReference2PropertyName();
                CIMObjectPath cIMObjectPath2 = opThinPool = opObjectName.getKey(pnReference2) != null ? (CIMObjectPath)opObjectName.getKey(pnReference2).getValue() : null;
                if (this.getReference2Instrumentation().instanceExists(opThinPool) && (tp = ProviderLibs.getThinPool(opThinPool)) != null) {
                    CIMInstance instReturn = this.generateInstance(opObjectName, propertyList, opStoragePool, tp);
                    return instReturn;
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    private Hashtable<String, ChassisArrayGroup> getPoolDataFromDNs(RMIObjectMapping device, Set<String> dns) throws WBEMException {
        Hashtable<String, ChassisArrayGroup> cags = new Hashtable<String, ChassisArrayGroup>();
        for (String dnStr : dns) {
            DeviceNumber dn = DeviceNumber.find(dnStr, device.getRMIObject());
            if (dn != null) {
                int ag = ChassisArrayGroup.makeArrayGroup(dn.getFb4(), dn.getPg(), dn.getVdev(), true);
                ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), null, dn.getFb4(), ag, false);
                if (null != cag) {
                    if (cags.containsKey(cag.getChassisArrayID())) continue;
                    cags.put(cag.getChassisArrayID(), cag);
                    continue;
                }
                mLogger.log(Level.SEVERE, "Could not find ArrayGroup, {0} for ThinPool with DN: {1}", new Object[]{ag, dnStr});
                continue;
            }
            mLogger.severe("Unable to find DN: " + dnStr);
        }
        return cags;
    }

    private void getThinPoolCags(CustomCloseableIterator<?> iter, CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, boolean referenceCall) throws Exception {
        ThinPool tp = ProviderLibs.getThinPool(objectName);
        if (tp != null) {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
            Hashtable<String, ChassisArrayGroup> cags = this.getPoolDataFromDNs(device, tp.getContainingLDEVs());
            if (referenceCall) {
                this.returnRefElementByCAG(iter, objectName, isObjectPath, propertyList, tp, cags);
            } else {
                this.returnAssocElementByCAG(iter, objectName, isObjectPath, propertyList, cags);
            }
        } else {
            mLogger.severe("Unable to find ThinPool(" + objectName + ")");
        }
    }

    private void getThinProvisioningDataFromCAG(CIMObjectPath poolOP, List<Short> poolIDs, Hashtable<Short, CIMObjectPath> poolObject, Hashtable<Short, ThinPool> thinPoolObject, List<BaseDeviceNumber> containedDNs) throws WBEMException {
        if (poolIDs != null && poolObject != null && thinPoolObject != null && containedDNs != null) {
            for (BaseDeviceNumber bdn : containedDNs) {
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(bdn.getSerialNumber());
                DeviceNumber dn = DeviceNumber.find(bdn.getDNAsString(), true, device.getRMIObject());
                if (dn == null || !dn.isVolumeIsPool()) continue;
                ThinPool tp = ThinPool.find(device.getRMIObject(), dn.getSPoolID(), ThinPool.ThinPoolType.AOU);
                if (tp != null) {
                    if (poolIDs.contains(tp.getPoolID())) continue;
                    poolIDs.add(tp.getPoolID());
                    poolObject.put(tp.getPoolID(), poolOP);
                    thinPoolObject.put(tp.getPoolID(), tp);
                    continue;
                }
                mLogger.info("Unable to locate ThinPool(" + dn.getSPoolID() + "), probably a QS");
            }
        } else {
            mLogger.info("A required parameter was null\npoolIDs = " + poolIDs + ", poolObject = " + poolObject + ", thinPoolObject = " + containedDNs);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ThinProvisioningPoolAllocatedFromStoragePool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    Hashtable<Short, CIMObjectPath> poolObject = new Hashtable<Short, CIMObjectPath>();
                    Hashtable<Short, ThinPool> thinPoolObject = new Hashtable<Short, ThinPool>();
                    ArrayList<Short> poolIDs = new ArrayList<Short>();
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        CIMProperty instID = objectName.getKey("InstanceID");
                        if (instID != null) {
                            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                            String val = (String)instID.getValue();
                            if (val != null && val.length() > 0) {
                                ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), false, val);
                                if (cag != null) {
                                    this.getThinProvisioningDataFromCAG(objectName, poolIDs, poolObject, thinPoolObject, cag.getContainedDNs());
                                } else {
                                    mLogger.severe("Can not find CAG: " + objectName);
                                }
                            } else {
                                mLogger.severe("InstanceID property doesn't have a value: " + objectName);
                            }
                        } else {
                            mLogger.severe("ObjectPath doesn't have aInstanceID property: " + objectName);
                        }
                    }
                    this.returnRefElementByThinPool(objectName, isObjectPath, poolIDs, poolObject, thinPoolObject, iter, propertyList);
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    this.getThinPoolCags(iter, objectName, isObjectPath, propertyList, true);
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }

    private void returnAssocElementByCAG(CustomCloseableIterator<?> iter, CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, Hashtable<String, ChassisArrayGroup> cags) throws Exception {
        Enumeration<ChassisArrayGroup> theList = cags.elements();
        while (theList.hasMoreElements()) {
            ChassisArrayGroup cag = theList.nextElement();
            if (isObjectPath) {
                CIMObjectPath poolOP = this.getReference1Instrumentation().generateObjectPath(objectName, cag);
                iter.add(poolOP);
                continue;
            }
            CIMInstance inst = this.getReference1Instrumentation().generateInstance(objectName, propertyList, cag);
            iter.add(inst);
        }
    }

    private void returnAssocElementByThinPool(CIMObjectPath objectName, boolean isObjectPath, ArrayList<Short> poolIDs, Hashtable<Short, ThinPool> thinPoolObject, CustomCloseableIterator<?> iter, String[] propertyList) throws Exception {
        for (Short poolID : poolIDs) {
            ThinPool tp = thinPoolObject.get(poolID);
            if (isObjectPath) {
                CIMObjectPath tpOP = this.getReference2Instrumentation().generateObjectPath(objectName, tp);
                iter.add(tpOP);
                continue;
            }
            CIMInstance inst = this.getReference2Instrumentation().generateInstance(objectName, propertyList, tp);
            iter.add(inst);
        }
    }

    private void returnRefElementByCAG(CustomCloseableIterator<?> iter, CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, ThinPool tp, Hashtable<String, ChassisArrayGroup> cags) throws Exception {
        Enumeration<ChassisArrayGroup> theList = cags.elements();
        while (theList.hasMoreElements()) {
            ChassisArrayGroup cag = theList.nextElement();
            CIMObjectPath poolOP = this.getReference1Instrumentation().generateObjectPath(objectName, cag);
            if (isObjectPath) {
                objectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                iter.add(this.generateObjectPath(objectName, poolOP, objectName));
                continue;
            }
            iter.add(this.generateInstance(objectName, propertyList, poolOP, tp));
        }
    }

    private void returnRefElementByThinPool(CIMObjectPath op, boolean isObjectPath, ArrayList<Short> poolIDs, Hashtable<Short, CIMObjectPath> poolObject, Hashtable<Short, ThinPool> thinPoolObject, CustomCloseableIterator<?> iter, String[] propertyList) throws Exception {
        for (Short poolID : poolIDs) {
            CIMObjectPath poolOP = poolObject.get(poolID);
            poolOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), poolOP.getNamespace(), poolOP.getObjectName(), poolOP.getKeys(), "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            ThinPool tp = thinPoolObject.get(poolID);
            if (isObjectPath) {
                CIMObjectPath tpOP = this.getReference2Instrumentation().generateObjectPath(op, tp);
                iter.add(this.generateObjectPath(op, poolOP, tpOP));
                continue;
            }
            iter.add(this.generateInstance(op, propertyList, poolOP, tp));
        }
    }
}

