/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class ThinProvisioningVolumeBasedOnThinProvisioningVolumeCompositeExtentInstrumentation
extends BaseAssocInstrumentation {
    private static final String CCN_HITACHI_THINPROVISIONINGVOLUMEBASEDONTHINPROVISIONINGVOLUMECOMPOSITEEXTENT = "HITACHI_ThinProvisioningVolumeBasedOnThinProvisioningVolumeCompositeExtent";
    private static final String CCN_ANTECEDENT = "HITACHI_ThinProvisioningVolumeCompositeExtent";

    protected ThinProvisioningVolumeBasedOnThinProvisioningVolumeCompositeExtentInstrumentation() {
        super(CCN_HITACHI_THINPROVISIONINGVOLUMEBASEDONTHINPROVISIONINGVOLUMECOMPOSITEEXTENT, CCN_ANTECEDENT, "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningVolumeCompositeExtentInstrumentation"), "HITACHI_StorageVolume", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && CCN_HITACHI_THINPROVISIONINGVOLUMEBASEDONTHINPROVISIONINGVOLUMECOMPOSITEEXTENT.equalsIgnoreCase(assocName.getObjectName())) {
                RMIObjectMapping mapping;
                String deviceID;
                DeviceNumber deviceNum;
                CIMProperty deviceIDProp;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMProperty deviceIDProp2;
                    if ((!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) && null != (deviceIDProp2 = objectName.getKey("DeviceID"))) {
                        String deviceID2 = (String)deviceIDProp2.getValue();
                        RMIObjectMapping mapping2 = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        DeviceNumber deviceNum2 = DeviceNumber.find(deviceID2, true, mapping2.getRMIObject());
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, deviceNum2));
                        } else {
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, deviceNum2));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && (!shouldTestInst || this.getReference2Instrumentation().instanceExists(objectName)) && null != (deviceIDProp = objectName.getKey("DeviceID")) && null != (deviceNum = DeviceNumber.find(deviceID = (String)deviceIDProp.getValue(), true, (mapping = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName")).getRMIObject())) && deviceNum.isAOUVol() && deviceNum.getSLUSEElmCount() != 0) {
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, deviceNum));
                    } else if (null != deviceNum) {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, deviceNum));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                Callback<DeviceNumber> callback = new Callback<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList);
                DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1, true, VolumeTypeEnum.AOUVOL);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        if (null == o || o.length < 1) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_INSTANCE_ILLEGAL_ARGUMENT + " " + CCN_HITACHI_THINPROVISIONINGVOLUMEBASEDONTHINPROVISIONINGVOLUMECOMPOSITEEXTENT);
        }
        DeviceNumber deviceNum = (DeviceNumber)o[0];
        CIMObjectPath opCompLDev = this.getReference1Instrumentation().generateObjectPath(op, deviceNum);
        CIMObjectPath opSV = this.getReference2Instrumentation().generateObjectPath(op, deviceNum);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(this.getReference1PropertyName(), new CIMDataType(this.getReference1ClassName()), (Object)opCompLDev, true), new CIMProperty(this.getReference2PropertyName(), new CIMDataType(this.getReference2ClassName()), (Object)opSV, true)};
        CIMObjectPath assocOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), CCN_HITACHI_THINPROVISIONINGVOLUMEBASEDONTHINPROVISIONINGVOLUMECOMPOSITEEXTENT, keys, op.getXmlSchemaName());
        CIMProperty<?>[] props = this.getProperties(keys);
        CIMInstance ci = new CIMInstance(assocOP, props);
        return ci.filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        if (null == o || o.length < 1) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_OBJECTPATH_ILLEGAL_ARGUMENT + " " + CCN_HITACHI_THINPROVISIONINGVOLUMEBASEDONTHINPROVISIONINGVOLUMECOMPOSITEEXTENT);
        }
        DeviceNumber deviceNum = (DeviceNumber)o[0];
        CIMObjectPath opCompLDev = this.getReference1Instrumentation().generateObjectPath(op, deviceNum);
        CIMObjectPath opSV = this.getReference2Instrumentation().generateObjectPath(op, deviceNum);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(this.getReference1PropertyName(), new CIMDataType(this.getReference1ClassName()), (Object)opCompLDev, true), new CIMProperty(this.getReference2PropertyName(), new CIMDataType(this.getReference2ClassName()), (Object)opSV, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), CCN_HITACHI_THINPROVISIONINGVOLUMEBASEDONTHINPROVISIONINGVOLUMECOMPOSITEEXTENT, keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opSV;
            CIMObjectPath opTPVolCompExt = op.getKey(this.getReference1PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference1PropertyName()).getValue() : null;
            CIMObjectPath cIMObjectPath = opSV = op.getKey(this.getReference2PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference2PropertyName()).getValue() : null;
            if (null != opTPVolCompExt && null != opSV) {
                String svDeviceID;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opTPVolCompExt, "SystemName");
                CIMProperty propTPVolCompExtDeviceID = opTPVolCompExt.getKey("DeviceID");
                String tpVolCompExtDeviceID = null != propTPVolCompExtDeviceID ? (String)propTPVolCompExtDeviceID.getValue() : null;
                CIMProperty propSVDeviceID = opSV.getKey("DeviceID");
                String string = svDeviceID = null != propSVDeviceID ? (String)propSVDeviceID.getValue() : null;
                if (null != svDeviceID && svDeviceID.equals(tpVolCompExtDeviceID)) {
                    DeviceNumber deviceNum;
                    String svSysNameKeyVal;
                    String tpVolCompExtCCName = null != opTPVolCompExt.getKey("CreationClassName") ? (String)opTPVolCompExt.getKey("CreationClassName").getValue() : null;
                    String tpVolCompExtSCCName = null != opTPVolCompExt.getKey("SystemCreationClassName") ? (String)opTPVolCompExt.getKey("SystemCreationClassName").getValue() : null;
                    String tpVolCompExtSysNameKeyVal = null != opTPVolCompExt.getKey("SystemName") ? (String)opTPVolCompExt.getKey("SystemName").getValue() : null;
                    String svCCName = null != opSV.getKey("CreationClassName") ? (String)opSV.getKey("CreationClassName").getValue() : null;
                    String svSCCName = null != opSV.getKey("SystemCreationClassName") ? (String)opSV.getKey("SystemCreationClassName").getValue() : null;
                    String string2 = svSysNameKeyVal = null != opSV.getKey("SystemName") ? (String)opSV.getKey("SystemName").getValue() : null;
                    if (null != tpVolCompExtCCName && tpVolCompExtCCName.equals(this.getReference1ClassName()) && null != tpVolCompExtSCCName && tpVolCompExtSCCName.equals("HITACHI_StorageSystem") && null != tpVolCompExtSysNameKeyVal && tpVolCompExtSysNameKeyVal.equals(svSysNameKeyVal) && null != svCCName && svCCName.equals(this.getReference2ClassName()) && null != svSCCName && svSCCName.equals("HITACHI_StorageSystem") && (deviceNum = DeviceNumber.find(tpVolCompExtDeviceID, true, device.getRMIObject())) != null) {
                        return this.generateInstance(op, propertyList, deviceNum);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    protected CIMProperty<?>[] getProperties(CIMProperty<?>[] keys) throws WBEMException {
        ArrayList props = new ArrayList();
        ProviderLibs.addKeysToProperties(keys, props);
        props.add(new CIMProperty("StartingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("EndingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("OrderIndex", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        return props.toArray(new CIMProperty[props.size()]);
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != objectName && null != objectName.getKey("DeviceID") ? (String)objectName.getKey("DeviceID").getValue() : null;
        hTable.put("DeviceID", name);
        return hTable;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && CCN_HITACHI_THINPROVISIONINGVOLUMEBASEDONTHINPROVISIONINGVOLUMECOMPOSITEEXTENT.equalsIgnoreCase(assocName.getObjectName())) {
                RMIObjectMapping mapping;
                DeviceNumber deviceNum;
                CIMProperty deviceIDProp;
                String deviceID = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName) && null != (deviceIDProp = objectName.getKey("DeviceID"))) {
                        deviceID = (String)deviceIDProp.getValue();
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && null != (deviceIDProp = objectName.getKey("DeviceID"))) {
                    deviceID = (String)deviceIDProp.getValue();
                }
                if (null != deviceID && null != (deviceNum = DeviceNumber.find(deviceID, true, (mapping = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName")).getRMIObject())) && deviceNum.isAOUVol() && deviceNum.getSLUSEElmCount() != 0) {
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, deviceNum));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, deviceNum));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private class Callback<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected Callback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) {
                ret = false;
            } else {
                try {
                    E dn = item;
                    if (this.mIsObjectPath) {
                        this.mIter.add(ThinProvisioningVolumeBasedOnThinProvisioningVolumeCompositeExtentInstrumentation.this.generateObjectPath(this.mOP, dn));
                    } else {
                        this.mIter.add(ThinProvisioningVolumeBasedOnThinProvisioningVolumeCompositeExtentInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, dn));
                    }
                }
                catch (Exception e) {
                    WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return ret;
        }
    }
}

