/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class TierServiceInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devs = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devs) {
                CIMObjectPath objPath;
                if (null != refInfo) {
                    objPath = this.generateObjectPath(op, device.getRMIObject());
                    refInfo.addReference(iter, objPath);
                    continue;
                }
                if (isObjectPath) {
                    objPath = this.generateObjectPath(op, device.getRMIObject());
                    iter.add(objPath);
                    continue;
                }
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            Throwable t = null != th.getCause() ? th.getCause() : th;
            WBEMException we = new WBEMException(1, t.toString(), null, t);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        try {
            CIMObjectPath retOP = this.generateObjectPath(op, o);
            CIMProperty[] keys = retOP.getKeys();
            String tierServiceStr = "HITACHI_TierService".substring("HITACHI_".length());
            CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("PrimaryOwnerName", CIMDataType.STRING_T, null, false), new CIMProperty("PrimaryOwnerContact", CIMDataType.STRING_T, null, false), new CIMProperty("StartMode", CIMDataType.STRING_T, (Object)"Automatic", false), new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("OtherEnabledState", CIMDataType.STRING_T, null, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("TimeOfLastStateChange", CIMDataType.DATETIME_T, null, false), new CIMProperty("AvailableRequestedStates", CIMDataType.UINT16_ARRAY_T, null, false), new CIMProperty("TransitioningToState", CIMDataType.UINT16_T, null, false), new CIMProperty("InstallDate", CIMDataType.DATETIME_T, null, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"OK"}, false), new CIMProperty("Status", CIMDataType.STRING_T, null, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, null, false), new CIMProperty("CommunicationStatus", CIMDataType.UINT16_T, null, false), new CIMProperty("DetailedStatus", CIMDataType.UINT16_T, null, false), new CIMProperty("OperatingStatus", CIMDataType.UINT16_T, null, false), new CIMProperty("PrimaryStatus", CIMDataType.UINT16_T, null, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)tierServiceStr, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)tierServiceStr, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)tierServiceStr, false)};
            return new CIMInstance(retOP, props).filterProperties(propList);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            Throwable t = null != th.getCause() ? th.getCause() : th;
            throw new WBEMException(1, t.toString(), null, t);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_TierService");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        try {
            String ssName = rmiObj.getSMISMappingContainer().getStorageSystemName();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)ssName, true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_TierService", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)"HITACHI_TierService".substring("HITACHI_".length()), true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_TierService", keys, op.getXmlSchemaName());
        }
        catch (Throwable th) {
            Throwable t = null != th.getCause() ? th.getCause() : th;
            throw new WBEMException(1, t.toString(), null, t);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            CIMObjectPath real = this.generateObjectPath(op, device.getRMIObject());
            if (null != real && real.equalsModelPath(op)) {
                CIMInstance ret = this.generateInstance(op, propertyList, device.getRMIObject());
                return ret;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            Throwable t = null != th.getCause() ? th.getCause() : th;
            throw new WBEMException(1, t.toString(), null, t);
        }
        throw new WBEMException(6, op != null ? op.toString() : null);
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret;
        if ("CreateStorageTier".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else if ("DeleteStorageTier".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else if ("AddToStorageTier".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else if ("RemoveFromStorageTier".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else if ("CreateTierDomain".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else if ("DeleteTierDomain".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else if ("ModifyStorageTierDomainAssociation".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else if ("GetStorageTierCandidateObjects".equalsIgnoreCase(pMethodName)) {
            ret = ProviderConstants.UINT32_ONE;
        } else {
            throw new WBEMException(17, "HITACHI_TierService doesn't know the method: " + pMethodName);
        }
        return ret;
    }
}

