/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.DeleteVolume;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class CoalescedDeleteVolumeJob
extends Coalescable {
    @Override
    protected void executeJob(List<AbstractJobImpl> abstractItems) throws WBEMException {
        this.setAbstractJobImpls(abstractItems);
        this.createConcreteJobFromAbstractJobs();
        mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
        this.markServerJobStarted(0);
        ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>(abstractItems.size());
        try {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber());
            RMIObjectCache rmiObj = device.getRMIObject();
            SanRemote sanRemote = rmiObj.keyValueAPI_GetSanRemote();
            SanData generalParam = null;
            SanRequest sanRequest = null;
            SanList ldevs = null;
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            this.getHitachiJobServiceObject().updateServerJobPercentComplete(25, true);
            this.updateChildrenJobPercentComplete(10);
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof DeleteVolume)) {
                    String msg = "AbstractJob should contain  a DeleteVolume instance but it contains a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                if (null == sanRequest && null == (ldevs = (sanRequest = sanRemote.newRequest(generalParam = rmiObj.keyValueAPI_GetStorageInfoParam(sanRemote, childJob.getClientIP()), "MNTdeleteLdevs")).newList("Ldevs"))) {
                    throw new SanDataException("SanRequest.newList failed");
                }
                DeviceNumber dn = (DeviceNumber)childJob.getActionItem();
                SanObject ldev = ldevs.addObj();
                ldev.putIntArray("Id", new int[]{dn.getLdkc(), dn.getCu(), dn.getLdev()});
                ChassisArrayGroup cag = ChassisArrayGroup.find(rmiObj, dn.getFb4(), dn.getPg(), false);
                if (null == cag) {
                    String msg = String.format("Unable to find PG for dn %s", dn);
                    mLogger.log(Level.SEVERE, "{0}, skipping deletion", msg);
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                ldev.putIntArray("ParityGroupId", new int[]{cag.getFb4(), cag.getPg()});
                affectedElements.add(childJob.getJob().getCIMObjectPath(childJob.getOwningElement()));
            }
            this.getHitachiJobServiceObject().updateServerJobPercentComplete(66, true);
            this.updateChildrenJobPercentComplete(50);
            this.setAffectedElements(affectedElements);
            SanResponse response = this.invoke(rmiObj, generalParam, sanRequest, sanRemote);
            if (0 != response.errorCode()) {
                int[] message = response.getIntArray("MessageId");
                String msg = String.format("Deleting LDEVs failed with code %d, message %d-%d", response.errorCode(), message[0], message[1]);
                throw new WBEMException(msg);
            }
            this.markServerJobDone();
        }
        catch (SanDataException | SanRmiException | NotBoundException | RemoteException e) {
            Throwable t = e;
            while (null != t.getCause()) {
                t = t.getCause();
            }
            throw new WBEMException(1, "Error getting key/value objects", null, t);
        }
    }
}

