/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.Protect;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_ODGDgetGuardRetention;
import sanproject.common.Robj_interface_ODGDsetGuardRetention;
import sanproject.common.Robj_interface_ODGDsetGuardRetention_IN;
import sanproject.serverux.data.SANRmiException;

public class CoalescedProtectJob
extends Coalescable {
    @Override
    protected void executeJob(List<AbstractJobImpl> abstractItems) throws WBEMException {
        this.setAbstractJobImpls(abstractItems);
        this.createConcreteJobFromAbstractJobs();
        mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
        this.markServerJobStarted(0);
        Robj_interface_ODGDsetGuardRetention_IN data = this.getSetGuardRetentionObject();
        LinkedList<Robj_interface_ODGDsetGuardRetention_IN> rmiAction = new LinkedList<Robj_interface_ODGDsetGuardRetention_IN>();
        rmiAction.add(data);
        this.setItemQueue(rmiAction);
        this.apply2();
    }

    private Robj_interface_ODGDsetGuardRetention_IN getSetGuardRetentionObject() throws WBEMException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
        Robj_interface_ODGDsetGuardRetention_IN setGuardRetentionIN = null;
        int numChildren = this.getAbstractJobImpls().size();
        Robj_interface_ODGDsetGuardRetention[] setGuardRetentionArray = new Robj_interface_ODGDsetGuardRetention[numChildren];
        try {
            ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>(numChildren);
            setGuardRetentionIN = (Robj_interface_ODGDsetGuardRetention_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.ODGDSETGUARDRETENTION_IN);
            int x = 0;
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof Protect)) {
                    String msg = "Expected all elements of the list to contain instances of Protect, however this instance was a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                childJob.setResultIndex(x);
                Protect.ProtectData data = (Protect.ProtectData)childJob.getActionItem();
                short ldev = data.getDn().getLdev();
                Robj_interface_ODGDgetGuardRetention guardRetention = ProviderLibs.getGuardRetention(rmiObj, data.getDn());
                byte[] guardVals = guardRetention.getByGuard();
                int[] retentionTerms = guardRetention.getIRetentionTerm();
                Robj_interface_ODGDsetGuardRetention setGuardRetention = (Robj_interface_ODGDsetGuardRetention)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.ODGDSETGUARDRETENTION);
                byte[] previousGuardVals = new byte[256];
                int[] previousRetentionTerms = new int[256];
                byte[] changedGuardVals = new byte[256];
                int[] changedRetentionTerms = new int[256];
                changedGuardVals[ldev] = data.getGuardVals();
                changedRetentionTerms[ldev] = data.getRetentionTerms();
                previousGuardVals[ldev] = guardVals[ldev];
                previousRetentionTerms[ldev] = retentionTerms[ldev];
                setGuardRetention.setCUIndex(data.getDn().getLdkc(), data.getDn().getCu());
                setGuardRetention.setGuard(previousGuardVals, changedGuardVals);
                setGuardRetention.setRetentionTerm(previousRetentionTerms, changedRetentionTerms);
                setGuardRetentionArray[x] = setGuardRetention;
                affectedElements.add(childJob.getJob().getCIMObjectPath(this.getOwningElement()));
                ++x;
            }
            this.setAffectedElements(affectedElements);
        }
        catch (RemoteException re) {
            mLogger.log(Level.SEVERE, re.toString(), re);
            throw new WBEMException(1, re.toString(), null, (Throwable)re);
        }
        catch (SANRmiException sre) {
            mLogger.log(Level.SEVERE, sre.getErrMsgEn(), sre);
            throw new WBEMException(1, sre.getErrMsgEn(), null, (Throwable)sre);
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, t.toString(), t);
            throw new WBEMException(1, t.toString(), null, t);
        }
        setGuardRetentionIN.setParameter(setGuardRetentionArray.length, setGuardRetentionArray);
        return setGuardRetentionIN;
    }
}

