/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedCreateModifyNormalVolume;
import com.hitachi.smi.jobs.CreateModifyVolumeBase;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.util.ArrayList;
import java.util.List;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class CreateModifyNormalVolume
extends CreateModifyVolumeBase
implements HitachiJobCallbackIF {
    private final List<CreateNormalVolumeData> vols;

    public CreateModifyNormalVolume(String pUserName, String pIPAddress, CIMObjectPath owningService, CIMObjectPath inPool, ChassisArrayGroup cag, long size, int emulationType, String elementName) throws WBEMException {
        this(pUserName, pIPAddress, owningService, inPool, cag, size, emulationType, new String[]{elementName});
    }

    public CreateModifyNormalVolume(String pUserName, String pIPAddress, CIMObjectPath owningService, CIMObjectPath inPool, ChassisArrayGroup cag, long size, int emulationType, String[] elementNames) throws WBEMException {
        super(cag.getSerialNumber(), "CreateOrModifyElementFromStoragePool", pUserName, pIPAddress, owningService, new String[]{"HITACHI_AffectedJobElementStorageVolume", "HITACHI_AffectedJobElementStoragePool"}, "HITACHI_StorageCSOwningJobElement", null);
        this.vols = new ArrayList<CreateNormalVolumeData>(elementNames.length);
        for (String elementName : elementNames) {
            CreateNormalVolumeData data = new CreateNormalVolumeData(inPool, cag, size, emulationType, elementName);
            this.vols.add(data);
        }
        this.setActionItem(this.vols);
        this.setCallback(this);
    }

    @Override
    protected List<CreateNormalVolumeData> getActionItem() {
        return this.vols;
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedCreateModifyNormalVolume();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted(5);
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    private void processResult() {
        WBEMException we = null;
        try {
            ArrayList<CIMObjectPath> affectedElems = new ArrayList<CIMObjectPath>(this.vols.size() + 1);
            BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation");
            for (CreateNormalVolumeData volData : this.vols) {
                if (affectedElems.isEmpty()) {
                    affectedElems.add(volData.inPool);
                }
                DeviceNumber createdDN = this.verifyVolumeCreated(volData);
                affectedElems.add(bi.generateObjectPath(this.getOwningElement(), createdDN));
            }
            this.setAffectedElements(affectedElems.toArray(new CIMObjectPath[affectedElems.size()]));
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateModifyNormalVolume ");
        builder.append(this.getActionItem());
        return builder.toString();
    }

    class CreateNormalVolumeData
    implements CreateModifyVolumeBase.CreateVolumeDataBase {
        private final CIMObjectPath inPool;
        private final ChassisArrayGroup cag;
        private final long size;
        private final int emulationType;
        private final String elementName;
        private String createdDNStr;

        public CreateNormalVolumeData(CIMObjectPath inPool, ChassisArrayGroup cag, long size, int emulationType, String elementName) {
            this.inPool = inPool;
            this.cag = cag;
            this.emulationType = emulationType;
            this.size = size;
            this.elementName = elementName;
            this.createdDNStr = null;
        }

        protected ChassisArrayGroup getChassisArrayGroup() {
            return this.cag;
        }

        @Override
        public String getCreatedDNStr() {
            return this.createdDNStr;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        protected int getEmulationType() {
            return this.emulationType;
        }

        protected CIMObjectPath getInPool() {
            return this.inPool;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        protected void setCreatedDNStr(String createdDNStr) {
            this.createdDNStr = createdDNStr;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CreateNormalVolumeData [cag=");
            builder.append(this.cag);
            builder.append(", elementName=");
            builder.append(this.elementName);
            builder.append(", size=");
            builder.append(this.size);
            builder.append(", emulationType=");
            builder.append(this.emulationType);
            builder.append(", inPool=");
            builder.append(this.inPool);
            builder.append("]");
            return builder.toString();
        }
    }
}

