/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ProviderProperties;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import com.ws.wbem.provider.jobservice.JobImplementation;
import com.ws.wbem.provider.jobservice.JobService;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

class HitachiJobService {
    private static final String CONCRETE_JOB = "ConcreteJob";
    private final JobService jobService = new JobService();
    private CIM_ConcreteJob theJob;
    private long jobStartedAt;
    private String methodName = "UNKNOWN";
    private String userName = "UNKNOWN";
    private String clientIP = "UNKNOWN";
    private String deviceSerial;
    private CIMObjectPath opDummy = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ConcreteJob", null);

    protected void createConcreteJobInServer(String pDeviceSerial, String pMethodName, String pUserName, String pClientIP, String pHost, String pPort, JobImplementation pImpl) throws WBEMException {
        this.deviceSerial = pDeviceSerial;
        this.methodName = pMethodName;
        this.userName = pUserName;
        this.clientIP = pClientIP;
        this.theJob = new CIM_ConcreteJob("HITACHI_ConcreteJob", this.genJobInstanceID());
        this.theJob.setName(CONCRETE_JOB);
        this.theJob.setJobState(CIM_ConcreteJob.JobState.New);
        this.theJob.setOperationalStatus(new UnsignedInteger16[]{CIM_ConcreteJob.OPSTATUS_DORMANT});
        this.theJob.setJobStatus("WAITING");
        this.theJob.setPercentComplete(ProviderConstants.UINT16_ZED);
        this.jobStartedAt = System.currentTimeMillis();
        CIMDateTimeAbsolute now = new CIMDateTimeAbsolute();
        this.theJob.setTimeSubmitted((CIMDateTime)now);
        this.theJob.setStartTime((CIMDateTime)now);
        this.theJob.setJobRunTimes(ProviderConstants.UINT32_ONE);
        this.theJob.setTimeBeforeRemoval(this.getJobDeleteInterval());
        this.theJob.setDeleteOnCompletion(Boolean.valueOf(false));
        this.theJob.setHealthState(ProviderConstants.UINT16_FIVE);
        this.theJob.setCaption(CONCRETE_JOB);
        this.theJob.setElementName(CONCRETE_JOB);
        this.theJob.setOwner(this.clientIP);
        this.theJob.setDescription(this.methodName + " on " + pDeviceSerial);
        this.registerImplementation("HITACHI_ConcreteJob", null, pImpl);
        this.opDummy = new CIMObjectPath(null, pHost, pPort, ProviderLibs.getImplementationNamespace(), "", null);
        this.createJob(this.getJob().getCIMInstance(this.opDummy));
    }

    public void createJob(CIMInstance cimInstance) throws WBEMException {
        this.getJobService().createJob(cimInstance);
    }

    private String genJobInstanceID() {
        return UUID.randomUUID().toString();
    }

    protected String getClientIP() {
        return this.clientIP;
    }

    public String getDeviceSerialNumber() {
        return this.deviceSerial;
    }

    public CIM_ConcreteJob getJob() {
        return this.theJob;
    }

    private CIMDateTime getJobDeleteInterval() {
        long numMinutes = ProviderProperties.getJobWaitB4Delete();
        CIMDateTimeInterval ret = new CIMDateTimeInterval(numMinutes * 60L * 1000L);
        return ret;
    }

    public String getJobID() {
        String ret = this.getJob() != null ? this.getJob().getInstanceID() : "";
        return ret;
    }

    protected JobService getJobService() {
        return this.jobService;
    }

    protected String getMethodName() {
        return this.methodName;
    }

    protected String getUserName() {
        return this.userName;
    }

    protected void markServerjobComplete() {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        try {
            if (this.getJob() != null) {
                this.jobService.completeJob(this.getJob().getCIMInstance(this.opDummy));
                logger.log(Level.INFO, "Job, {0}, completed", this.getJobID());
            }
        }
        catch (WBEMException we) {
            logger.log(Level.SEVERE, "Exception marking server job complete: " + we.getMessage(), we);
        }
    }

    protected void markServerJobDone(Throwable error) {
        if (this.getJob() != null) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            this.updateServerJobPercentComplete(100, false);
            if (error == null) {
                this.updateElapsedTime();
                this.getJob().setErrorCode(ProviderConstants.UINT16_ZED);
                this.getJob().setJobState(CIM_ConcreteJob.JobState.Completed);
                this.getJob().setJobStatus("COMPLETED");
                this.getJob().setOperationalStatus(new UnsignedInteger16[]{CIM_ConcreteJob.OPSTATUS_OK, CIM_ConcreteJob.OPSTATUS_COMPLETED});
            } else {
                error = error.getCause() == null ? error : error.getCause();
                this.getJob().setErrorCode(ProviderConstants.UINT16_ONE);
                this.getJob().setErrorDescription(null != error.getLocalizedMessage() ? error.getLocalizedMessage() : error.toString());
                this.getJob().setJobState(CIM_ConcreteJob.JobState.Exception);
                this.getJob().setJobStatus("FAILED");
                this.getJob().setOperationalStatus(new UnsignedInteger16[]{CIM_ConcreteJob.OPSTATUS_ERROR, CIM_ConcreteJob.OPSTATUS_COMPLETED});
                logger.log(Level.SEVERE, "Exception completing job " + this.getJobID(), error);
            }
            try {
                this.jobService.updateJob(this.getJob().getCIMInstance(this.opDummy));
            }
            catch (WBEMException e) {
                logger.log(Level.SEVERE, "Exception updating concrete job " + this.getJobID(), e);
            }
        }
    }

    protected void markServerJobStarted() {
        this.markServerJobStarted(50);
    }

    protected void markServerJobStarted(int percent) {
        if (this.getJob() != null) {
            this.getJob().setOperationalStatus(new UnsignedInteger16[]{CIM_ConcreteJob.OPSTATUS_OK});
            this.updateServerJobPercentComplete(percent, false);
            this.getJob().setJobState(CIM_ConcreteJob.JobState.Running);
            this.getJob().setJobStatus("PROCESSING");
            try {
                this.jobService.updateJob(this.getJob().getCIMInstance(this.opDummy));
            }
            catch (WBEMException e) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.log(Level.SEVERE, "Exception updating concrete job: " + this.getJobID(), e);
            }
        }
    }

    public void registerImplementation(String ccnConcreteJob, String ccnMethodResult, JobImplementation newJob) {
        this.getJobService().registerImplementation(ccnConcreteJob, ccnMethodResult, newJob);
    }

    void updateElapsedTime() {
        if (this.getJob() != null) {
            long now = System.currentTimeMillis();
            long elapsed = now - this.jobStartedAt;
            this.getJob().setElapsedTime((CIMDateTime)new CIMDateTimeInterval(elapsed));
            try {
                this.updateJob(this.getJob().getCIMInstance(this.opDummy));
            }
            catch (WBEMException e) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.log(Level.WARNING, "Failed to update ConcreteJob(" + this.getJobID() + " elapsed time", e);
            }
        }
    }

    public void updateJob(CIMInstance cimInstance) throws WBEMException {
        this.getJobService().updateJob(cimInstance);
    }

    protected void updateServerJobPercentComplete(int newPercent, boolean updateJob) {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        if (this.getJob() != null) {
            UnsignedInteger16 curPercent = this.getJob().getPercentComplete();
            if (null == curPercent || curPercent.intValue() <= newPercent) {
                this.getJob().setPercentComplete(new UnsignedInteger16(newPercent));
                if (updateJob) {
                    try {
                        this.jobService.updateJob(this.getJob().getCIMInstance(this.opDummy));
                        logger.info("updated job " + this.getJobID() + " percent complete to: " + newPercent);
                    }
                    catch (WBEMException e) {
                        logger.log(Level.INFO, "Exception updating % complete in concrete job" + this.getJobID(), e);
                    }
                } else {
                    logger.log(Level.FINE, "Job {0} percent complete set to: {1}% but did not update server (expected).", new Object[]{this.getJobID(), newPercent});
                }
            } else {
                String msg = String.format("Job %s is %s%% complete, new setting, %s%%, is less", this.getJobID(), curPercent, newPercent);
                logger.log(Level.WARNING, msg, new Exception("Stacktrace for incorrect % setting"));
            }
        }
        this.updateElapsedTime();
    }
}

