/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.providers;

import com.hitachi.jserver.soma.SMISSecurityLib;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IndicationHandler;
import com.hitachi.smi.common.IndicationManager;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.DaemonThreadFactory;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.IndicationProvider;
import javax.wbem.provider.ProviderHandle;
import javax.wbem.provider.PullInstanceProvider;

public abstract class BaseProvider
implements PullInstanceProvider,
IndicationProvider,
IndicationHandler {
    private static int DEFAULT_NUM_THREADS = 10;
    private static int NUM_THREADS;
    private static String QUERY;
    protected static volatile ProviderHandle mHandle;
    protected static Logger mLogger;
    protected static volatile ExecutorService exec;
    private BaseInstrumentation mInstrumentation;
    protected IndicationManager mIndicationManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BaseProvider() {
        ExecutorService t = exec;
        if (t == null) {
            Class<BaseProvider> clazz = BaseProvider.class;
            // MONITORENTER : com.hitachi.smi.providers.BaseProvider.class
            t = exec;
            if (t == null) {
                try {
                    NUM_THREADS = Integer.parseInt(ProviderProperties.getProviderProperties().getProperty("Threads", Integer.toString(DEFAULT_NUM_THREADS)));
                }
                catch (Exception e) {
                    NUM_THREADS = DEFAULT_NUM_THREADS;
                }
                t = exec = new ThreadPoolExecutor(1, NUM_THREADS, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory());
                ((ThreadPoolExecutor)t).allowCoreThreadTimeOut(true);
            }
            // MONITOREXIT : clazz
        }
        this.mIndicationManager = new IndicationManager(this);
    }

    public void activateFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
        mLogger.log(Level.FINE, "activatefilter{0}Filter: {1}{0}Destination: {2}{0}Subscription: {3}", new Object[]{System.lineSeparator(), filter.getObjectPath(), listenerDestination.getObjectPath(), subscription.getObjectPath()});
        String query = (String)filter.getPropertyValue(QUERY);
        int numActivations = this.mIndicationManager.activate(query);
        if (1 == numActivations) {
            this.getInstrumentation().processIndicationFilter(query, true);
        }
    }

    private void authorize(boolean isSet) throws WBEMException {
        String userName = mHandle.getProperty("javax.wbem.provider.Principal");
        if (null != userName) {
            if (isSet) {
                SMISSecurityLib.authorizeWrite(userName);
            } else {
                SMISSecurityLib.authorizeRead(userName);
            }
        }
    }

    public void authorizeFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
        this.authorizeFilter(filter, listenerDestination, subscription, null, null, null);
    }

    protected void authorizeFilter(CIMInstance filter, CIMInstance listener, CIMInstance subscription, String[] subFilters, CIMObjectPath[] classPath, String[] eventType) throws WBEMException {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "activatefilter{0}Filter: {1}{0}Destination: {2}{0}Subscription: {3}{0}Subfilters: {4}{0}Classpath: {5}{0}EventType: {6}", new Object[]{System.lineSeparator(), filter.getObjectPath(), listener.getObjectPath(), subscription.getObjectPath(), Arrays.toString(subFilters), Arrays.toString(classPath), Arrays.toString(eventType)});
        }
        this.mIndicationManager.authorize((String)filter.getPropertyValue(QUERY));
    }

    protected void authorizeGet() throws WBEMException {
        this.authorize(false);
    }

    protected void authorizeSet() throws WBEMException {
        this.authorize(true);
    }

    public void close() throws WBEMException {
        if (this.mInstrumentation != null) {
            mLogger.log(Level.FINE, "close() {0}", this.mInstrumentation.getClass().getName());
        }
        if (null != exec && !exec.isShutdown()) {
            exec.shutdownNow();
            exec = null;
        }
    }

    public CIMObjectPath createInstance(CIMInstance ci) throws WBEMException {
        this.authorizeSet();
        mLogger.log(Level.FINE, "createInstance: {0}", ci.getObjectPath());
        throw new WBEMException(7);
    }

    public void deActivateFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
        mLogger.log(Level.FINE, "deactivateFilter:{0}Filter: {1}{0}Listener: {2}{0}Subscription: {3}", new Object[]{filter.getObjectPath(), listenerDestination, subscription});
        String query = (String)filter.getPropertyValue(QUERY);
        int numActivations = this.mIndicationManager.deactivate(query);
        if (0 == numActivations) {
            this.getInstrumentation().processIndicationFilter(query, false);
        }
    }

    public void deleteInstance(CIMObjectPath op) throws WBEMException {
        this.authorizeSet();
        mLogger.log(Level.FINE, "deleteInstance: {0}", op);
        this.getInstrumentation().deleteInstance(op);
    }

    protected abstract void enumerate(CustomCloseableIterator<?> var1, CIMObjectPath var2, String[] var3, String var4, String var5, boolean var6, boolean var7) throws WBEMException;

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath pOp, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        this.authorizeGet();
        mLogger.info("enumerateInstances (pull): " + pOp + "Parameters:" + " filterQueryLanguage " + filterQueryLanguage + ", filterQuery " + filterQuery + ", propertyList: " + Arrays.toString(propertyList));
        CloseableIterator<?> retVal = this.threadedEnumerate(pOp, propertyList, filterQueryLanguage, filterQuery, continueOnError, false);
        mLogger.info("enumerateInstances (pull) completed: " + pOp);
        return retVal;
    }

    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath op, String query, String ql) throws WBEMException {
        this.authorizeGet();
        mLogger.log(Level.FINE, "execQuery() not supported");
        throw new WBEMException(7);
    }

    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        mLogger.log(Level.FINE, "getInstance on {0}, with propertylisty {1}", new Object[]{op, propertyList});
        return this.getInstrumentation().getInstance(op, propertyList);
    }

    protected BaseInstrumentation getInstrumentation() throws WBEMException {
        return this.mInstrumentation;
    }

    @Override
    public String[] getSupportedIndications() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void initialize(ProviderHandle handle) throws WBEMException {
        mLogger.log(Level.FINE, "Initialize {0}" + this.getClass().getSimpleName());
        ProviderHandle t = mHandle;
        if (null == t) {
            Class<BaseInstrumentation> clazz = BaseInstrumentation.class;
            // MONITORENTER : com.hitachi.smi.instrumentation.BaseInstrumentation.class
            t = mHandle;
            if (null == t) {
                t = mHandle = handle;
            }
            // MONITOREXIT : clazz
        }
        if (null == this.mInstrumentation) return;
        this.getInstrumentation().initialize(handle);
    }

    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inputArguments, CIMArgument<?>[] outputArguments) throws WBEMException {
        throw new WBEMException(17, methodName + " is not unknown.");
    }

    public void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        this.authorizeSet();
        mLogger.log(Level.FINE, "modifyInstance on {0}, propertylist {1}", new Object[]{ci.getObjectPath(), propertyList});
        this.getInstrumentation().modifyInstance(ci, propertyList);
    }

    protected void setInstrumentation(BaseInstrumentation pInstrumentation) {
        this.mInstrumentation = pInstrumentation;
    }

    protected CloseableIterator<?> threadedEnumerate(final CIMObjectPath op, final String[] propertyList, final String filterQueryLanguage, final String filterQuery, final boolean continueOnError, final boolean isObjectPaths) throws WBEMException {
        final CustomCloseableIterator iter = new CustomCloseableIterator();
        Runnable enumerateThread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread thisThread = Thread.currentThread();
                String clzName = BaseProvider.this.getClass().getName();
                thisThread.setName("enumerateThread - " + clzName);
                try {
                    BaseProvider.this.enumerate(iter, op, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPaths);
                }
                catch (WBEMException we) {
                    if (iter.getWBEMException() == null) {
                        iter.setException(we);
                        iter.close();
                    }
                    mLogger.log(Level.SEVERE, "WBEMException in threaded enumerate", we);
                }
                catch (Throwable t) {
                    while (null != t.getCause()) {
                        t = t.getCause();
                    }
                    WBEMException we = WBEMException.class.isInstance(t) ? (WBEMException)t : new WBEMException(1, "Exception " + t, null, t);
                    if (null != iter) {
                        iter.setException(we);
                        iter.close();
                    }
                    mLogger.log(Level.SEVERE, "Exception in threaded enumerate", t);
                }
                finally {
                    thisThread.setName("enumerateThread - idle");
                }
            }
        };
        if (null != enumerateThread) {
            exec.execute(enumerateThread);
        }
        return iter;
    }

    static {
        QUERY = "Query";
        mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
        exec = null;
    }
}

