/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.providers;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.providers.BaseAssociatorProvider;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;

public class ObjectManagerConformsToProfile
extends BaseAssociatorProvider {
    private static final String CPV_REGISTEREDNAME = "Server:1.5.0";

    @Override
    protected void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != objectName && null != assocName && "HITACHI_ObjectManagerConformsToProfile".equalsIgnoreCase(assocName.getObjectName())) {
                if ("HITACHI_RegisteredProfile".equalsIgnoreCase(objectName.getObjectName()) && (null == role || role.equalsIgnoreCase("ConformantStandard")) && (null == resultRole || resultRole.equalsIgnoreCase("ManagedElement"))) {
                    if (this.isValidServer(objectName)) {
                        CIMInstance ci = this.getObjectManagerIntance(objectName);
                        if (isObjectPath) {
                            iter.add(ci.getObjectPath());
                        } else {
                            iter.add(ci.filterProperties(propertyList));
                        }
                    }
                } else if ("HITACHI_ObjectManager".equalsIgnoreCase(objectName.getObjectName()) && (null == role || role.equalsIgnoreCase("ManagedElement")) && (null == resultRole || resultRole.equalsIgnoreCase("ConformantStandard")) && this.isValidObjectManagerOP(objectName)) {
                    ArrayList<CIMInstance> l = this.getServerProfileInstances(objectName);
                    for (CIMInstance ciProfile : l) {
                        if (isObjectPath) {
                            iter.add(ciProfile.getObjectPath());
                            continue;
                        }
                        iter.add(ciProfile.filterProperties(propertyList));
                    }
                }
            }
        }
        catch (Exception e) {
            WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private CIMInstance createInstance(CIMInstance omInstance, CIMInstance pInstance) throws WBEMException {
        try {
            CIMObjectPath omOP = omInstance.getObjectPath();
            CIMObjectPath pOP = pInstance.getObjectPath();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("ManagedElement", new CIMDataType("HITACHI_ObjectManager"), (Object)omOP, true), new CIMProperty("ConformantStandard", new CIMDataType("HITACHI_RegisteredProfile"), (Object)pOP, true)};
            CIMObjectPath opInstance = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), "HITACHI_ObjectManagerConformsToProfile", keys);
            return new CIMInstance(opInstance, keys);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    protected void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            CIMInstance omInstance = this.getObjectManagerIntance(op);
            ArrayList<CIMInstance> rpList = this.getServerProfileInstances(op);
            for (CIMInstance i : rpList) {
                CIMInstance ci = this.createInstance(omInstance, i);
                if (isObjectPath) {
                    iter.add(ci.getObjectPath());
                    continue;
                }
                iter.add(ci.filterProperties(propertyList));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        CIMInstance ciProfile;
        CIMObjectPath opOM;
        CIMProperty cpOM;
        CIMObjectPath opProfile;
        this.authorizeGet();
        CIMProperty cpProfile = op.getKey("ConformantStandard");
        if (null != cpProfile && null != (opProfile = (CIMObjectPath)cpProfile.getValue()) && this.isValidServer(opProfile) && null != (cpOM = op.getKey("ManagedElement")) && this.isValidObjectManagerOP(opOM = (CIMObjectPath)cpOM.getValue()) && null != (ciProfile = mHandle.getInstance(opProfile, null))) {
            CIMInstance ci = this.createInstance(this.getObjectManagerIntance(opOM), ciProfile);
            return ci.filterProperties(propertyList);
        }
        throw new WBEMException(6);
    }

    CIMInstance getObjectManagerIntance(CIMObjectPath op) {
        try {
            CIMObjectPath opObjectManager = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ObjectManager", null);
            CloseableIterator iter = mHandle.enumerateInstances(opObjectManager, null);
            if (iter.hasNext()) {
                return (CIMInstance)iter.next();
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    ArrayList<CIMInstance> getServerProfileInstances(CIMObjectPath op) {
        try {
            String namespace = op.getNamespace();
            String nspace = "".equals(namespace) || null == namespace ? ProviderLibs.getInteropNamespace() : namespace;
            CIMObjectPath rpObjectPath = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), nspace, "HITACHI_RegisteredProfile", null);
            CloseableIterator iter = mHandle.enumerateInstances(rpObjectPath, null);
            ArrayList<CIMInstance> list = new ArrayList<CIMInstance>();
            while (iter.hasNext()) {
                UnsignedInteger16 rOrg;
                CIMInstance ci = (CIMInstance)iter.next();
                String name = (String)ci.getPropertyValue("RegisteredName");
                if (!CPV_REGISTEREDNAME.startsWith(name) || !new UnsignedInteger16(11).equals((Object)(rOrg = (UnsignedInteger16)ci.getPropertyValue("RegisteredOrganization")))) continue;
                list.add(ci);
            }
            return list;
        }
        catch (Throwable e) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.log(Level.SEVERE, "Unexpected: " + e.toString(), e);
            return null;
        }
    }

    boolean isValidObjectManagerOP(CIMObjectPath op) {
        CIMInstance i;
        return null != op && op.equalsModelPath((i = this.getObjectManagerIntance(op)).getObjectPath());
    }

    boolean isValidServer(CIMObjectPath op) {
        ArrayList<CIMInstance> l;
        if (null != op && null != (l = this.getServerProfileInstances(op))) {
            for (CIMInstance i : l) {
                if (null == i || !op.equalsModelPath(i.getObjectPath())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ObjectManagerConformsToProfile".equalsIgnoreCase(assocName.getObjectName())) {
                String oName = objectName.getObjectName();
                if ("HITACHI_RegisteredProfile".equalsIgnoreCase(oName) && (null == role || "ConformantStandard".equalsIgnoreCase(role))) {
                    if (this.isValidServer(objectName)) {
                        CIMInstance ciProfile = mHandle.getInstance(objectName, null);
                        CIMInstance omInstance = this.getObjectManagerIntance(objectName);
                        CIMInstance ci = this.createInstance(omInstance, ciProfile);
                        if (isObjectPath) {
                            iter.add(ci.getObjectPath());
                        } else {
                            iter.add(ci.filterProperties(propertyList));
                        }
                    }
                } else if ("HITACHI_ObjectManager".equalsIgnoreCase(oName) && (null == role || "ManagedElement".equalsIgnoreCase(role)) && this.isValidObjectManagerOP(objectName)) {
                    ArrayList<CIMInstance> l = this.getServerProfileInstances(objectName);
                    for (CIMInstance ciProfile : l) {
                        CIMInstance ci = this.createInstance(this.getObjectManagerIntance(objectName), ciProfile);
                        if (isObjectPath) {
                            iter.add(ci.getObjectPath());
                            continue;
                        }
                        iter.add(ci.filterProperties(propertyList));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }
}

