/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.store.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginItem;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginManager;
import sanproject.session.server.store.SJsessionInfo;
import sanproject.session.server.store.SJsessionInfoApp;
import sanproject.session.server.store.SJsessionStoreHouse;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;

public class SJsessionTimeoutTask {
    private final String LOG_FUNCTION = "SessionServer";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    Timer sessionTimeoutTimer = null;
    private SJcLoggerInterface logger = SJsessionServerUty.getLogger();

    public void startTask() {
        String LOG_SUBTITLE = "startTask";
        this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "Start.");
        int val = SJcEnvUty.getProperty2int("SN_SESSION_TIMEOUT_POLLING", 5);
        this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "SN_SESSION_TIMEOUT_POLLING:" + val);
        if (val <= 0) {
            this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "SN_SESSION_TIMEOUT_POLLING:" + val + " changed default.");
            val = 5;
        }
        long reAuthPeriod = val * 1000;
        this.sessionTimeoutTimer = new Timer();
        SessionTimeoutTask sessionTimeoutTimerTask = new SessionTimeoutTask();
        this.sessionTimeoutTimer.schedule((TimerTask)sessionTimeoutTimerTask, reAuthPeriod, reAuthPeriod);
        this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "End.");
    }

    public void finish() {
        String LOG_SUBTITLE = "finish";
        this.logger.info("SessionServer", this.LOG_TITLE, "finish", "Start.");
        if (this.sessionTimeoutTimer != null) {
            this.sessionTimeoutTimer.cancel();
            this.sessionTimeoutTimer = null;
        }
        this.logger.info("SessionServer", this.LOG_TITLE, "finish", "End.");
    }

    class SessionTimeoutTask
    extends TimerTask {
        SessionTimeoutTask() {
        }

        public void run() {
            String LOG_SUBTITLE = "SessionTimeoutTask";
            SJsessionTimeoutTask.this.logger.trace("SessionServer", SJsessionTimeoutTask.this.LOG_TITLE, "SessionTimeoutTask", "Start.");
            SJsessionStoreHouse store = SJsessionStoreHouse.getInstance();
            List<SJsessionInfo> sessionList = store.getSessionInfoList();
            for (SJsessionInfo session : sessionList) {
                String gsid = session.getGlobalSessionID();
                HashMap<String, SJsessionInfoApp> loginMap = new HashMap<String, SJsessionInfoApp>(session.getLoginInfoMap());
                ArrayList<String> appIDList = new ArrayList<String>();
                for (String appID : loginMap.keySet()) {
                    SJsessionInfoApp loginInfo = loginMap.get(appID);
                    SJsessionReceivePluginItem plugin = SJsessionReceivePluginManager.getPluginItem(appID);
                    long timeout = plugin.getSessionTimeout();
                    if (timeout == -1L) continue;
                    timeout *= 1000L;
                    long lastTimeSec = loginInfo.getAliveLastTime();
                    long nowTimeSec = SJsessionServerUty.getSystemTime();
                    if (nowTimeSec - lastTimeSec < 0L) {
                        SJsessionTimeoutTask.this.logger.warn("SessionServer", SJsessionTimeoutTask.this.LOG_TITLE, "SessionTimeoutTask", "System progress time went around. nowTime:" + nowTimeSec + " lastTime:" + lastTimeSec);
                    }
                    if (nowTimeSec - lastTimeSec <= timeout && nowTimeSec - lastTimeSec >= 0L) continue;
                    SJsessionTimeoutTask.this.logger.info("SessionServer", SJsessionTimeoutTask.this.LOG_TITLE, "SessionTimeoutTask", "Session Timeout. GSID:" + gsid + " APPID:" + appID);
                    appIDList.add(appID);
                }
                for (String appID : appIDList) {
                    try {
                        store.removeLoginInfo(gsid, appID);
                    }
                    catch (SJsessionException e) {}
                }
            }
            SJsessionTimeoutTask.this.logger.trace("SessionServer", SJsessionTimeoutTask.this.LOG_TITLE, "SessionTimeoutTask", "End.");
        }
    }
}

