/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.unique;

import java.util.ArrayList;
import java.util.Arrays;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.unique.SJsessionFileLockUty;
import sanproject.session.server.unique.SJsessionUniqueIDInfo;
import sanproject.session.server.unique.SJsessionUniqueIDManager;
import sanproject.session.server.unique.SJsessionUniqueIDTableInfo;
import sanproject.session.server.unique.SJsessionUniqueIDUtility;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionUniqueIDLockUty {
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionUniqueIDLockUty.class.getSimpleName();
    private static final boolean LOCK_FLG = true;
    private static final boolean UNLOCK_FLG = false;
    private static final Object syncObject = SJsessionUniqueIDManager.syncObject;

    private SJsessionUniqueIDLockUty() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        String LOG_SUBTITLE = "initialize";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start.");
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
                return;
            }
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            for (int conid = 1; conid <= 706; ++conid) {
                info.assignLockFlg(conid, false);
            }
            try {
                SJsessionUniqueIDUtility.writeFile(info);
            }
            catch (SJcException e) {
                logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "UniqueIDTable cannot be written.", e);
            }
            finally {
                flockUty.releaseFile();
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockID(int conid) {
        String LOG_SUBTITLE = "lockID";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start.CUID:" + conid);
        if (conid < 1 || conid > 706) {
            logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Invalid parameter.");
            return;
        }
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
                return;
            }
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            info.assignLockFlg(conid, true);
            try {
                SJsessionUniqueIDUtility.writeFile(info);
            }
            catch (SJcException e) {
                logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "UniqueIDTable cannot be written.", e);
            }
            finally {
                flockUty.releaseFile();
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockID(int[] conid) {
        String LOG_SUBTITLE = "lockID";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "lockID", "Start. CUIDs:" + Arrays.toString(conid));
        if (conid == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "lockID", "Invalid parameters.");
            return;
        }
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                logger.info(LOG_FUNCTION, LOG_TITLE, "lockID", "End.");
                return;
            }
            SJsessionUniqueIDInfo idInfo = SJsessionUniqueIDUtility.readFile();
            for (int i = 0; i < conid.length; ++i) {
                idInfo.assignLockFlg(conid[i], true);
            }
            try {
                SJsessionUniqueIDUtility.writeFile(idInfo);
            }
            catch (SJcException e) {
                logger.error(LOG_FUNCTION, LOG_TITLE, "lockID", "UniqueIDTable cannot be written.", e);
            }
            finally {
                flockUty.releaseFile();
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "lockID", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockID(int[] conid) {
        String LOG_SUBTITLE = "unlockID";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Start. CUIDs:" + Arrays.toString(conid));
        if (conid == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Invalid parameter.");
            return;
        }
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
                return;
            }
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            for (int i = 0; i < conid.length; ++i) {
                info.assignLockFlg(conid[i], false);
            }
            try {
                SJsessionUniqueIDUtility.writeFile(info);
            }
            catch (SJcException e) {
                logger.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "UniqueIDTable cannot be written.", e);
            }
            finally {
                flockUty.releaseFile();
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Boolean> getLockState() {
        String LOG_SUBTITLE = "getLockState";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "getLockState", "Start.");
        ArrayList<Boolean> lockState = new ArrayList<Boolean>();
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty fLockUty = new SJsessionFileLockUty();
            try {
                fLockUty.lockFile();
                SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
                SJsessionUniqueIDTableInfo[] table = info.getIDTable();
                for (int i = 0; i < table.length; ++i) {
                    lockState.add(table[i].getLockFlg());
                }
                fLockUty.releaseFile();
            }
            catch (Exception e) {
                ArrayList<Boolean> arrayList;
                try {
                    logger.info(LOG_FUNCTION, LOG_TITLE, "getLockState", "End.");
                    arrayList = lockState;
                    fLockUty.releaseFile();
                }
                catch (Throwable throwable) {
                    fLockUty.releaseFile();
                    throw throwable;
                }
                return arrayList;
            }
            logger.info(LOG_FUNCTION, LOG_TITLE, "getLockState", "End.");
            return lockState;
        }
    }
}

