/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.unique;

import java.util.HashMap;
import java.util.List;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.common.exception.SJsessionParameterException;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.exception.SJsessionConnectionIDException;
import sanproject.session.server.unique.SJsessionFileLockUty;
import sanproject.session.server.unique.SJsessionUniqueIDInfo;
import sanproject.session.server.unique.SJsessionUniqueIDTableInfo;
import sanproject.session.server.unique.SJsessionUniqueIDUtility;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionUniqueIDManager {
    private static final long serialVersionUID = 1L;
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionUniqueIDManager.class.getSimpleName();
    private String appID = null;
    private int minID = -1;
    private int maxID = -1;
    private SJcLoggerInterface logger = null;
    private static HashMap<String, SJsessionUniqueIDManager> manager = new HashMap();
    public static Object syncObject = new Object();

    private SJsessionUniqueIDManager() {
    }

    private SJsessionUniqueIDManager(String appID, int minID, int maxID) {
        this.appID = appID;
        this.minID = minID;
        this.maxID = maxID;
        this.logger = SJsessionServerUty.getLogger();
    }

    public static SJsessionUniqueIDManager createIDManager(String appID, int minID, int maxID) {
        String LOG_SUBTITLE = "createIDManager";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "createIDManager", "Start. APP:" + appID + " minID:" + minID + " maxID:" + maxID);
        SJsessionUniqueIDManager ret = null;
        if (appID == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "createIDManager", "invalid parameter. appID is null");
            return ret;
        }
        if (minID == -1 || maxID == -1) {
            logger.info(LOG_FUNCTION, LOG_TITLE, "createIDManager", "SJsessionUniqueIDManager is not created. APP:" + appID);
            return ret;
        }
        ret = manager.get(appID);
        if (ret == null) {
            ret = new SJsessionUniqueIDManager(appID, minID, maxID);
            manager.put(appID, ret);
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "createIDManager", "End.");
        return ret;
    }

    public static SJsessionUniqueIDManager getIDManager(String appID) {
        String LOG_SUBTITLE = "getIDManager";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, "getIDManager", "Start.");
        SJsessionUniqueIDManager ret = null;
        if (appID == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "getIDManager", "invalid parameter. appID is null");
            return ret;
        }
        ret = manager.get(appID);
        logger.trace(LOG_FUNCTION, LOG_TITLE, "getIDManager", "End.");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID(String gsid) throws SJsessionException {
        String LOG_SUBTITLE = "getID";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "getID", "Start. APP:" + this.appID + " GSID:" + gsid);
        int conid = 0;
        if (gsid == null) {
            this.logger.error(LOG_FUNCTION, LOG_TITLE, "getID", "invalid parameter. GSID is null");
            throw new SJsessionParameterException("107001");
        }
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                throw new SJsessionConnectionIDException("107000", conid);
            }
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            conid = info.getUnAssignedID(this.appID, this.maxID, this.minID);
            if (conid == 0) {
                this.logger.error(LOG_FUNCTION, LOG_TITLE, "getID", "cannot find unassigned connection unique ID.");
                conid = info.getNextID(this.appID, this.maxID, this.minID);
                info.updatePosMap(this.appID, conid);
                try {
                    SJsessionUniqueIDUtility.writeFile(info);
                }
                catch (SJcException ex) {
                }
                finally {
                    flockUty.releaseFile();
                }
                throw new SJsessionConnectionIDException("107000", conid);
            }
            info.updatePosMap(this.appID, conid);
            info.assignGSID(conid, gsid);
            try {
                SJsessionUniqueIDUtility.writeFile(info);
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "getID", "file write. APP: " + this.appID + " GSID:" + gsid + " CUID:" + conid);
            }
            catch (SJcException ex) {
                this.logger.error(LOG_FUNCTION, LOG_TITLE, "getID", "UniqueIDTable cannot be written.");
                throw new SJsessionConnectionIDException(ex, "107000", conid);
            }
            finally {
                flockUty.releaseFile();
            }
        }
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "getID", "End.");
        return conid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reAssignment(int conUniqID, String gsid) throws SJsessionException {
        String LOG_SUBTITLE = "reAssignment";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "reAssignment", "Start. CUID:" + conUniqID + " GSID:" + gsid);
        if (conUniqID < this.minID || conUniqID > this.maxID || gsid == null) {
            this.logger.error(LOG_FUNCTION, LOG_TITLE, "reAssignment", "invalid parameter. CUID:" + conUniqID + " GSID:" + gsid);
            throw new SJsessionParameterException("107001");
        }
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                throw new SJsessionConnectionIDException(ex, "107000", conUniqID);
            }
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            info.assignGSID(conUniqID, gsid);
            try {
                SJsessionUniqueIDUtility.writeFile(info);
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "reAssignment", "file write. APP:" + this.appID + " GSID:" + gsid + " CUID:" + conUniqID);
            }
            catch (SJcException ex) {
                this.logger.error(LOG_FUNCTION, LOG_TITLE, "reAssignment", "UniqueIDTable cannot be written.");
                throw new SJsessionConnectionIDException(ex, "107000", conUniqID);
            }
            finally {
                flockUty.releaseFile();
            }
        }
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "reAssignment", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDummyID() {
        String LOG_SUBTITLE = "getDummyID";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "getDummyID", "Start. APP:" + this.appID);
        int conid = 0;
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "getDummyID", "End.");
                return conid;
            }
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            conid = info.getUnAssignedID(this.appID, this.maxID, this.minID);
            if (conid == 0) {
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "getDummyID", "cannot find unassigned id.");
                conid = info.getNextID(this.appID, this.maxID, this.minID);
            }
            info.updatePosMap(this.appID, conid);
            try {
                SJsessionUniqueIDUtility.writeFile(info);
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "getDummyID", "file write. APP:" + this.appID + " Dummy CUID:" + conid);
            }
            catch (SJcException ex) {
                this.logger.error(LOG_FUNCTION, LOG_TITLE, "getDummyID", "UniqueIDTable cannot be written.");
            }
            finally {
                flockUty.releaseFile();
            }
        }
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "getDummyID", "End.");
        return conid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseID(String gsid) throws SJsessionException {
        String LOG_SUBTITLE = "releaseID";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "releaseID", "Start. GSID:" + gsid);
        if (gsid == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "releaseID", "invalid parameter. GSID is null");
            throw new SJsessionParameterException("107001");
        }
        int conid = 0;
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                logger.info(LOG_FUNCTION, LOG_TITLE, "releaseID", "End.");
                return;
            }
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            conid = info.searchIDByGID(gsid);
            if (conid == 0) {
                logger.info(LOG_FUNCTION, LOG_TITLE, "releaseID", "cannot find connection unique ID.");
                logger.info(LOG_FUNCTION, LOG_TITLE, "releaseID", "End.");
                flockUty.releaseFile();
                return;
            }
            info.assignGSID(conid, null);
            try {
                SJsessionUniqueIDUtility.writeFile(info);
                logger.info(LOG_FUNCTION, LOG_TITLE, "releaseID", "file write. GSID:" + gsid + " CUID:" + conid);
            }
            catch (SJcException ex) {
                logger.error(LOG_FUNCTION, LOG_TITLE, "releaseID", "UniqueIDTable cannot be written.");
            }
            finally {
                flockUty.releaseFile();
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "releaseID", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncID(List<String> gsidList) throws SJsessionException {
        String LOG_SUBTITLE = "syncID";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "syncID", "Start.");
        boolean unmatchFlg = false;
        if (gsidList == null) {
            this.logger.error(LOG_FUNCTION, LOG_TITLE, "syncID", "invalid parameter. GSID is null");
            throw new SJsessionParameterException("107001");
        }
        if (this.maxID > 706 || this.minID < 1) {
            this.logger.error(LOG_FUNCTION, LOG_TITLE, "syncID", "invalid connection unique ID. minID:" + this.minID + " maxID:" + this.maxID);
            throw new SJsessionParameterException("107001");
        }
        Object object = syncObject;
        synchronized (object) {
            SJsessionFileLockUty flockUty = new SJsessionFileLockUty();
            try {
                flockUty.lockFile();
            }
            catch (Exception ex) {
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "syncID", "End.");
                return false;
            }
            SJsessionUniqueIDInfo info = SJsessionUniqueIDUtility.readFile();
            SJsessionUniqueIDTableInfo[] table = info.getIDTable();
            for (int i = this.minID - 1; i < this.maxID; ++i) {
                String gsid = table[i].getGrobalID();
                if (gsid == null || gsidList.contains(gsid)) continue;
                table[i].setGrobalID(null);
                unmatchFlg = true;
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "syncID", "Unmatch GSID:" + gsid + " CUID:" + (i + 1));
            }
            try {
                if (unmatchFlg) {
                    SJsessionUniqueIDUtility.writeFile(info);
                }
            }
            catch (SJcException ex) {
                this.logger.error(LOG_FUNCTION, LOG_TITLE, "syncID", "UniqueIDTable cannot be written.");
                unmatchFlg = false;
            }
            finally {
                flockUty.releaseFile();
            }
        }
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "syncID", "End.");
        return unmatchFlg;
    }
}

