/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sanproject.server.data.FTFileData;
import sanproject.server.data.SANRmiException;

public class JwsDownloadPanel
extends JwsCommPanel {
    protected static final int INPUT_NO_ERR = 0;
    protected static final int INPUT_ERR_FILENAME = 16;
    protected static final String REPLACE_TITLE = "Confirm File Replace";
    protected static final String REPLACE_MESSAGE = "Would you like to replace the existing file with this one?";
    private JTextField m_tfdClientFile;
    private JButton m_btnReference;
    private JButton m_btnUpload;
    private JButton m_btnExit;
    protected JwsFTMainCtrl m_clsAppCtrl;
    protected String m_strDownloadPath;
    protected File m_DownloadFile;
    protected JwsProcessDialog m_JwsProcess;
    private Timer m_startTimer = new Timer(1, null);
    protected Timer m_endTimer = new Timer(1, null);

    public JwsDownloadPanel(JwsFTMainCtrl jwsFTMainCtrl) {
        this.m_clsAppCtrl = jwsFTMainCtrl;
        this.buildLayout();
        this.initPanel();
    }

    protected void finalize() throws Throwable {
        this.m_tfdClientFile = null;
        this.m_btnUpload = null;
        this.m_btnExit = null;
    }

    protected void initPanel() {
    }

    protected void buildLayout() {
        Color color = new Color(192, 192, 192);
        this.setLayout(null);
        this.setBackground(color);
        String string = JwsFTMainCtrl.UPLOAD_PANEL_CLIENTFILE_LABEL_TEXT;
        JLabel jLabel = JwsBaseCtrl.getBaseFieldLabel();
        jLabel.setText(string);
        jLabel.setBounds(new Rectangle(10, 45, 200, 30));
        jLabel.setFont(JwsBaseCtrl.m_fntAppBoldFont);
        string = JwsFTMainCtrl.DOWNLOAD_PANEL_CLIENTFILE_FIELD_TEXT;
        this.m_tfdClientFile = new JTextField(string);
        this.m_tfdClientFile.setBounds(new Rectangle(10, 2, 220, 26));
        this.m_tfdClientFile.setFont(JwsBaseCtrl.m_fntAppTextFont);
        this.m_tfdClientFile.setColumns(255);
        this.m_tfdClientFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                JwsDownloadPanel.this.onClientFileChanged(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JwsDownloadPanel.this.onClientFileChanged(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JwsDownloadPanel.this.onClientFileChanged(documentEvent);
            }
        });
        string = JwsFTMainCtrl.UPLOAD_PANEL_REFERENCE_BUTTON_TEXT;
        this.m_btnReference = JwsBaseCtrl.getBaseAppButton();
        this.m_btnReference.setText(string);
        this.m_btnReference.setBounds(new Rectangle(240, 2, 120, 26));
        this.m_btnReference.setFont(JwsBaseCtrl.m_fntAppBoldFont);
        this.m_btnReference.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsDownloadPanel.this.onReference(actionEvent);
            }
        });
        JPanel jPanel = JwsBaseCtrl.getBaseFieldBackPanel();
        jPanel.setBounds(new Rectangle(218, 45, 372, 30));
        jPanel.add(this.m_tfdClientFile);
        jPanel.add(this.m_btnReference);
        this.add(jLabel);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBackground(color);
        jPanel.setBounds(new Rectangle(10, 100, 580, 30));
        string = JwsFTMainCtrl.DOWNLOAD_PANEL_DOWNLOAD_BUTTON_TEXT;
        this.m_btnUpload = JwsBaseCtrl.getBaseAppButton();
        this.m_btnUpload.setText(string);
        this.m_btnUpload.setBounds(new Rectangle(358, 2, 125, 26));
        this.m_btnUpload.setFont(JwsBaseCtrl.m_fntAppBoldFont);
        this.m_btnUpload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsDownloadPanel.this.onDownload(actionEvent);
            }
        });
        jPanel.add(this.m_btnUpload);
        string = JwsFTMainCtrl.UPLOAD_PANEL_EXIT_BUTTON_TEXT;
        this.m_btnExit = JwsBaseCtrl.getBaseAppButton();
        this.m_btnExit.setText(string);
        this.m_btnExit.setBounds(new Rectangle(498, 2, 80, 26));
        this.m_btnExit.setFont(JwsBaseCtrl.m_fntAppBoldFont);
        this.m_btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsDownloadPanel.this.onExit(actionEvent);
            }
        });
        jPanel.add(this.m_btnExit);
        this.add(jPanel);
        this.m_startTimer.setRepeats(false);
        this.m_startTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsDownloadPanel.this.startProcess();
            }
        });
        this.m_endTimer.setRepeats(false);
        this.m_endTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsDownloadPanel.this.endProcess();
            }
        });
        this.setPanelEnabled();
    }

    public void setClientFilePath(String string) {
        this.m_tfdClientFile.setText(string);
    }

    public String getClientFilePath() {
        return new String(this.m_tfdClientFile.getText());
    }

    protected int inputCheck() {
        int n = 0;
        String string = this.getClientFilePath();
        if (string == null || string.equals("")) {
            n |= 0x10;
        }
        return n;
    }

    protected void setPanelEnabled() {
        int n = this.inputCheck();
        if ((n & 0x10) > 0) {
            this.m_btnUpload.setEnabled(false);
        } else {
            this.m_btnUpload.setEnabled(true);
        }
    }

    public void downloadStart() {
        this.m_tfdClientFile.setEnabled(false);
        this.m_btnReference.setEnabled(false);
        this.m_btnUpload.setEnabled(false);
        this.m_btnExit.setEnabled(false);
        this.m_clsAppCtrl.m_frmMainFrame.setEnabled(false);
    }

    public void downloadEnd() {
        this.m_tfdClientFile.setEnabled(true);
        this.m_btnReference.setEnabled(true);
        this.m_btnUpload.setEnabled(true);
        this.m_btnExit.setEnabled(true);
        this.m_clsAppCtrl.m_frmMainFrame.setEnabled(true);
        System.gc();
    }

    public void startProcess() {
        this.m_JwsProcess = new JwsProcessDialog(this.m_clsAppCtrl.m_frmMainFrame, "Download", false);
        this.m_JwsProcess.show();
    }

    public void endProcess() {
        ((Component)this.m_JwsProcess).setVisible(false);
    }

    protected void downloadCheck(String string) throws JwsFtcException {
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        String string2 = null;
        try {
            if (string == null) {
                this.downloadCheckUser();
                string2 = this.getClientFilePath();
            } else {
                string2 = string;
            }
            this.m_strDownloadPath = string2.trim();
            int n2 = this.m_strDownloadPath.length();
            if (n2 >= 4) {
                if (!this.m_strDownloadPath.substring(n2 - 4, n2).equalsIgnoreCase(".spd")) {
                    this.m_strDownloadPath = this.m_strDownloadPath + ".spd";
                }
            } else {
                this.m_strDownloadPath = this.m_strDownloadPath + ".spd";
            }
            this.m_DownloadFile = new File(this.m_strDownloadPath);
            n2 = this.m_strDownloadPath.length();
            if (n2 > 255) {
                bl = false;
                n = 5633;
            } else {
                String string3 = this.m_DownloadFile.getName();
                n2 = string3.length();
                if (n2 > 32) {
                    bl = false;
                    n = 5627;
                } else {
                    String string4 = "";
                    File file = null;
                    int n3 = string2.lastIndexOf("\\");
                    if (n3 > 0 && !(file = new File(string4 = string2.substring(0, n3))).isDirectory()) {
                        if (string == null) {
                            bl = false;
                            n = 5773;
                        } else {
                            bl = false;
                            n = 5628;
                        }
                    }
                    if (bl && (n3 = string2.lastIndexOf("/")) > 0 && !(file = new File(string4 = string2.substring(0, n3))).isDirectory()) {
                        if (string == null) {
                            bl = false;
                            n = 5773;
                        } else {
                            bl = false;
                            n = 5628;
                        }
                    }
                    int n4 = 0;
                    while (n4 < n2 && bl) {
                        char c = string3.charAt(n4);
                        if (c == '\"' || c == '\\' || c == '/' || c == ':' || c == ',' || c == ';' || c == '*' || c == '?' || c == '<' || c == '>' || c == '|' || c == ' ') {
                            bl = false;
                            n = 5628;
                            break;
                        }
                        ++n4;
                    }
                }
            }
            if (string == null && bl && this.m_DownloadFile.exists()) {
                if (!JwsBaseCtrl.showConfirm(REPLACE_TITLE, REPLACE_MESSAGE)) {
                    bl2 = true;
                } else if (!this.m_DownloadFile.canWrite()) {
                    bl = false;
                    n = 5774;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            JwsBaseCtrl.logWrite(exception.getMessage());
        }
        if (!bl) {
            String string5 = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, n);
            JwsBaseCtrl.showAlert("Error", string5);
            JwsBaseCtrl.logWrite("downloadCheck:" + string5);
            this.m_tfdClientFile.grabFocus();
            this.m_tfdClientFile.selectAll();
            this.m_clsAppCtrl.m_frmMainFrame.show();
            throw new JwsFtcException();
        }
        if (bl2) {
            throw new JwsFtcException();
        }
    }

    protected void downloadCheckUser() {
        try {
            String string = this.m_clsAppCtrl.m_RmiObj.getSetStatusEx();
            if (!this.m_clsAppCtrl.m_FTParam.m_strUser.equals(string.substring(4))) {
                JwsBaseCtrl.logWrite("User:" + this.m_clsAppCtrl.m_FTParam.m_strUser);
                JwsBaseCtrl.logWrite("User:" + string.substring(4));
                this.m_clsAppCtrl.setErrMessage(this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5632));
                this.m_clsAppCtrl.exitApplication(1);
            }
        }
        catch (SANRmiException sANRmiException) {
            this.m_clsAppCtrl.setErrMessage(this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(sANRmiException.nErrCode, sANRmiException.nErrData));
            JwsBaseCtrl.logWrite(sANRmiException.getMessage());
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            String string = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5634);
            this.m_clsAppCtrl.setErrMessage(string);
            JwsCommPanel.logWrite(remoteException.getMessage());
            JwsCommPanel.logWrite(string);
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (Exception exception) {
            this.m_clsAppCtrl.setErrMessage(this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5632));
            this.m_clsAppCtrl.exitApplication(1);
            JwsBaseCtrl.logWrite(exception.getMessage());
        }
    }

    public void download() throws JwsFtcException {
        try {
            this.m_startTimer.start();
            FTFileData fTFileData = this.m_clsAppCtrl.m_RmiObj.getFTConfigureDownload(0);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.m_DownloadFile));
            int n = 0;
            while (n < fTFileData.strData.length) {
                bufferedWriter.write(fTFileData.strData[n]);
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            this.m_endTimer.start();
        }
        catch (SANRmiException sANRmiException) {
            this.m_endTimer.start();
            this.m_clsAppCtrl.setErrMessage(this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(sANRmiException.nErrCode, sANRmiException.nErrData));
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (RemoteException remoteException) {
            this.m_endTimer.start();
            remoteException.printStackTrace();
            String string = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5634);
            this.m_clsAppCtrl.setErrMessage(string);
            JwsCommPanel.logWrite(remoteException.getMessage());
            JwsCommPanel.logWrite(string);
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (IOException iOException) {
            this.m_endTimer.start();
            iOException.printStackTrace();
            String string = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5775);
            JwsBaseCtrl.showAlert("Error", string);
            JwsBaseCtrl.logWrite(string);
            throw new JwsFtcException();
        }
        catch (NullPointerException nullPointerException) {
            this.m_endTimer.start();
            nullPointerException.printStackTrace();
            String string = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5634);
            this.m_clsAppCtrl.setErrMessage(string);
            JwsCommPanel.logWrite(((Throwable)nullPointerException).getMessage());
            JwsCommPanel.logWrite(string);
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (Exception exception) {
            this.m_endTimer.start();
            JwsBaseCtrl.logWrite(exception.getMessage());
        }
    }

    protected void onClientFileChanged(DocumentEvent documentEvent) {
        this.setCursor(new Cursor(3));
        this.setPanelEnabled();
        this.setCursor(new Cursor(0));
    }

    protected void onReference(ActionEvent actionEvent) {
        boolean bl = true;
        this.setCursor(new Cursor(3));
        String string = this.getClientFilePath();
        JFileChooser jFileChooser = null;
        int n = -1;
        try {
            jFileChooser = new JFileChooser(string);
            String string2 = "spd";
            String string3 = "Spreadsheet File";
            JwsFileFilter jwsFileFilter = new JwsFileFilter(string2, string3);
            jFileChooser.addChoosableFileFilter(jwsFileFilter);
            int n2 = string.lastIndexOf("\\");
            String string4 = string.substring(0, n2 + 1);
            string4 = string4 + "ArrayCf.spd";
            JwsBaseCtrl.logWrite("ShowFile : " + string4);
            File file = new File(string4);
            String string5 = file.getName();
            JwsBaseCtrl.logWrite("ShowFileName : " + string5);
            jFileChooser.setSelectedFile(file);
            n = jFileChooser.showSaveDialog(null);
        }
        catch (Exception exception) {
            this.setCursor(new Cursor(0));
            JwsBaseCtrl.logWrite(exception.getMessage());
            String string6 = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5775);
            JwsBaseCtrl.showAlert("Error", string6);
            this.setClientFilePath("");
            JwsBaseCtrl.logWrite(string6);
        }
        if (n == 0) {
            try {
                string = jFileChooser.getSelectedFile().getAbsolutePath();
                this.downloadCheck(string);
                this.setClientFilePath(this.m_strDownloadPath);
                JwsBaseCtrl.writeSetting(this.m_strDownloadPath);
                JwsBaseCtrl.logWrite("Selected Path : " + string);
            }
            catch (JwsFtcException jwsFtcException) {
                this.onReference(actionEvent);
            }
        }
        this.setCursor(new Cursor(0));
    }

    protected void onDownload(ActionEvent actionEvent) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    JwsDownloadPanel.this.setCursor(new Cursor(3));
                    JwsDownloadPanel.this.downloadStart();
                    JwsDownloadPanel.this.downloadCheck(null);
                    JwsDownloadPanel.this.download();
                    JwsDownloadPanel.this.downloadEnd();
                    JwsBaseCtrl.writeSetting(JwsDownloadPanel.this.m_DownloadFile.getPath());
                    JwsDownloadPanel.this.setCursor(new Cursor(0));
                    JwsDownloadPanel.this.m_clsAppCtrl.exitApplication(0);
                }
                catch (JwsFtcException jwsFtcException) {
                    JwsDownloadPanel.this.downloadEnd();
                    JwsDownloadPanel.this.m_clsAppCtrl.m_frmMainFrame.show();
                    JwsDownloadPanel.this.setCursor(new Cursor(0));
                }
                catch (Exception exception) {
                    JwsDownloadPanel.this.downloadEnd();
                    JwsDownloadPanel.this.setCursor(new Cursor(0));
                    JwsBaseCtrl.logWrite(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    protected void onExit(ActionEvent actionEvent) {
        JwsBaseCtrl.logWrite("onExit( )");
        this.setCursor(new Cursor(3));
        this.m_clsAppCtrl.exitApplication(0);
        this.setCursor(new Cursor(0));
    }
}

