/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sanproject.server.data.FTFileData;
import sanproject.server.data.SANRmiException;

public class JwsUploadPanel
extends JwsCommPanel {
    protected static final int INPUT_NO_ERR = 0;
    protected static final int INPUT_ERR_FILENAME = 16;
    private JTextField m_tfdClientFile;
    private JButton m_btnReference;
    private JButton m_btnUpload;
    private JButton m_btnExit;
    protected JwsFTMainCtrl m_clsAppCtrl;
    protected String m_strUploadPath;
    protected File m_UploadFile;
    protected JwsProcessDialog m_JwsProcess;
    private Timer m_startTimer = new Timer(1, null);
    protected Timer m_endTimer = new Timer(1, null);

    public JwsUploadPanel(JwsFTMainCtrl jwsFTMainCtrl) {
        this.m_clsAppCtrl = jwsFTMainCtrl;
        this.buildLayout();
        this.initPanel();
    }

    protected void finalize() throws Throwable {
        this.m_tfdClientFile = null;
        this.m_btnUpload = null;
        this.m_btnExit = null;
    }

    protected void initPanel() {
    }

    protected void buildLayout() {
        Color color = new Color(192, 192, 192);
        this.setLayout(null);
        this.setBackground(color);
        String string = JwsFTMainCtrl.UPLOAD_PANEL_CLIENTFILE_LABEL_TEXT;
        JLabel jLabel = JwsBaseCtrl.getBaseFieldLabel();
        jLabel.setText(string);
        jLabel.setBounds(new Rectangle(10, 45, 200, 30));
        jLabel.setFont(JwsBaseCtrl.m_fntAppBoldFont);
        string = JwsFTMainCtrl.UPLOAD_PANEL_CLIENTFILE_FIELD_TEXT;
        this.m_tfdClientFile = new JTextField(string);
        this.m_tfdClientFile.setBounds(new Rectangle(10, 2, 220, 26));
        this.m_tfdClientFile.setFont(JwsBaseCtrl.m_fntAppTextFont);
        this.m_tfdClientFile.setColumns(255);
        this.m_tfdClientFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                JwsUploadPanel.this.onClientFileChanged(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JwsUploadPanel.this.onClientFileChanged(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JwsUploadPanel.this.onClientFileChanged(documentEvent);
            }
        });
        string = JwsFTMainCtrl.UPLOAD_PANEL_REFERENCE_BUTTON_TEXT;
        this.m_btnReference = JwsBaseCtrl.getBaseAppButton();
        this.m_btnReference.setText(string);
        this.m_btnReference.setBounds(new Rectangle(240, 2, 120, 26));
        this.m_btnReference.setFont(JwsBaseCtrl.m_fntAppBoldFont);
        this.m_btnReference.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsUploadPanel.this.onReference(actionEvent);
            }
        });
        JPanel jPanel = JwsBaseCtrl.getBaseFieldBackPanel();
        jPanel.setBounds(new Rectangle(218, 45, 372, 30));
        jPanel.add(this.m_tfdClientFile);
        jPanel.add(this.m_btnReference);
        this.add(jLabel);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBackground(color);
        jPanel.setBounds(new Rectangle(10, 100, 580, 30));
        string = JwsFTMainCtrl.UPLOAD_PANEL_UPLOAD_BUTTON_TEXT;
        this.m_btnUpload = JwsBaseCtrl.getBaseAppButton();
        this.m_btnUpload.setText(string);
        this.m_btnUpload.setBounds(new Rectangle(358, 2, 125, 26));
        this.m_btnUpload.setFont(JwsBaseCtrl.m_fntAppBoldFont);
        this.m_btnUpload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsUploadPanel.this.onUpload(actionEvent);
            }
        });
        jPanel.add(this.m_btnUpload);
        string = JwsFTMainCtrl.UPLOAD_PANEL_EXIT_BUTTON_TEXT;
        this.m_btnExit = JwsBaseCtrl.getBaseAppButton();
        this.m_btnExit.setText(string);
        this.m_btnExit.setBounds(new Rectangle(498, 2, 80, 26));
        this.m_btnExit.setFont(JwsBaseCtrl.m_fntAppBoldFont);
        this.m_btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsUploadPanel.this.onExit(actionEvent);
            }
        });
        jPanel.add(this.m_btnExit);
        this.add(jPanel);
        this.m_startTimer.setRepeats(false);
        this.m_startTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsUploadPanel.this.startProcess();
            }
        });
        this.m_endTimer.setRepeats(false);
        this.m_endTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JwsUploadPanel.this.endProcess();
            }
        });
        this.setPanelEnabled();
    }

    public void setClientFilePath(String string) {
        this.m_tfdClientFile.setText(string);
    }

    public String getClientFilePath() {
        return new String(this.m_tfdClientFile.getText());
    }

    protected int inputCheck() {
        int n = 0;
        String string = this.getClientFilePath();
        if (string == null || string.equals("")) {
            n |= 0x10;
        }
        return n;
    }

    protected void setPanelEnabled() {
        int n = this.inputCheck();
        if ((n & 0x10) > 0) {
            this.m_btnUpload.setEnabled(false);
        } else {
            this.m_btnUpload.setEnabled(true);
        }
    }

    public void uploadStart() {
        this.m_tfdClientFile.setEnabled(false);
        this.m_btnReference.setEnabled(false);
        this.m_btnUpload.setEnabled(false);
        this.m_btnExit.setEnabled(false);
        this.m_clsAppCtrl.m_frmMainFrame.setEnabled(false);
    }

    public void uploadEnd() {
        this.m_tfdClientFile.setEnabled(true);
        this.m_btnReference.setEnabled(true);
        this.m_btnUpload.setEnabled(true);
        this.m_btnExit.setEnabled(true);
        this.m_clsAppCtrl.m_frmMainFrame.setEnabled(true);
        System.gc();
    }

    public void startProcess() {
        this.m_JwsProcess = new JwsProcessDialog(this.m_clsAppCtrl.m_frmMainFrame, "Upload", false);
        this.m_JwsProcess.show();
    }

    public void endProcess() {
        ((Component)this.m_JwsProcess).setVisible(false);
    }

    protected void uploadCheck(String string) throws JwsFtcException {
        int n;
        boolean bl;
        block17: {
            bl = true;
            n = 0;
            String string2 = null;
            try {
                if (string == null) {
                    this.uploadCheckUser();
                    string2 = this.getClientFilePath();
                } else {
                    string2 = string;
                }
                this.m_strUploadPath = string2.trim();
                int n2 = this.m_strUploadPath.length();
                if (n2 >= 4) {
                    if (!this.m_strUploadPath.substring(n2 - 4, n2).equalsIgnoreCase(".spd")) {
                        bl = false;
                        n = 5776;
                    }
                } else {
                    bl = false;
                    n = 5776;
                }
                if (!bl) break block17;
                this.m_UploadFile = new File(this.m_strUploadPath);
                n2 = this.m_strUploadPath.length();
                if (n2 > 255) {
                    bl = false;
                    n = 5633;
                    break block17;
                }
                if (this.m_UploadFile != null && !this.m_UploadFile.exists()) {
                    bl = false;
                    n = 5629;
                    break block17;
                }
                if (this.m_UploadFile != null && !this.m_UploadFile.canRead()) {
                    bl = false;
                    n = 5630;
                    break block17;
                }
                if (this.m_UploadFile != null && !this.m_UploadFile.isFile()) {
                    bl = false;
                    n = 5631;
                    break block17;
                }
                String string3 = this.m_UploadFile.getName();
                n2 = string3.length();
                if (n2 > 32) {
                    bl = false;
                    n = 5627;
                    break block17;
                }
                String string4 = "";
                File file = null;
                int n3 = string2.lastIndexOf("\\");
                if (n3 > 0 && !(file = new File(string4 = string2.substring(0, n3))).isDirectory() && string != null) {
                    bl = false;
                    n = 5628;
                }
                if (bl && (n3 = string2.lastIndexOf("/")) > 0 && !(file = new File(string4 = string2.substring(0, n3))).isDirectory() && string != null) {
                    bl = false;
                    n = 5628;
                }
                int n4 = 0;
                while (n4 < n2 && bl) {
                    char c = string3.charAt(n4);
                    if (c == '\"' || c == '\\' || c == '/' || c == ':' || c == ',' || c == ';' || c == '*' || c == '?' || c == '<' || c == '>' || c == '|' || c == ' ') {
                        bl = false;
                        n = 5628;
                        break;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                JwsBaseCtrl.logWrite(exception.getMessage());
            }
        }
        if (!bl) {
            String string5 = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, n);
            JwsBaseCtrl.showAlert("Error", string5);
            JwsBaseCtrl.logWrite("downloadCheck:" + string5);
            this.m_tfdClientFile.grabFocus();
            this.m_tfdClientFile.selectAll();
            this.m_clsAppCtrl.m_frmMainFrame.show();
            throw new JwsFtcException();
        }
    }

    protected void uploadCheckUser() {
        try {
            String string = this.m_clsAppCtrl.m_RmiObj.getSetStatusEx();
            if (!this.m_clsAppCtrl.m_FTParam.m_strUser.equals(string.substring(4))) {
                JwsBaseCtrl.logWrite("User:" + this.m_clsAppCtrl.m_FTParam.m_strUser);
                JwsBaseCtrl.logWrite("User:" + string.substring(4));
                this.m_clsAppCtrl.setErrMessage(this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5632));
                this.m_clsAppCtrl.exitApplication(1);
            }
        }
        catch (SANRmiException sANRmiException) {
            this.m_clsAppCtrl.setErrMessage(this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(sANRmiException.nErrCode, sANRmiException.nErrData));
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            String string = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5634);
            this.m_clsAppCtrl.setErrMessage(string);
            JwsCommPanel.logWrite(remoteException.getMessage());
            JwsCommPanel.logWrite(string);
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (Exception exception) {
            this.m_clsAppCtrl.setErrMessage(this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5632));
            this.m_clsAppCtrl.exitApplication(1);
            JwsBaseCtrl.logWrite(exception.getMessage());
        }
    }

    public void upload() throws JwsFtcException {
        String string = "";
        boolean bl = false;
        int n = 0;
        JwsBaseCtrl.logWrite("upload() Start");
        try {
            this.m_startTimer.start();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_UploadFile));
            if (bufferedReader != null && bufferedReader.ready()) {
                while ((string = bufferedReader.readLine()) != null) {
                    ++n;
                }
            }
            JwsBaseCtrl.logWrite("LineCnt=" + n);
            bufferedReader.close();
            FTFileData fTFileData = new FTFileData(n);
            bufferedReader = new BufferedReader(new FileReader(this.m_UploadFile));
            if (bufferedReader != null && bufferedReader.ready()) {
                int n2 = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    fTFileData.strData[n2] = string;
                    ++n2;
                }
            }
            bufferedReader.close();
            JwsBaseCtrl.logWrite("Call RMI I/F FTUpload( 0, Data ) ");
            this.m_clsAppCtrl.m_RmiObj.FTUpload(0, fTFileData);
            this.m_endTimer.start();
        }
        catch (SANRmiException sANRmiException) {
            this.m_endTimer.start();
            if (sANRmiException.nErrData == 5700 || sANRmiException.nErrData == 5701 || sANRmiException.nErrData == 5702 || sANRmiException.nErrData == 5641 || sANRmiException.nErrData == 5642) {
                String string2 = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(sANRmiException.nErrCode, sANRmiException.nErrData);
                JwsBaseCtrl.showAlert("Error", string2);
                JwsBaseCtrl.logWrite(string2);
                throw new JwsFtcException();
            }
            this.m_clsAppCtrl.setErrMessage(this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(sANRmiException.nErrCode, sANRmiException.nErrData));
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (RemoteException remoteException) {
            this.m_endTimer.start();
            remoteException.printStackTrace();
            String string3 = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5634);
            this.m_clsAppCtrl.setErrMessage(string3);
            JwsCommPanel.logWrite(remoteException.getMessage());
            JwsCommPanel.logWrite(string3);
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (IOException iOException) {
            this.m_endTimer.start();
            iOException.printStackTrace();
            String string4 = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5775);
            JwsBaseCtrl.showAlert("Error", string4);
            JwsBaseCtrl.logWrite(string4);
            throw new JwsFtcException();
        }
        catch (NullPointerException nullPointerException) {
            this.m_endTimer.start();
            nullPointerException.printStackTrace();
            String string5 = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5634);
            this.m_clsAppCtrl.setErrMessage(string5);
            JwsCommPanel.logWrite(((Throwable)nullPointerException).getMessage());
            JwsCommPanel.logWrite(string5);
            this.m_clsAppCtrl.exitApplication(1);
        }
        catch (Exception exception) {
            this.m_endTimer.start();
            this.m_clsAppCtrl.setErrMessage(exception.getMessage());
            this.m_clsAppCtrl.exitApplication(1);
        }
        JwsBaseCtrl.logWrite("upload() End");
    }

    protected void onClientFileChanged(DocumentEvent documentEvent) {
        this.setCursor(new Cursor(3));
        this.setPanelEnabled();
        this.setCursor(new Cursor(0));
    }

    protected void onReference(ActionEvent actionEvent) {
        boolean bl = true;
        this.setCursor(new Cursor(3));
        String string = this.getClientFilePath();
        JFileChooser jFileChooser = null;
        int n = -1;
        try {
            jFileChooser = new JFileChooser(string);
            String string2 = "spd";
            String string3 = "Spreadsheet File";
            JwsFileFilter jwsFileFilter = new JwsFileFilter(string2, string3);
            jFileChooser.addChoosableFileFilter(jwsFileFilter);
            n = jFileChooser.showOpenDialog(null);
        }
        catch (Exception exception) {
            this.setCursor(new Cursor(0));
            JwsBaseCtrl.logWrite(exception.getMessage());
            String string4 = this.m_clsAppCtrl.m_FTErrChg.exchangeErrCode(8111, 5775);
            JwsBaseCtrl.showAlert("Error", string4);
            this.setClientFilePath("");
            JwsBaseCtrl.logWrite(string4);
        }
        if (n == 0) {
            try {
                string = jFileChooser.getSelectedFile().getAbsolutePath();
                this.uploadCheck(string);
                this.setClientFilePath(this.m_strUploadPath);
                JwsBaseCtrl.writeSetting(this.m_strUploadPath);
                JwsBaseCtrl.logWrite("Selected Path : " + string);
            }
            catch (JwsFtcException jwsFtcException) {
                this.onReference(actionEvent);
            }
        }
        this.setCursor(new Cursor(0));
    }

    protected void onUpload(ActionEvent actionEvent) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    JwsUploadPanel.this.setCursor(new Cursor(3));
                    JwsUploadPanel.this.uploadStart();
                    JwsUploadPanel.this.uploadCheck(null);
                    JwsUploadPanel.this.upload();
                    JwsUploadPanel.this.uploadEnd();
                    JwsBaseCtrl.writeSetting(JwsUploadPanel.this.m_UploadFile.getPath());
                    JwsUploadPanel.this.setCursor(new Cursor(0));
                    JwsUploadPanel.this.m_clsAppCtrl.exitApplication(0);
                }
                catch (JwsFtcException jwsFtcException) {
                    JwsUploadPanel.this.uploadEnd();
                    JwsUploadPanel.this.m_clsAppCtrl.m_frmMainFrame.show();
                    JwsUploadPanel.this.setCursor(new Cursor(0));
                }
                catch (Exception exception) {
                    JwsUploadPanel.this.uploadEnd();
                    JwsUploadPanel.this.setCursor(new Cursor(0));
                }
            }
        };
        thread.start();
    }

    protected void onExit(ActionEvent actionEvent) {
        JwsCommPanel.debug_logWrite("onExit( )");
        this.setCursor(new Cursor(3));
        this.m_clsAppCtrl.exitApplication(0);
        this.setCursor(new Cursor(0));
    }
}

