/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAuthorizeModule;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationGroupException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExGetGroupException;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSecureUty;

public class SJbaseAuthenticationAuthorizationExternal
implements SJbaseAuthenticationModulePluginInterface {
    private final String LOG_FUNCTION = "SJbaseAuthenticationAuthorizationExternal";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private static String szMsg;
    private String m_szUserName = null;
    private String m_SessionID = null;
    private String[] m_szGroupName = null;
    private SJbaseExternalAccountInfo m_clsAccountInfo = null;
    private String m_szPassword = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int authentication(String szUserName, String szPassword) {
        String LOG_SUBTITLE = "authentication";
        int iRet = 6;
        try {
            szMsg = "<" + szUserName + ">Start.";
            SJcLogUty.getLogger().info("SJbaseAuthenticationAuthorizationExternal", this.LOG_TITLE, "authentication", szMsg);
            SJbaseExternalAuthorizeModule clsExternal = new SJbaseExternalAuthorizeModule();
            this.m_clsAccountInfo = clsExternal.login(szUserName, szPassword);
            iRet = 0;
            this.m_szUserName = szUserName;
            this.m_szPassword = szPassword;
            String szUuid = UUID.randomUUID().toString().replaceAll("-", "");
            String szSession = szUserName + szPassword + szUuid;
            this.m_SessionID = SJcSecureUty.getHashValueStringHex(szSession).substring(0, 32);
            ArrayList<String> userGroup = new ArrayList<String>();
            String[] szGroupName = this.m_clsAccountInfo.getUserGroup();
            for (int i = 0; i < szGroupName.length; ++i) {
                userGroup.add(szGroupName[i]);
            }
            this.m_szGroupName = userGroup.toArray(new String[0]);
        }
        catch (SJbaseExAuthenticationException e) {
            iRet = 6;
        }
        catch (SJbaseExGetGroupException e) {
            iRet = 3;
        }
        catch (SJbaseExCommunicationGroupException e) {
            iRet = 3;
        }
        catch (SJbaseExCommunicationException e) {
            iRet = 8;
        }
        catch (Exception e) {
            iRet = 11;
            szMsg = "<" + szUserName + ">";
            SJcLogUty.getLogger().error("SJbaseAuthenticationAuthorizationExternal", this.LOG_TITLE, "authentication", szMsg, e);
        }
        finally {
            szMsg = "<" + szUserName + ">End. - status:" + iRet;
            SJcLogUty.getLogger().info("SJbaseAuthenticationAuthorizationExternal", this.LOG_TITLE, "authentication", szMsg);
        }
        return iRet;
    }

    @Override
    public String getUserName() {
        return this.m_szUserName;
    }

    @Override
    public String[] getGroupID() {
        return this.m_szGroupName;
    }

    @Override
    public String getSessionID() {
        return this.m_SessionID;
    }

    @Override
    public String getAuthSystemName(String szSystem) {
        return szSystem;
    }

    @Override
    public HashMap getAuthObject() {
        return null;
    }

    @Override
    public String[] getRoleID() {
        return null;
    }

    @Override
    public boolean[] getResourceGrpMap() {
        return null;
    }

    @Override
    public boolean isAllRSG() {
        return false;
    }

    @Override
    public boolean[] getRoleMap() {
        return null;
    }

    @Override
    public String getPassword() {
        return this.m_szPassword;
    }
}

