/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.Logger;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcAuditLogSessionManager {
    private static WeakHashMap<SJbaseUserSession, WeakReference<Integer>> LOG_SESSION_ID_MAP = new WeakHashMap();
    private static int COUNT = 1;
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String LOG_FUNCTION = "SJcAuditLogSessionManager";
    private static final String LOG_TITLE = "SJcAuditLogSessionManager";
    private static final int LIM_SESSION_NUM = 32;
    private static int MAX_SESSION_NUM = -1;

    public static void clear() {
        LOG_SESSION_ID_MAP.clear();
        COUNT = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSessionID(SJbaseUserSession us) {
        String LOG_SUBTITLE = "getSessionID";
        int logSesId = 0;
        logger.info("SJcAuditLogSessionManager", "SJcAuditLogSessionManager", LOG_SUBTITLE, "Start. -us:" + us);
        WeakHashMap<SJbaseUserSession, WeakReference<Integer>> weakHashMap = LOG_SESSION_ID_MAP;
        synchronized (weakHashMap) {
            WeakReference<Integer> reference = LOG_SESSION_ID_MAP.get(us);
            if (reference == null) {
                logSesId = SJcAuditLogSessionManager.getAvailableSessionID(COUNT);
                if (logSesId == 0) {
                    logSesId = 1;
                    logger.warn("SJcAuditLogSessionManager", LOG_SUBTITLE, "", "The number of logSessionId is over. - env:SN_Base_LimitSessionNum " + MAX_SESSION_NUM);
                }
                LOG_SESSION_ID_MAP.put(us, new WeakReference<Integer>(logSesId));
                COUNT = logSesId + 1;
                if (COUNT > MAX_SESSION_NUM + 1) {
                    COUNT = 1;
                }
            } else {
                logSesId = (Integer)reference.get();
            }
            logger.info("SJcAuditLogSessionManager", "SJcAuditLogSessionManager", LOG_SUBTITLE, "End. -return:" + logSesId);
            return logSesId;
        }
    }

    private static int getAvailableSessionID(int sesId) {
        int startCount = sesId;
        int avaCount = 0;
        String LOG_SUBTITLE = "getAvailableSessionID";
        logger.trace("SJcAuditLogSessionManager", "SJcAuditLogSessionManager", LOG_SUBTITLE, "Start. -sesId:" + sesId);
        if (MAX_SESSION_NUM == -1) {
            String val = SJcEnvUty.getProperty("SN_Base_LimitSessionNum");
            if (null != val) {
                try {
                    MAX_SESSION_NUM = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (MAX_SESSION_NUM < 0) {
                MAX_SESSION_NUM = 32;
                logger.warn("SJcAuditLogSessionManager", "SJcAuditLogSessionManager", LOG_SUBTITLE, "Cannot establish the number of the maximum sessions. ");
            }
        }
        Iterator<SJbaseUserSession> it = LOG_SESSION_ID_MAP.keySet().iterator();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (it.hasNext()) {
            int count = (Integer)LOG_SESSION_ID_MAP.get(it.next()).get();
            list.add(count);
            ++i;
        }
        while (sesId <= MAX_SESSION_NUM + 1) {
            if (!list.contains(sesId)) {
                avaCount = sesId;
                break;
            }
            ++sesId;
        }
        if (avaCount == 0) {
            for (i = 1; i < startCount; ++i) {
                if (list.contains(i)) continue;
                avaCount = i;
                break;
            }
        }
        logger.trace("SJcAuditLogSessionManager", "SJcAuditLogSessionManager", LOG_SUBTITLE, "End. -return:" + avaCount);
        return avaCount;
    }
}

